// mojo/public/mojom/base/values.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/values.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "mojo/public/cpp/base/values_mojom_traits.h"
#include "base/component_export.h"




namespace mojo_base::mojom {







class COMPONENT_EXPORT(MOJO_BASE_MOJOM) Value {
 public:
  using DataView = ValueDataView;
  using Data_ = internal::Value_Data;
  using Tag = Data_::Value_Tag;

  template <typename... Args>
  static ValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |null_value|.
  static ValuePtr NewNullValue(
      uint8_t value);
  // Construct an instance holding |bool_value|.
  static ValuePtr NewBoolValue(
      bool value);
  // Construct an instance holding |int_value|.
  static ValuePtr NewIntValue(
      int32_t value);
  // Construct an instance holding |double_value|.
  static ValuePtr NewDoubleValue(
      double value);
  // Construct an instance holding |string_value|.
  static ValuePtr NewStringValue(
      const std::string& value);
  // Construct an instance holding |binary_value|.
  static ValuePtr NewBinaryValue(
      std::vector<uint8_t> value);
  // Construct an instance holding |dictionary_value|.
  static ValuePtr NewDictionaryValue(
      ::base::Value::Dict value);
  // Construct an instance holding |list_value|.
  static ValuePtr NewListValue(
      ::base::Value::List value);

  template <typename U>
  static ValuePtr From(const U& u) {
    return mojo::TypeConverter<ValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Value>::Convert(*this);
  }
  ~Value();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  Value(const Value& other) = delete;
  Value& operator=(const Value& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ValuePtr>
  ValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Value>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, Value>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_null_value() const { return tag_ == Tag::kNullValue; }
  uint8_t get_null_value() const {
    CHECK(tag_ == Tag::kNullValue);
    return data_.null_value;
  }
  void set_null_value(uint8_t null_value);

  bool is_bool_value() const { return tag_ == Tag::kBoolValue; }
  bool get_bool_value() const {
    CHECK(tag_ == Tag::kBoolValue);
    return data_.bool_value;
  }
  void set_bool_value(bool bool_value);

  bool is_int_value() const { return tag_ == Tag::kIntValue; }
  int32_t get_int_value() const {
    CHECK(tag_ == Tag::kIntValue);
    return data_.int_value;
  }
  void set_int_value(int32_t int_value);

  bool is_double_value() const { return tag_ == Tag::kDoubleValue; }
  double get_double_value() const {
    CHECK(tag_ == Tag::kDoubleValue);
    return data_.double_value;
  }
  void set_double_value(double double_value);

  bool is_string_value() const { return tag_ == Tag::kStringValue; }
  const std::string& get_string_value() const {
    CHECK(tag_ == Tag::kStringValue);
    return data_.string_value;
  }
  std::string& get_string_value() {
    CHECK(tag_ == Tag::kStringValue);
    return data_.string_value;
  }
  void set_string_value(const std::string& string_value);

  bool is_binary_value() const { return tag_ == Tag::kBinaryValue; }
  const std::vector<uint8_t>& get_binary_value() const {
    CHECK(tag_ == Tag::kBinaryValue);
    return data_.binary_value;
  }
  std::vector<uint8_t>& get_binary_value() {
    CHECK(tag_ == Tag::kBinaryValue);
    return data_.binary_value;
  }
  void set_binary_value(std::vector<uint8_t> binary_value);

  bool is_dictionary_value() const { return tag_ == Tag::kDictionaryValue; }
  const ::base::Value::Dict& get_dictionary_value() const {
    CHECK(tag_ == Tag::kDictionaryValue);
    return data_.dictionary_value;
  }
  ::base::Value::Dict& get_dictionary_value() {
    CHECK(tag_ == Tag::kDictionaryValue);
    return data_.dictionary_value;
  }
  void set_dictionary_value(::base::Value::Dict dictionary_value);

  bool is_list_value() const { return tag_ == Tag::kListValue; }
  const ::base::Value::List& get_list_value() const {
    CHECK(tag_ == Tag::kListValue);
    return data_.list_value;
  }
  ::base::Value::List& get_list_value() {
    CHECK(tag_ == Tag::kListValue);
    return data_.list_value;
  }
  void set_list_value(::base::Value::List list_value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Value::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<Value::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNullValue)>,
        uint8_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
        int32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDoubleValue)>,
        double value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kStringValue)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBinaryValue)>,
        std::vector<uint8_t> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDictionaryValue)>,
        ::base::Value::Dict value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kListValue)>,
        ::base::Value::List value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    uint8_t null_value;
    bool bool_value;
    int32_t int_value;
    double double_value;
    std::string string_value;
    std::vector<uint8_t> binary_value;
    ::base::Value::Dict dictionary_value;
    ::base::Value::List list_value;
  };

  Value(
      std::in_place_index_t<static_cast<size_t>(Tag::kNullValue)>,
      uint8_t value);
  Value(
      std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
      bool value);
  Value(
      std::in_place_index_t<static_cast<size_t>(Tag::kIntValue)>,
      int32_t value);
  Value(
      std::in_place_index_t<static_cast<size_t>(Tag::kDoubleValue)>,
      double value);
  Value(
      std::in_place_index_t<static_cast<size_t>(Tag::kStringValue)>,
      const std::string& value);
  Value(
      std::in_place_index_t<static_cast<size_t>(Tag::kBinaryValue)>,
      std::vector<uint8_t> value);
  Value(
      std::in_place_index_t<static_cast<size_t>(Tag::kDictionaryValue)>,
      ::base::Value::Dict value);
  Value(
      std::in_place_index_t<static_cast<size_t>(Tag::kListValue)>,
      ::base::Value::List value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) DictionaryValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DictionaryValue, T>::value>;
  using DataView = DictionaryValueDataView;
  using Data_ = internal::DictionaryValue_Data;

  template <typename... Args>
  static DictionaryValuePtr New(Args&&... args) {
    return DictionaryValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DictionaryValuePtr From(const U& u) {
    return mojo::TypeConverter<DictionaryValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DictionaryValue>::Convert(*this);
  }


  DictionaryValue();

  explicit DictionaryValue(
      base::flat_map<std::string, ::base::Value> storage);

DictionaryValue(const DictionaryValue&) = delete;
DictionaryValue& operator=(const DictionaryValue&) = delete;

  ~DictionaryValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DictionaryValuePtr>
  DictionaryValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DictionaryValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DictionaryValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DictionaryValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DictionaryValue::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DictionaryValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DictionaryValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DictionaryValue_UnserializedMessageContext<
            UserType, DictionaryValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DictionaryValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DictionaryValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DictionaryValue_UnserializedMessageContext<
            UserType, DictionaryValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DictionaryValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<std::string, ::base::Value> storage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DictionaryValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DictionaryValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DictionaryValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DictionaryValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) ListValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ListValue, T>::value>;
  using DataView = ListValueDataView;
  using Data_ = internal::ListValue_Data;

  template <typename... Args>
  static ListValuePtr New(Args&&... args) {
    return ListValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ListValuePtr From(const U& u) {
    return mojo::TypeConverter<ListValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ListValue>::Convert(*this);
  }


  ListValue();

  explicit ListValue(
      std::vector<::base::Value> storage);

ListValue(const ListValue&) = delete;
ListValue& operator=(const ListValue&) = delete;

  ~ListValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ListValuePtr>
  ListValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ListValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ListValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ListValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ListValue::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ListValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ListValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ListValue_UnserializedMessageContext<
            UserType, ListValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ListValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ListValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ListValue_UnserializedMessageContext<
            UserType, ListValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ListValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::base::Value> storage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ListValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ListValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ListValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ListValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ValuePtr Value::Clone() const {
  switch (tag_) {
    case Tag::kNullValue:
      return NewNullValue(
          mojo::Clone(data_.null_value));
    case Tag::kBoolValue:
      return NewBoolValue(
          mojo::Clone(data_.bool_value));
    case Tag::kIntValue:
      return NewIntValue(
          mojo::Clone(data_.int_value));
    case Tag::kDoubleValue:
      return NewDoubleValue(
          mojo::Clone(data_.double_value));
    case Tag::kStringValue:
      return NewStringValue(
          mojo::Clone(data_.string_value));
    case Tag::kBinaryValue:
      return NewBinaryValue(
          mojo::Clone(data_.binary_value));
    case Tag::kDictionaryValue:
      return NewDictionaryValue(
          mojo::Clone(data_.dictionary_value));
    case Tag::kListValue:
      return NewListValue(
          mojo::Clone(data_.list_value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Value>::value>::type*>
bool Value::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNullValue:
      return mojo::Equals(data_.null_value, other.data_.null_value);
    case Tag::kBoolValue:
      return mojo::Equals(data_.bool_value, other.data_.bool_value);
    case Tag::kIntValue:
      return mojo::Equals(data_.int_value, other.data_.int_value);
    case Tag::kDoubleValue:
      return mojo::Equals(data_.double_value, other.data_.double_value);
    case Tag::kStringValue:
      return mojo::Equals(data_.string_value, other.data_.string_value);
    case Tag::kBinaryValue:
      return mojo::Equals(data_.binary_value, other.data_.binary_value);
    case Tag::kDictionaryValue:
      return mojo::Equals(data_.dictionary_value, other.data_.dictionary_value);
    case Tag::kListValue:
      return mojo::Equals(data_.list_value, other.data_.list_value);
  }

  return false;
}
template <typename StructPtrType>
DictionaryValuePtr DictionaryValue::Clone() const {
  return New(
      mojo::Clone(storage)
  );
}

template <typename T, DictionaryValue::EnableIfSame<T>*>
bool DictionaryValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->storage, other_struct.storage))
    return false;
  return true;
}

template <typename T, DictionaryValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.storage < rhs.storage)
    return true;
  if (rhs.storage < lhs.storage)
    return false;
  return false;
}
template <typename StructPtrType>
ListValuePtr ListValue::Clone() const {
  return New(
      mojo::Clone(storage)
  );
}

template <typename T, ListValue::EnableIfSame<T>*>
bool ListValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->storage, other_struct.storage))
    return false;
  return true;
}

template <typename T, ListValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.storage < rhs.storage)
    return true;
  if (rhs.storage < lhs.storage)
    return false;
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::DictionaryValue::DataView,
                                         ::mojo_base::mojom::DictionaryValuePtr> {
  static bool IsNull(const ::mojo_base::mojom::DictionaryValuePtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::DictionaryValuePtr* output) { output->reset(); }

  static const decltype(::mojo_base::mojom::DictionaryValue::storage)& storage(
      const ::mojo_base::mojom::DictionaryValuePtr& input) {
    return input->storage;
  }

  static bool Read(::mojo_base::mojom::DictionaryValue::DataView input, ::mojo_base::mojom::DictionaryValuePtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::ListValue::DataView,
                                         ::mojo_base::mojom::ListValuePtr> {
  static bool IsNull(const ::mojo_base::mojom::ListValuePtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::ListValuePtr* output) { output->reset(); }

  static const decltype(::mojo_base::mojom::ListValue::storage)& storage(
      const ::mojo_base::mojom::ListValuePtr& input) {
    return input->storage;
  }

  static bool Read(::mojo_base::mojom::ListValue::DataView input, ::mojo_base::mojom::ListValuePtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) UnionTraits<::mojo_base::mojom::Value::DataView,
                                        ::mojo_base::mojom::ValuePtr> {
  static bool IsNull(const ::mojo_base::mojom::ValuePtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::ValuePtr* output) { output->reset(); }

  static ::mojo_base::mojom::Value::Tag GetTag(const ::mojo_base::mojom::ValuePtr& input) {
    return input->which();
  }

  static  uint8_t null_value(const ::mojo_base::mojom::ValuePtr& input) {
    return input->get_null_value();
  }

  static  bool bool_value(const ::mojo_base::mojom::ValuePtr& input) {
    return input->get_bool_value();
  }

  static  int32_t int_value(const ::mojo_base::mojom::ValuePtr& input) {
    return input->get_int_value();
  }

  static  double double_value(const ::mojo_base::mojom::ValuePtr& input) {
    return input->get_double_value();
  }

  static const std::string& string_value(const ::mojo_base::mojom::ValuePtr& input) {
    return input->get_string_value();
  }

  static const std::vector<uint8_t>& binary_value(const ::mojo_base::mojom::ValuePtr& input) {
    return input->get_binary_value();
  }

  static const ::base::Value::Dict& dictionary_value(const ::mojo_base::mojom::ValuePtr& input) {
    return input->get_dictionary_value();
  }

  static const ::base::Value::List& list_value(const ::mojo_base::mojom::ValuePtr& input) {
    return input->get_list_value();
  }

  static bool Read(::mojo_base::mojom::Value::DataView input, ::mojo_base::mojom::ValuePtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_H_