// mojo/public/mojom/base/values.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_SHARED_H_
#define MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/values.mojom-shared-internal.h"




#include "mojo/public/mojom/base/values.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::DictionaryValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::DictionaryValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::DictionaryValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::storage(input)) in_storage = Traits::storage(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->storage)::BaseType>
        storage_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& storage_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::ValueDataView>>(
      in_storage,
      storage_fragment,
      &storage_validate_params);

    fragment->storage.Set(
        storage_fragment.is_null() ? nullptr : storage_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->storage.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage in DictionaryValue struct");
  }

  static bool Deserialize(::mojo_base::mojom::internal::DictionaryValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::DictionaryValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::ListValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::ListValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::ListValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::storage(input)) in_storage = Traits::storage(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->storage)::BaseType>
        storage_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& storage_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ValueDataView>>(
      in_storage,
      storage_fragment,
      &storage_validate_params);

    fragment->storage.Set(
        storage_fragment.is_null() ? nullptr : storage_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->storage.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage in ListValue struct");
  }

  static bool Deserialize(::mojo_base::mojom::internal::ListValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::ListValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::ValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojo_base::mojom::ValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojo_base::mojom::internal::Value_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojo_base::mojom::ValueDataView::Tag::kNullValue: {
    decltype(Traits::null_value(input))
    in_null_value = Traits::null_value(input);
    fragment->data.f_null_value = in_null_value;
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kBoolValue: {
    decltype(Traits::bool_value(input))
    in_bool_value = Traits::bool_value(input);
    fragment->data.f_bool_value = in_bool_value;
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kIntValue: {
    decltype(Traits::int_value(input))
    in_int_value = Traits::int_value(input);
    fragment->data.f_int_value = in_int_value;
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kDoubleValue: {
    decltype(Traits::double_value(input))
    in_double_value = Traits::double_value(input);
    fragment->data.f_double_value = in_double_value;
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kStringValue: {
    decltype(Traits::string_value(input))
    in_string_value = Traits::string_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_string_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string_value in Value union");
    fragment->data.f_string_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kBinaryValue: {
    decltype(Traits::binary_value(input))
    in_binary_value = Traits::binary_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_binary_value)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& binary_value_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
  in_binary_value,
  value_fragment,
  &binary_value_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null binary_value in Value union");
    fragment->data.f_binary_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kDictionaryValue: {
    decltype(Traits::dictionary_value(input))
    in_dictionary_value = Traits::dictionary_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_dictionary_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
  in_dictionary_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null dictionary_value in Value union");
    fragment->data.f_dictionary_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kListValue: {
    decltype(Traits::list_value(input))
    in_list_value = Traits::list_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_list_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
  in_list_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null list_value in Value union");
    fragment->data.f_list_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::mojo_base::mojom::internal::Value_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::ValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojo_base::mojom {

inline void DictionaryValueDataView::GetStorageDataView(
    mojo::MapDataView<mojo::StringDataView, ValueDataView>* output) {
  auto pointer = data_->storage.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ValueDataView>(pointer, message_);
}


inline void ListValueDataView::GetStorageDataView(
    mojo::ArrayDataView<ValueDataView>* output) {
  auto pointer = data_->storage.Get();
  *output = mojo::ArrayDataView<ValueDataView>(pointer, message_);
}


inline void ValueDataView::GetStringValueDataView(
    mojo::StringDataView* output) const {
  CHECK(is_string_value());
  *output = mojo::StringDataView(data_->data.f_string_value.Get(), message_);
}
inline void ValueDataView::GetBinaryValueDataView(
    mojo::ArrayDataView<uint8_t>* output) const {
  CHECK(is_binary_value());
  *output = mojo::ArrayDataView<uint8_t>(data_->data.f_binary_value.Get(), message_);
}
inline void ValueDataView::GetDictionaryValueDataView(
    DictionaryValueDataView* output) const {
  CHECK(is_dictionary_value());
  *output = DictionaryValueDataView(data_->data.f_dictionary_value.Get(), message_);
}
inline void ValueDataView::GetListValueDataView(
    ListValueDataView* output) const {
  CHECK(is_list_value());
  *output = ListValueDataView(data_->data.f_list_value.Get(), message_);
}


}  // mojo_base::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_SHARED_H_