// mojo/public/mojom/base/token.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'mojo/public/mojom/base/token.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mojoBase.mojom');



  function Token(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Token.prototype.initDefaults_ = function() {
    this.high = 0;
    this.low = 0;
  };
  Token.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Token.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Token.encodedSize = codec.kStructHeaderSize + 16;

  Token.decode = function(decoder) {
    var packed;
    var val = new Token();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.high =
        decoder.decodeStruct(codec.Uint64);
    val.low =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  Token.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Token.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.high);
    encoder.encodeStruct(codec.Uint64, val.low);
  };
  exports.Token = Token;
})();