// mojo/public/mojom/base/safe_base_name.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'mojo/public/mojom/base/safe_base_name.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mojoBase.mojom');
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', 'file_path.mojom.js');
  }



  function SafeBaseName(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SafeBaseName.prototype.initDefaults_ = function() {
    this.path = null;
  };
  SafeBaseName.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SafeBaseName.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SafeBaseName.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SafeBaseName.encodedSize = codec.kStructHeaderSize + 8;

  SafeBaseName.decode = function(decoder) {
    var packed;
    var val = new SafeBaseName();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  SafeBaseName.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SafeBaseName.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
  };
  exports.SafeBaseName = SafeBaseName;
})();