// mojo/public/mojom/base/read_only_buffer.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_READ_ONLY_BUFFER_MOJOM_BLINK_H_
#define MOJO_PUBLIC_MOJOM_BASE_READ_ONLY_BUFFER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/read_only_buffer.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/read_only_buffer.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "mojo/public/cpp/base/read_only_buffer_mojom_traits.h"
#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace mojo_base::mojom::blink {








class COMPONENT_EXPORT(MOJO_BASE_MOJOM_BLINK) ReadOnlyBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadOnlyBuffer, T>::value>;
  using DataView = ReadOnlyBufferDataView;
  using Data_ = internal::ReadOnlyBuffer_Data;

  template <typename... Args>
  static ReadOnlyBufferPtr New(Args&&... args) {
    return ReadOnlyBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadOnlyBufferPtr From(const U& u) {
    return mojo::TypeConverter<ReadOnlyBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadOnlyBuffer>::Convert(*this);
  }


  ReadOnlyBuffer();

  explicit ReadOnlyBuffer(
      ::blink::Vector<uint8_t> buffer);


  ~ReadOnlyBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadOnlyBufferPtr>
  ReadOnlyBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadOnlyBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadOnlyBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadOnlyBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadOnlyBuffer::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadOnlyBuffer::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadOnlyBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadOnlyBuffer_UnserializedMessageContext<
            UserType, ReadOnlyBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadOnlyBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadOnlyBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadOnlyBuffer_UnserializedMessageContext<
            UserType, ReadOnlyBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadOnlyBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<uint8_t> buffer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadOnlyBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadOnlyBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadOnlyBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadOnlyBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ReadOnlyBufferPtr ReadOnlyBuffer::Clone() const {
  return New(
      mojo::Clone(buffer)
  );
}

template <typename T, ReadOnlyBuffer::EnableIfSame<T>*>
bool ReadOnlyBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->buffer, other_struct.buffer))
    return false;
  return true;
}

template <typename T, ReadOnlyBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.buffer < rhs.buffer)
    return true;
  if (rhs.buffer < lhs.buffer)
    return false;
  return false;
}


}  // mojo_base::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM_BLINK) StructTraits<::mojo_base::mojom::blink::ReadOnlyBuffer::DataView,
                                         ::mojo_base::mojom::blink::ReadOnlyBufferPtr> {
  static bool IsNull(const ::mojo_base::mojom::blink::ReadOnlyBufferPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::blink::ReadOnlyBufferPtr* output) { output->reset(); }

  static const decltype(::mojo_base::mojom::blink::ReadOnlyBuffer::buffer)& buffer(
      const ::mojo_base::mojom::blink::ReadOnlyBufferPtr& input) {
    return input->buffer;
  }

  static bool Read(::mojo_base::mojom::blink::ReadOnlyBuffer::DataView input, ::mojo_base::mojom::blink::ReadOnlyBufferPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_READ_ONLY_BUFFER_MOJOM_BLINK_H_