// mojo/public/mojom/base/proto_wrapper.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_PROTO_WRAPPER_MOJOM_SHARED_H_
#define MOJO_PUBLIC_MOJOM_BASE_PROTO_WRAPPER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/proto_wrapper.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "mojo/public/mojom/base/proto_wrapper.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::ProtoWrapperDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::ProtoWrapperDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::ProtoWrapper_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::proto_name(input)) in_proto_name = Traits::proto_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proto_name)::BaseType> proto_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_proto_name,
      proto_name_fragment);

    fragment->proto_name.Set(
        proto_name_fragment.is_null() ? nullptr : proto_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proto_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proto_name in ProtoWrapper struct");

    decltype(Traits::smuggled(input)) in_smuggled = Traits::smuggled(input);
    mojo::internal::MessageFragment<decltype(fragment->smuggled)>
        smuggled_fragment(fragment.message());
    smuggled_fragment.Claim(&fragment->smuggled);
    
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_smuggled,
      smuggled_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->smuggled.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null smuggled in ProtoWrapper struct");
  }

  static bool Deserialize(::mojo_base::mojom::internal::ProtoWrapper_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::ProtoWrapperDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojo_base::mojom {

inline void ProtoWrapperDataView::GetProtoNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->proto_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ProtoWrapperDataView::GetSmuggledDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->smuggled;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}



}  // mojo_base::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MOJO_PUBLIC_MOJOM_BASE_PROTO_WRAPPER_MOJOM_SHARED_H_