// mojo/public/mojom/base/jserror.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_JSERROR_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_JSERROR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/jserror.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/jserror.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/jserror.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "base/component_export.h"




namespace mojo_base::mojom {





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) JsError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<JsError, T>::value>;
  using DataView = JsErrorDataView;
  using Data_ = internal::JsError_Data;

  template <typename... Args>
  static JsErrorPtr New(Args&&... args) {
    return JsErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static JsErrorPtr From(const U& u) {
    return mojo::TypeConverter<JsErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, JsError>::Convert(*this);
  }


  JsError();

  JsError(
      const std::optional<std::string>& name,
      const std::optional<std::string>& cause,
      const std::optional<std::string>& message);


  ~JsError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = JsErrorPtr>
  JsErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, JsError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, JsError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, JsError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JsError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JsError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        JsError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::JsError_UnserializedMessageContext<
            UserType, JsError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<JsError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return JsError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::JsError_UnserializedMessageContext<
            UserType, JsError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<JsError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> name;
  
  std::optional<std::string> cause;
  
  std::optional<std::string> message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, JsError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, JsError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, JsError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, JsError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
JsErrorPtr JsError::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(cause),
      mojo::Clone(message)
  );
}

template <typename T, JsError::EnableIfSame<T>*>
bool JsError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->cause, other_struct.cause))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, JsError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.cause < rhs.cause)
    return true;
  if (rhs.cause < lhs.cause)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::JsError::DataView,
                                         ::mojo_base::mojom::JsErrorPtr> {
  static bool IsNull(const ::mojo_base::mojom::JsErrorPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::JsErrorPtr* output) { output->reset(); }

  static const decltype(::mojo_base::mojom::JsError::name)& name(
      const ::mojo_base::mojom::JsErrorPtr& input) {
    return input->name;
  }

  static const decltype(::mojo_base::mojom::JsError::cause)& cause(
      const ::mojo_base::mojom::JsErrorPtr& input) {
    return input->cause;
  }

  static const decltype(::mojo_base::mojom::JsError::message)& message(
      const ::mojo_base::mojom::JsErrorPtr& input) {
    return input->message;
  }

  static bool Read(::mojo_base::mojom::JsError::DataView input, ::mojo_base::mojom::JsErrorPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_JSERROR_MOJOM_H_