// mojo/public/mojom/base/int128.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'mojo/public/mojom/base/int128.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mojoBase.mojom');



  function Int128(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Int128.prototype.initDefaults_ = function() {
    this.high = 0;
    this.low = 0;
  };
  Int128.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Int128.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Int128.encodedSize = codec.kStructHeaderSize + 16;

  Int128.decode = function(decoder) {
    var packed;
    var val = new Int128();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.high =
        decoder.decodeStruct(codec.Int64);
    val.low =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  Int128.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Int128.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.high);
    encoder.encodeStruct(codec.Uint64, val.low);
  };
  function Uint128(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Uint128.prototype.initDefaults_ = function() {
    this.high = 0;
    this.low = 0;
  };
  Uint128.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Uint128.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Uint128.encodedSize = codec.kStructHeaderSize + 16;

  Uint128.decode = function(decoder) {
    var packed;
    var val = new Uint128();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.high =
        decoder.decodeStruct(codec.Uint64);
    val.low =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  Uint128.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Uint128.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.high);
    encoder.encodeStruct(codec.Uint64, val.low);
  };
  exports.Int128 = Int128;
  exports.Uint128 = Uint128;
})();