// mojo/public/mojom/base/generic_pending_associated_receiver.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_GENERIC_PENDING_ASSOCIATED_RECEIVER_MOJOM_BLINK_H_
#define MOJO_PUBLIC_MOJOM_BASE_GENERIC_PENDING_ASSOCIATED_RECEIVER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/generic_pending_associated_receiver.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/generic_pending_associated_receiver.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/generic_pending_associated_receiver.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/base/generic_pending_associated_receiver_mojom_traits.h"
#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace mojo_base::mojom::blink {

class GenericAssociatedInterfaceProxy;

template <typename ImplRefTraits>
class GenericAssociatedInterfaceStub;

class GenericAssociatedInterfaceRequestValidator;


class COMPONENT_EXPORT(MOJO_BASE_MOJOM_BLINK) GenericAssociatedInterface
    : public GenericAssociatedInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mojo_base.mojom.GenericAssociatedInterface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GenericAssociatedInterfaceInterfaceBase;
  using Proxy_ = GenericAssociatedInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = GenericAssociatedInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = GenericAssociatedInterfaceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GenericAssociatedInterface() = default;
};



class COMPONENT_EXPORT(MOJO_BASE_MOJOM_BLINK) GenericAssociatedInterfaceProxy
    : public GenericAssociatedInterface {
 public:
  using InterfaceType = GenericAssociatedInterface;

  explicit GenericAssociatedInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(MOJO_BASE_MOJOM_BLINK) GenericAssociatedInterfaceStubDispatch {
 public:
  static bool Accept(GenericAssociatedInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GenericAssociatedInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GenericAssociatedInterface>>
class GenericAssociatedInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GenericAssociatedInterfaceStub() = default;
  ~GenericAssociatedInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GenericAssociatedInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GenericAssociatedInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(MOJO_BASE_MOJOM_BLINK) GenericAssociatedInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class COMPONENT_EXPORT(MOJO_BASE_MOJOM_BLINK) GenericPendingAssociatedReceiver {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GenericPendingAssociatedReceiver, T>::value>;
  using DataView = GenericPendingAssociatedReceiverDataView;
  using Data_ = internal::GenericPendingAssociatedReceiver_Data;

  template <typename... Args>
  static GenericPendingAssociatedReceiverPtr New(Args&&... args) {
    return GenericPendingAssociatedReceiverPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GenericPendingAssociatedReceiverPtr From(const U& u) {
    return mojo::TypeConverter<GenericPendingAssociatedReceiverPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GenericPendingAssociatedReceiver>::Convert(*this);
  }


  GenericPendingAssociatedReceiver();

  GenericPendingAssociatedReceiver(
      const ::blink::String& interface_name,
      ::mojo::PendingAssociatedReceiver<GenericAssociatedInterface> receiver);

GenericPendingAssociatedReceiver(const GenericPendingAssociatedReceiver&) = delete;
GenericPendingAssociatedReceiver& operator=(const GenericPendingAssociatedReceiver&) = delete;

  ~GenericPendingAssociatedReceiver();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GenericPendingAssociatedReceiverPtr>
  GenericPendingAssociatedReceiverPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GenericPendingAssociatedReceiver::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GenericPendingAssociatedReceiver::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GenericPendingAssociatedReceiver::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GenericPendingAssociatedReceiver::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GenericPendingAssociatedReceiver_UnserializedMessageContext<
            UserType, GenericPendingAssociatedReceiver::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GenericPendingAssociatedReceiver::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GenericPendingAssociatedReceiver::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GenericPendingAssociatedReceiver_UnserializedMessageContext<
            UserType, GenericPendingAssociatedReceiver::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GenericPendingAssociatedReceiver::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String interface_name;
  
  ::mojo::PendingAssociatedReceiver<GenericAssociatedInterface> receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GenericPendingAssociatedReceiver::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GenericPendingAssociatedReceiver::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GenericPendingAssociatedReceiver::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GenericPendingAssociatedReceiver::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GenericPendingAssociatedReceiverPtr GenericPendingAssociatedReceiver::Clone() const {
  return New(
      mojo::Clone(interface_name),
      mojo::Clone(receiver)
  );
}

template <typename T, GenericPendingAssociatedReceiver::EnableIfSame<T>*>
bool GenericPendingAssociatedReceiver::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interface_name, other_struct.interface_name))
    return false;
  if (!mojo::Equals(this->receiver, other_struct.receiver))
    return false;
  return true;
}

template <typename T, GenericPendingAssociatedReceiver::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.interface_name < rhs.interface_name)
    return true;
  if (rhs.interface_name < lhs.interface_name)
    return false;
  if (lhs.receiver < rhs.receiver)
    return true;
  if (rhs.receiver < lhs.receiver)
    return false;
  return false;
}


}  // mojo_base::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM_BLINK) StructTraits<::mojo_base::mojom::blink::GenericPendingAssociatedReceiver::DataView,
                                         ::mojo_base::mojom::blink::GenericPendingAssociatedReceiverPtr> {
  static bool IsNull(const ::mojo_base::mojom::blink::GenericPendingAssociatedReceiverPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::blink::GenericPendingAssociatedReceiverPtr* output) { output->reset(); }

  static const decltype(::mojo_base::mojom::blink::GenericPendingAssociatedReceiver::interface_name)& interface_name(
      const ::mojo_base::mojom::blink::GenericPendingAssociatedReceiverPtr& input) {
    return input->interface_name;
  }

  static  decltype(::mojo_base::mojom::blink::GenericPendingAssociatedReceiver::receiver)& receiver(
       ::mojo_base::mojom::blink::GenericPendingAssociatedReceiverPtr& input) {
    return input->receiver;
  }

  static bool Read(::mojo_base::mojom::blink::GenericPendingAssociatedReceiver::DataView input, ::mojo_base::mojom::blink::GenericPendingAssociatedReceiverPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_GENERIC_PENDING_ASSOCIATED_RECEIVER_MOJOM_BLINK_H_