// mojo/public/mojom/base/file_path.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_FILE_PATH_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_FILE_PATH_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/file_path.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "mojo/public/cpp/base/file_path_mojom_traits.h"
#include "base/component_export.h"




namespace mojo_base::mojom {





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) FilePath {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FilePath, T>::value>;
  using DataView = FilePathDataView;
  using Data_ = internal::FilePath_Data;

  template <typename... Args>
  static FilePathPtr New(Args&&... args) {
    return FilePathPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FilePathPtr From(const U& u) {
    return mojo::TypeConverter<FilePathPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FilePath>::Convert(*this);
  }


  FilePath();

  explicit FilePath(
      const std::string& path);


  ~FilePath();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FilePathPtr>
  FilePathPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FilePath::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FilePath::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FilePath::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FilePath::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FilePath::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FilePath::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FilePath_UnserializedMessageContext<
            UserType, FilePath::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FilePath::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FilePath::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FilePath_UnserializedMessageContext<
            UserType, FilePath::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FilePath::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FilePath::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FilePath::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FilePath::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FilePath::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) RelativeFilePath {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RelativeFilePath, T>::value>;
  using DataView = RelativeFilePathDataView;
  using Data_ = internal::RelativeFilePath_Data;

  template <typename... Args>
  static RelativeFilePathPtr New(Args&&... args) {
    return RelativeFilePathPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RelativeFilePathPtr From(const U& u) {
    return mojo::TypeConverter<RelativeFilePathPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RelativeFilePath>::Convert(*this);
  }


  RelativeFilePath();

  explicit RelativeFilePath(
      const std::string& path);


  ~RelativeFilePath();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RelativeFilePathPtr>
  RelativeFilePathPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RelativeFilePath::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RelativeFilePath::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RelativeFilePath::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RelativeFilePath::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RelativeFilePath::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RelativeFilePath::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RelativeFilePath_UnserializedMessageContext<
            UserType, RelativeFilePath::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RelativeFilePath::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RelativeFilePath::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RelativeFilePath_UnserializedMessageContext<
            UserType, RelativeFilePath::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RelativeFilePath::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RelativeFilePath::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RelativeFilePath::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RelativeFilePath::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RelativeFilePath::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename StructPtrType>
FilePathPtr FilePath::Clone() const {
  return New(
      mojo::Clone(path)
  );
}

template <typename T, FilePath::EnableIfSame<T>*>
bool FilePath::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  return true;
}

template <typename T, FilePath::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  return false;
}
template <typename StructPtrType>
RelativeFilePathPtr RelativeFilePath::Clone() const {
  return New(
      mojo::Clone(path)
  );
}

template <typename T, RelativeFilePath::EnableIfSame<T>*>
bool RelativeFilePath::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  return true;
}

template <typename T, RelativeFilePath::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::FilePath::DataView,
                                         ::mojo_base::mojom::FilePathPtr> {
  static bool IsNull(const ::mojo_base::mojom::FilePathPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::FilePathPtr* output) { output->reset(); }

  static const decltype(::mojo_base::mojom::FilePath::path)& path(
      const ::mojo_base::mojom::FilePathPtr& input) {
    return input->path;
  }

  static bool Read(::mojo_base::mojom::FilePath::DataView input, ::mojo_base::mojom::FilePathPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::RelativeFilePath::DataView,
                                         ::mojo_base::mojom::RelativeFilePathPtr> {
  static bool IsNull(const ::mojo_base::mojom::RelativeFilePathPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::RelativeFilePathPtr* output) { output->reset(); }

  static const decltype(::mojo_base::mojom::RelativeFilePath::path)& path(
      const ::mojo_base::mojom::RelativeFilePathPtr& input) {
    return input->path;
  }

  static bool Read(::mojo_base::mojom::RelativeFilePath::DataView input, ::mojo_base::mojom::RelativeFilePathPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_FILE_PATH_MOJOM_H_