// mojo/public/mojom/base/file.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_FILE_MOJOM_DATA_VIEW_H_
#define MOJO_PUBLIC_MOJOM_BASE_FILE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "mojo/public/mojom/base/file.mojom-shared-internal.h"


namespace mojo_base::mojom {
class FileDataView;

class ReadOnlyFileDataView;



}  // mojo_base::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo_base::mojom::FileDataView> {
  using Data = ::mojo_base::mojom::internal::File_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo_base::mojom::ReadOnlyFileDataView> {
  using Data = ::mojo_base::mojom::internal::ReadOnlyFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojo_base::mojom {


class FileDataView {
 public:
  FileDataView() = default;

  FileDataView(
      internal::File_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::PlatformHandle TakeFd() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->fd, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool async() const {
    return data_->async;
  }
 private:
  internal::File_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReadOnlyFileDataView {
 public:
  ReadOnlyFileDataView() = default;

  ReadOnlyFileDataView(
      internal::ReadOnlyFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::PlatformHandle TakeFd() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->fd, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool async() const {
    return data_->async;
  }
 private:
  internal::ReadOnlyFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojo_base::mojom

#endif  // MOJO_PUBLIC_MOJOM_BASE_FILE_MOJOM_DATA_VIEW_H_