// mojo/public/mojom/base/error.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'mojo/public/mojom/base/error.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mojoBase.mojom');


  var Code = {};
  Code.kCancelled = 1;
  Code.kUnknown = 2;
  Code.kInvalidArgument = 3;
  Code.kDeadlineExceeded = 4;
  Code.kNotFound = 5;
  Code.kAlreadyExists = 6;
  Code.kPermissionDenied = 7;
  Code.kResourceExhausted = 8;
  Code.kFailedPrecondition = 9;
  Code.kAborted = 10;
  Code.kOutOfRange = 11;
  Code.kUnimplemented = 12;
  Code.kInternal = 13;
  Code.kUnavailable = 14;
  Code.kDataLoss = 15;
  Code.kUnauthenticated = 16;
  Code.MIN_VALUE = 1;
  Code.MAX_VALUE = 16;

  Code.isKnownEnumValue = function(value) {
    switch (value) {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
      return true;
    }
    return false;
  };

  Code.toKnownEnumValue = function(value) {
    return value;
  };

  Code.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function Error(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Error.prototype.initDefaults_ = function() {
    this.code = 0;
    this.message = null;
  };
  Error.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Error.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Error.code
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, Code);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Error.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Error.encodedSize = codec.kStructHeaderSize + 16;

  Error.decode = function(decoder) {
    var packed;
    var val = new Error();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(new codec.Enum(Code));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  Error.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Error.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.message);
  };
  exports.Code = Code;
  exports.Error = Error;
})();