// mojo/public/mojom/base/error.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_ERROR_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_ERROR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/error.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/error.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/error.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "base/component_export.h"




namespace mojo_base::mojom {





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) Error {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Error, T>::value>;
  using DataView = ErrorDataView;
  using Data_ = internal::Error_Data;

  template <typename... Args>
  static ErrorPtr New(Args&&... args) {
    return ErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ErrorPtr From(const U& u) {
    return mojo::TypeConverter<ErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Error>::Convert(*this);
  }


  Error();

  Error(
      Code code,
      const std::string& message);


  ~Error();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ErrorPtr>
  ErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Error::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Error::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Error::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Error::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Error::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Error::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Error_UnserializedMessageContext<
            UserType, Error::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Error::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Error::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Error_UnserializedMessageContext<
            UserType, Error::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Error::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  Code code;
  
  std::string message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Error::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Error::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Error::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Error::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
ErrorPtr Error::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(message)
  );
}

template <typename T, Error::EnableIfSame<T>*>
bool Error::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, Error::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::Error::DataView,
                                         ::mojo_base::mojom::ErrorPtr> {
  static bool IsNull(const ::mojo_base::mojom::ErrorPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::ErrorPtr* output) { output->reset(); }

  static decltype(::mojo_base::mojom::Error::code) code(
      const ::mojo_base::mojom::ErrorPtr& input) {
    return input->code;
  }

  static const decltype(::mojo_base::mojom::Error::message)& message(
      const ::mojo_base::mojom::ErrorPtr& input) {
    return input->message;
  }

  static bool Read(::mojo_base::mojom::Error::DataView input, ::mojo_base::mojom::ErrorPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_ERROR_MOJOM_H_