// mojo/public/mojom/base/error.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_ERROR_MOJOM_DATA_VIEW_H_
#define MOJO_PUBLIC_MOJOM_BASE_ERROR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "mojo/public/mojom/base/error.mojom-shared-internal.h"


namespace mojo_base::mojom {
class ErrorDataView;



}  // mojo_base::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo_base::mojom::ErrorDataView> {
  using Data = ::mojo_base::mojom::internal::Error_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojo_base::mojom {


enum class Code : int32_t {
  
  kCancelled = 1,
  
  kUnknown = 2,
  
  kInvalidArgument = 3,
  
  kDeadlineExceeded = 4,
  
  kNotFound = 5,
  
  kAlreadyExists = 6,
  
  kPermissionDenied = 7,
  
  kResourceExhausted = 8,
  
  kFailedPrecondition = 9,
  
  kAborted = 10,
  
  kOutOfRange = 11,
  
  kUnimplemented = 12,
  
  kInternal = 13,
  
  kUnavailable = 14,
  
  kDataLoss = 15,
  
  kUnauthenticated = 16,
  kMinValue = 1,
  kMaxValue = 16,
};

COMPONENT_EXPORT(MOJO_BASE_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Code value);
inline bool IsKnownEnumValue(Code value) {
  return internal::Code_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ErrorDataView {
 public:
  ErrorDataView() = default;

  ErrorDataView(
      internal::Error_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) const {
    auto data_value = data_->code;
    return mojo::internal::Deserialize<::mojo_base::mojom::Code>(
        data_value, output);
  }
  Code code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::Code>(data_->code));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Error_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojo_base::mojom

#endif  // MOJO_PUBLIC_MOJOM_BASE_ERROR_MOJOM_DATA_VIEW_H_