// mojo/public/mojom/base/byte_size.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'mojo/public/mojom/base/byte_size.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mojoBase.mojom');



  function ByteSize(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ByteSize.prototype.initDefaults_ = function() {
    this.size = 0;
  };
  ByteSize.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ByteSize.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ByteSize.encodedSize = codec.kStructHeaderSize + 8;

  ByteSize.decode = function(decoder) {
    var packed;
    var val = new ByteSize();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.size =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  ByteSize.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ByteSize.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.size);
  };
  function ByteSizeDelta(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ByteSizeDelta.prototype.initDefaults_ = function() {
    this.delta = 0;
  };
  ByteSizeDelta.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ByteSizeDelta.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ByteSizeDelta.encodedSize = codec.kStructHeaderSize + 8;

  ByteSizeDelta.decode = function(decoder) {
    var packed;
    var val = new ByteSizeDelta();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.delta =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  ByteSizeDelta.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ByteSizeDelta.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.delta);
  };
  exports.ByteSize = ByteSize;
  exports.ByteSizeDelta = ByteSizeDelta;
})();