// mojo/public/mojom/base/byte_size.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_BYTE_SIZE_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_BYTE_SIZE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/byte_size.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_size.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_size.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "mojo/public/cpp/base/byte_size_mojom_traits.h"
#include "base/component_export.h"




namespace mojo_base::mojom {





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) ByteSize {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ByteSize, T>::value>;
  using DataView = ByteSizeDataView;
  using Data_ = internal::ByteSize_Data;

  template <typename... Args>
  static ByteSizePtr New(Args&&... args) {
    return ByteSizePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ByteSizePtr From(const U& u) {
    return mojo::TypeConverter<ByteSizePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ByteSize>::Convert(*this);
  }


  ByteSize();

  explicit ByteSize(
      uint64_t size);


  ~ByteSize();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ByteSizePtr>
  ByteSizePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ByteSize::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ByteSize::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ByteSize::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ByteSize::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ByteSize::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ByteSize::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ByteSize_UnserializedMessageContext<
            UserType, ByteSize::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ByteSize::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ByteSize::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ByteSize_UnserializedMessageContext<
            UserType, ByteSize::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ByteSize::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ByteSize::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ByteSize::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ByteSize::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ByteSize::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) ByteSizeDelta {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ByteSizeDelta, T>::value>;
  using DataView = ByteSizeDeltaDataView;
  using Data_ = internal::ByteSizeDelta_Data;

  template <typename... Args>
  static ByteSizeDeltaPtr New(Args&&... args) {
    return ByteSizeDeltaPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ByteSizeDeltaPtr From(const U& u) {
    return mojo::TypeConverter<ByteSizeDeltaPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ByteSizeDelta>::Convert(*this);
  }


  ByteSizeDelta();

  explicit ByteSizeDelta(
      int64_t delta);


  ~ByteSizeDelta();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ByteSizeDeltaPtr>
  ByteSizeDeltaPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ByteSizeDelta::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ByteSizeDelta::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ByteSizeDelta::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ByteSizeDelta::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ByteSizeDelta::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ByteSizeDelta::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ByteSizeDelta_UnserializedMessageContext<
            UserType, ByteSizeDelta::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ByteSizeDelta::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ByteSizeDelta::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ByteSizeDelta_UnserializedMessageContext<
            UserType, ByteSizeDelta::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ByteSizeDelta::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t delta;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ByteSizeDelta::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ByteSizeDelta::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ByteSizeDelta::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ByteSizeDelta::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename StructPtrType>
ByteSizePtr ByteSize::Clone() const {
  return New(
      mojo::Clone(size)
  );
}

template <typename T, ByteSize::EnableIfSame<T>*>
bool ByteSize::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  return true;
}

template <typename T, ByteSize::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  return false;
}
template <typename StructPtrType>
ByteSizeDeltaPtr ByteSizeDelta::Clone() const {
  return New(
      mojo::Clone(delta)
  );
}

template <typename T, ByteSizeDelta::EnableIfSame<T>*>
bool ByteSizeDelta::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->delta, other_struct.delta))
    return false;
  return true;
}

template <typename T, ByteSizeDelta::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.delta < rhs.delta)
    return true;
  if (rhs.delta < lhs.delta)
    return false;
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::ByteSize::DataView,
                                         ::mojo_base::mojom::ByteSizePtr> {
  static bool IsNull(const ::mojo_base::mojom::ByteSizePtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::ByteSizePtr* output) { output->reset(); }

  static decltype(::mojo_base::mojom::ByteSize::size) size(
      const ::mojo_base::mojom::ByteSizePtr& input) {
    return input->size;
  }

  static bool Read(::mojo_base::mojom::ByteSize::DataView input, ::mojo_base::mojom::ByteSizePtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::ByteSizeDelta::DataView,
                                         ::mojo_base::mojom::ByteSizeDeltaPtr> {
  static bool IsNull(const ::mojo_base::mojom::ByteSizeDeltaPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::ByteSizeDeltaPtr* output) { output->reset(); }

  static decltype(::mojo_base::mojom::ByteSizeDelta::delta) delta(
      const ::mojo_base::mojom::ByteSizeDeltaPtr& input) {
    return input->delta;
  }

  static bool Read(::mojo_base::mojom::ByteSizeDelta::DataView input, ::mojo_base::mojom::ByteSizeDeltaPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_BYTE_SIZE_MOJOM_H_