// mojo/public/mojom/base/binder.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'mojo/public/mojom/base/binder.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mojoBase.mojom');
  var generic_pending_receiver$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/generic_pending_receiver.mojom', 'generic_pending_receiver.mojom.js');
  }



  function Binder_Bind_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Binder_Bind_Params.prototype.initDefaults_ = function() {
    this.receiver = null;
  };
  Binder_Bind_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Binder_Bind_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Binder_Bind_Params.receiver
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, generic_pending_receiver$.GenericPendingReceiver, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Binder_Bind_Params.encodedSize = codec.kStructHeaderSize + 8;

  Binder_Bind_Params.decode = function(decoder) {
    var packed;
    var val = new Binder_Bind_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStructPointer(generic_pending_receiver$.GenericPendingReceiver);
    return val;
  };

  Binder_Bind_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Binder_Bind_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(generic_pending_receiver$.GenericPendingReceiver, val.receiver);
  };
  var kBinder_Bind_Name = 0;

  function BinderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(Binder,
                                                   handleOrPtrInfo);
  }

  function BinderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        Binder, associatedInterfacePtrInfo);
  }

  BinderAssociatedPtr.prototype =
      Object.create(BinderPtr.prototype);
  BinderAssociatedPtr.prototype.constructor =
      BinderAssociatedPtr;

  function BinderProxy(receiver) {
    this.receiver_ = receiver;
  }
  BinderPtr.prototype.bind = function() {
    return BinderProxy.prototype.bind
        .apply(this.ptr.getProxy(), arguments);
  };

  BinderProxy.prototype.bind = function(receiver) {
    var params_ = new Binder_Bind_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kBinder_Bind_Name,
        codec.align(Binder_Bind_Params.encodedSize));
    builder.encodeStruct(Binder_Bind_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function BinderStub(delegate) {
    this.delegate_ = delegate;
  }
  BinderStub.prototype.bind = function(receiver) {
    return this.delegate_ && this.delegate_.bind && this.delegate_.bind(receiver);
  }

  BinderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBinder_Bind_Name:
      var params = reader.decodeStruct(Binder_Bind_Params);
      this.bind(params.receiver);
      return true;
    default:
      return false;
    }
  };

  BinderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateBinderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kBinder_Bind_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Binder_Bind_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateBinderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var Binder = {
    name: 'mojo_base.mojom.Binder',
    kVersion: 0,
    ptrClass: BinderPtr,
    proxyClass: BinderProxy,
    stubClass: BinderStub,
    validateRequest: validateBinderRequest,
    validateResponse: null,
  };
  BinderStub.prototype.validator = validateBinderRequest;
  BinderProxy.prototype.validator = null;
  exports.Binder = Binder;
  exports.BinderPtr = BinderPtr;
  exports.BinderAssociatedPtr = BinderAssociatedPtr;
})();