// mojo/public/mojom/base/big_buffer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_SHARED_H_
#define MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/big_buffer.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "mojo/public/mojom/base/big_buffer.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::BigBufferSharedMemoryRegionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::BigBufferSharedMemoryRegionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::BigBufferSharedMemoryRegion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::buffer_handle(input)) in_buffer_handle = Traits::buffer_handle(input);

    
    mojo::internal::Serialize<mojo::ScopedSharedBufferHandle>(
      in_buffer_handle,
      &fragment->buffer_handle,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->buffer_handle)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid buffer_handle in BigBufferSharedMemoryRegion struct");

    fragment->size = Traits::size(input);
  }

  static bool Deserialize(::mojo_base::mojom::internal::BigBufferSharedMemoryRegion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::BigBufferSharedMemoryRegionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::BigBufferDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojo_base::mojom::BigBufferDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojo_base::mojom::internal::BigBuffer_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojo_base::mojom::BigBufferDataView::Tag::kBytes: {
    decltype(Traits::bytes(input))
    in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bytes)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
  in_bytes,
  value_fragment,
  &bytes_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bytes in BigBuffer union");
    fragment->data.f_bytes.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo_base::mojom::BigBufferDataView::Tag::kSharedMemory: {
    decltype(Traits::shared_memory(input))
    in_shared_memory = Traits::shared_memory(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_memory)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::BigBufferSharedMemoryRegionDataView>(
  in_shared_memory,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_memory in BigBuffer union");
    fragment->data.f_shared_memory.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo_base::mojom::BigBufferDataView::Tag::kInvalidBuffer: {
    decltype(Traits::invalid_buffer(input))
    in_invalid_buffer = Traits::invalid_buffer(input);
    fragment->data.f_invalid_buffer = in_invalid_buffer;
    break;
  }
}
  }

  static bool Deserialize(::mojo_base::mojom::internal::BigBuffer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::BigBufferDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojo_base::mojom {



inline void BigBufferDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) const {
  CHECK(is_bytes());
  *output = mojo::ArrayDataView<uint8_t>(data_->data.f_bytes.Get(), message_);
}
inline void BigBufferDataView::GetSharedMemoryDataView(
    BigBufferSharedMemoryRegionDataView* output) const {
  CHECK(is_shared_memory());
  *output = BigBufferSharedMemoryRegionDataView(data_->data.f_shared_memory.Get(), message_);
}


}  // mojo_base::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_SHARED_H_