// mojo/public/mojom/base/big_buffer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_SEND_VALIDATION_H_
#define MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_SEND_VALIDATION_H_

#include "mojo/public/mojom/base/big_buffer.mojom-shared-internal.h"

#include "mojo/public/mojom/base/big_buffer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojo_base::mojom::BigBufferSharedMemoryRegionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::BigBufferSharedMemoryRegionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::BigBufferSharedMemoryRegion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::buffer_handle(input)) in_buffer_handle = Traits::buffer_handle(input);

      
      mojo::internal::Serialize<mojo::ScopedSharedBufferHandle>(
        in_buffer_handle,
        &fragment->buffer_handle,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->buffer_handle)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid buffer_handle in BigBufferSharedMemoryRegion struct");

      fragment->size = Traits::size(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::mojo_base::mojom::BigBufferDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojo_base::mojom::BigBufferDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojo_base::mojom::internal::BigBuffer_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojo_base::mojom::BigBufferDataView::Tag::kBytes: {
    decltype(Traits::bytes(input))
    in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bytes)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
  in_bytes,
  value_fragment,
  &bytes_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bytes in BigBuffer union");
    fragment->data.f_bytes.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo_base::mojom::BigBufferDataView::Tag::kSharedMemory: {
    decltype(Traits::shared_memory(input))
    in_shared_memory = Traits::shared_memory(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_memory)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::BigBufferSharedMemoryRegionDataView, send_validation>(
  in_shared_memory,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_memory in BigBuffer union");
    fragment->data.f_shared_memory.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo_base::mojom::BigBufferDataView::Tag::kInvalidBuffer: {
    decltype(Traits::invalid_buffer(input))
    in_invalid_buffer = Traits::invalid_buffer(input);
    fragment->data.f_invalid_buffer = in_invalid_buffer;
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_SEND_VALIDATION_H_