// mojo/public/mojom/base/big_buffer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_DATA_VIEW_H_
#define MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "mojo/public/mojom/base/big_buffer.mojom-shared-internal.h"


namespace mojo_base::mojom {
class BigBufferSharedMemoryRegionDataView;

class BigBufferDataView;


}  // mojo_base::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo_base::mojom::BigBufferSharedMemoryRegionDataView> {
  using Data = ::mojo_base::mojom::internal::BigBufferSharedMemoryRegion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo_base::mojom::BigBufferDataView> {
  using Data = ::mojo_base::mojom::internal::BigBuffer_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace mojo_base::mojom {


class BigBufferSharedMemoryRegionDataView {
 public:
  BigBufferSharedMemoryRegionDataView() = default;

  BigBufferSharedMemoryRegionDataView(
      internal::BigBufferSharedMemoryRegion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedSharedBufferHandle TakeBufferHandle() {
    mojo::ScopedSharedBufferHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedSharedBufferHandle>(
            &data_->buffer_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
  uint32_t size() const {
    return data_->size;
  }
 private:
  internal::BigBufferSharedMemoryRegion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BigBufferDataView {
 public:
  using Tag = internal::BigBuffer_Data::BigBuffer_Tag;

  BigBufferDataView() = default;

  BigBufferDataView(
      internal::BigBuffer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_bytes() const { return data_->tag == Tag::kBytes; }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) const {
    
    CHECK(is_bytes());
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        data_->data.f_bytes.Get(), output, message_);
  }
  bool is_shared_memory() const { return data_->tag == Tag::kSharedMemory; }
  inline void GetSharedMemoryDataView(
      BigBufferSharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedMemory(UserType* output) const {
    
    CHECK(is_shared_memory());
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferSharedMemoryRegionDataView>(
        data_->data.f_shared_memory.Get(), output, message_);
  }
  bool is_invalid_buffer() const { return data_->tag == Tag::kInvalidBuffer; }
  bool invalid_buffer() const {
    CHECK(is_invalid_buffer());
    return data_->data.f_invalid_buffer;
  }

 private:
  internal::BigBuffer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // mojo_base::mojom

#endif  // MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_DATA_VIEW_H_