// mojo/public/interfaces/bindings/native_struct.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_NATIVE_STRUCT_MOJOM_DATA_VIEW_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_NATIVE_STRUCT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"


namespace mojo::native {
class SerializedHandleDataView;

class NativeStructDataView;



}  // mojo::native


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo::native::SerializedHandleDataView> {
  using Data = ::mojo::native::internal::SerializedHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::native::NativeStructDataView> {
  using Data = ::mojo::native::internal::NativeStruct_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojo::native {


enum class SerializedHandleType : int32_t {
  
  MOJO_HANDLE = 0,
  
  PLATFORM_FILE = 1,
  
  WIN_HANDLE = 2,
  
  MACH_PORT = 3,
  
  FUCHSIA_HANDLE = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, SerializedHandleType value);
inline bool IsKnownEnumValue(SerializedHandleType value) {
  return internal::SerializedHandleType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SerializedHandleDataView {
 public:
  SerializedHandleDataView() = default;

  SerializedHandleDataView(
      internal::SerializedHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedHandle TakeTheHandle() {
    mojo::ScopedHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedHandle>(
            &data_->the_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::mojo::native::SerializedHandleType>(
        data_value, output);
  }
  SerializedHandleType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo::native::SerializedHandleType>(data_->type));
  }
 private:
  internal::SerializedHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NativeStructDataView {
 public:
  NativeStructDataView() = default;

  NativeStructDataView(
      internal::NativeStruct_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetHandlesDataView(
      mojo::ArrayDataView<SerializedHandleDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHandles(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>, UserType>(),
    "Attempting to read the optional `handles` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHandles` instead "
    "of `ReadHandles if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->handles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>>(
        pointer, output, message_);
  }
 private:
  internal::NativeStruct_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojo::native

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_NATIVE_STRUCT_MOJOM_DATA_VIEW_H_