// mojo/public/interfaces/bindings/interface_control_messages.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/interfaces/bindings/interface_control_messages.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "base/component_export.h"




namespace mojo::interface_control {







class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) QueryVersion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryVersion, T>::value>;
  using DataView = QueryVersionDataView;
  using Data_ = internal::QueryVersion_Data;

  template <typename... Args>
  static QueryVersionPtr New(Args&&... args) {
    return QueryVersionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryVersionPtr From(const U& u) {
    return mojo::TypeConverter<QueryVersionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryVersion>::Convert(*this);
  }


  QueryVersion();


  ~QueryVersion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryVersionPtr>
  QueryVersionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryVersion::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryVersion::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryVersion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryVersion_UnserializedMessageContext<
            UserType, QueryVersion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QueryVersion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QueryVersion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryVersion_UnserializedMessageContext<
            UserType, QueryVersion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryVersion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) QueryVersionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryVersionResult, T>::value>;
  using DataView = QueryVersionResultDataView;
  using Data_ = internal::QueryVersionResult_Data;

  template <typename... Args>
  static QueryVersionResultPtr New(Args&&... args) {
    return QueryVersionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryVersionResultPtr From(const U& u) {
    return mojo::TypeConverter<QueryVersionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryVersionResult>::Convert(*this);
  }


  QueryVersionResult();

  explicit QueryVersionResult(
      uint32_t version);


  ~QueryVersionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryVersionResultPtr>
  QueryVersionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryVersionResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryVersionResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryVersionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryVersionResult_UnserializedMessageContext<
            UserType, QueryVersionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QueryVersionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QueryVersionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryVersionResult_UnserializedMessageContext<
            UserType, QueryVersionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryVersionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t version;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) FlushForTesting {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FlushForTesting, T>::value>;
  using DataView = FlushForTestingDataView;
  using Data_ = internal::FlushForTesting_Data;

  template <typename... Args>
  static FlushForTestingPtr New(Args&&... args) {
    return FlushForTestingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FlushForTestingPtr From(const U& u) {
    return mojo::TypeConverter<FlushForTestingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FlushForTesting>::Convert(*this);
  }


  FlushForTesting();


  ~FlushForTesting();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FlushForTestingPtr>
  FlushForTestingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FlushForTesting::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FlushForTesting::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FlushForTesting::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FlushForTesting_UnserializedMessageContext<
            UserType, FlushForTesting::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FlushForTesting::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FlushForTesting::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FlushForTesting_UnserializedMessageContext<
            UserType, FlushForTesting::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FlushForTesting::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RequireVersion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequireVersion, T>::value>;
  using DataView = RequireVersionDataView;
  using Data_ = internal::RequireVersion_Data;

  template <typename... Args>
  static RequireVersionPtr New(Args&&... args) {
    return RequireVersionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequireVersionPtr From(const U& u) {
    return mojo::TypeConverter<RequireVersionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequireVersion>::Convert(*this);
  }


  RequireVersion();

  explicit RequireVersion(
      uint32_t version);


  ~RequireVersion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequireVersionPtr>
  RequireVersionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequireVersion::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequireVersion::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequireVersion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequireVersion_UnserializedMessageContext<
            UserType, RequireVersion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RequireVersion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RequireVersion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequireVersion_UnserializedMessageContext<
            UserType, RequireVersion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequireVersion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t version;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) EnableIdleTracking {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EnableIdleTracking, T>::value>;
  using DataView = EnableIdleTrackingDataView;
  using Data_ = internal::EnableIdleTracking_Data;

  template <typename... Args>
  static EnableIdleTrackingPtr New(Args&&... args) {
    return EnableIdleTrackingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EnableIdleTrackingPtr From(const U& u) {
    return mojo::TypeConverter<EnableIdleTrackingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EnableIdleTracking>::Convert(*this);
  }


  EnableIdleTracking();

  explicit EnableIdleTracking(
      int64_t timeout_in_microseconds);


  ~EnableIdleTracking();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EnableIdleTrackingPtr>
  EnableIdleTrackingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EnableIdleTracking::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EnableIdleTracking::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EnableIdleTracking::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EnableIdleTracking_UnserializedMessageContext<
            UserType, EnableIdleTracking::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EnableIdleTracking::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EnableIdleTracking::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EnableIdleTracking_UnserializedMessageContext<
            UserType, EnableIdleTracking::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EnableIdleTracking::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t timeout_in_microseconds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) MessageAck {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MessageAck, T>::value>;
  using DataView = MessageAckDataView;
  using Data_ = internal::MessageAck_Data;

  template <typename... Args>
  static MessageAckPtr New(Args&&... args) {
    return MessageAckPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MessageAckPtr From(const U& u) {
    return mojo::TypeConverter<MessageAckPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MessageAck>::Convert(*this);
  }


  MessageAck();


  ~MessageAck();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MessageAckPtr>
  MessageAckPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MessageAck::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MessageAck::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MessageAck::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MessageAck_UnserializedMessageContext<
            UserType, MessageAck::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MessageAck::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MessageAck::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MessageAck_UnserializedMessageContext<
            UserType, MessageAck::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MessageAck::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) NotifyIdle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NotifyIdle, T>::value>;
  using DataView = NotifyIdleDataView;
  using Data_ = internal::NotifyIdle_Data;

  template <typename... Args>
  static NotifyIdlePtr New(Args&&... args) {
    return NotifyIdlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NotifyIdlePtr From(const U& u) {
    return mojo::TypeConverter<NotifyIdlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NotifyIdle>::Convert(*this);
  }


  NotifyIdle();


  ~NotifyIdle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NotifyIdlePtr>
  NotifyIdlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotifyIdle::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotifyIdle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NotifyIdle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NotifyIdle_UnserializedMessageContext<
            UserType, NotifyIdle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NotifyIdle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NotifyIdle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NotifyIdle_UnserializedMessageContext<
            UserType, NotifyIdle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NotifyIdle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunInput {
 public:
  using DataView = RunInputDataView;
  using Data_ = internal::RunInput_Data;
  using Tag = Data_::RunInput_Tag;

  template <typename... Args>
  static RunInputPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |query_version|.
  static RunInputPtr NewQueryVersion(
      QueryVersionPtr value);
  // Construct an instance holding |flush_for_testing|.
  static RunInputPtr NewFlushForTesting(
      FlushForTestingPtr value);

  template <typename U>
  static RunInputPtr From(const U& u) {
    return mojo::TypeConverter<RunInputPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunInput>::Convert(*this);
  }
  ~RunInput();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  RunInput(const RunInput& other) = delete;
  RunInput& operator=(const RunInput& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RunInputPtr>
  RunInputPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunInput>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunInput>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_query_version() const { return tag_ == Tag::kQueryVersion; }
  const QueryVersionPtr& get_query_version() const {
    CHECK(tag_ == Tag::kQueryVersion);
    return data_.query_version;
  }
  QueryVersionPtr& get_query_version() {
    CHECK(tag_ == Tag::kQueryVersion);
    return data_.query_version;
  }
  void set_query_version(QueryVersionPtr query_version);

  bool is_flush_for_testing() const { return tag_ == Tag::kFlushForTesting; }
  const FlushForTestingPtr& get_flush_for_testing() const {
    CHECK(tag_ == Tag::kFlushForTesting);
    return data_.flush_for_testing;
  }
  FlushForTestingPtr& get_flush_for_testing() {
    CHECK(tag_ == Tag::kFlushForTesting);
    return data_.flush_for_testing;
  }
  void set_flush_for_testing(FlushForTestingPtr flush_for_testing);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunInput::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RunInput::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kQueryVersion)>,
        QueryVersionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFlushForTesting)>,
        FlushForTestingPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    QueryVersionPtr query_version;
    FlushForTestingPtr flush_for_testing;
  };

  RunInput(
      std::in_place_index_t<static_cast<size_t>(Tag::kQueryVersion)>,
      QueryVersionPtr value);
  RunInput(
      std::in_place_index_t<static_cast<size_t>(Tag::kFlushForTesting)>,
      FlushForTestingPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunOutput {
 public:
  using DataView = RunOutputDataView;
  using Data_ = internal::RunOutput_Data;
  using Tag = Data_::RunOutput_Tag;

  template <typename... Args>
  static RunOutputPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |query_version_result|.
  static RunOutputPtr NewQueryVersionResult(
      QueryVersionResultPtr value);

  template <typename U>
  static RunOutputPtr From(const U& u) {
    return mojo::TypeConverter<RunOutputPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunOutput>::Convert(*this);
  }
  ~RunOutput();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  RunOutput(const RunOutput& other) = delete;
  RunOutput& operator=(const RunOutput& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RunOutputPtr>
  RunOutputPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunOutput>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunOutput>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_query_version_result() const { return tag_ == Tag::kQueryVersionResult; }
  const QueryVersionResultPtr& get_query_version_result() const {
    CHECK(tag_ == Tag::kQueryVersionResult);
    return data_.query_version_result;
  }
  QueryVersionResultPtr& get_query_version_result() {
    CHECK(tag_ == Tag::kQueryVersionResult);
    return data_.query_version_result;
  }
  void set_query_version_result(QueryVersionResultPtr query_version_result);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunOutput::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RunOutput::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kQueryVersionResult)>,
        QueryVersionResultPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    QueryVersionResultPtr query_version_result;
  };

  RunOutput(
      std::in_place_index_t<static_cast<size_t>(Tag::kQueryVersionResult)>,
      QueryVersionResultPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunOrClosePipeInput {
 public:
  using DataView = RunOrClosePipeInputDataView;
  using Data_ = internal::RunOrClosePipeInput_Data;
  using Tag = Data_::RunOrClosePipeInput_Tag;

  template <typename... Args>
  static RunOrClosePipeInputPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |require_version|.
  static RunOrClosePipeInputPtr NewRequireVersion(
      RequireVersionPtr value);
  // Construct an instance holding |enable_idle_tracking|.
  static RunOrClosePipeInputPtr NewEnableIdleTracking(
      EnableIdleTrackingPtr value);
  // Construct an instance holding |message_ack|.
  static RunOrClosePipeInputPtr NewMessageAck(
      MessageAckPtr value);
  // Construct an instance holding |notify_idle|.
  static RunOrClosePipeInputPtr NewNotifyIdle(
      NotifyIdlePtr value);

  template <typename U>
  static RunOrClosePipeInputPtr From(const U& u) {
    return mojo::TypeConverter<RunOrClosePipeInputPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunOrClosePipeInput>::Convert(*this);
  }
  ~RunOrClosePipeInput();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  RunOrClosePipeInput(const RunOrClosePipeInput& other) = delete;
  RunOrClosePipeInput& operator=(const RunOrClosePipeInput& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RunOrClosePipeInputPtr>
  RunOrClosePipeInputPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunOrClosePipeInput>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunOrClosePipeInput>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_require_version() const { return tag_ == Tag::kRequireVersion; }
  const RequireVersionPtr& get_require_version() const {
    CHECK(tag_ == Tag::kRequireVersion);
    return data_.require_version;
  }
  RequireVersionPtr& get_require_version() {
    CHECK(tag_ == Tag::kRequireVersion);
    return data_.require_version;
  }
  void set_require_version(RequireVersionPtr require_version);

  bool is_enable_idle_tracking() const { return tag_ == Tag::kEnableIdleTracking; }
  const EnableIdleTrackingPtr& get_enable_idle_tracking() const {
    CHECK(tag_ == Tag::kEnableIdleTracking);
    return data_.enable_idle_tracking;
  }
  EnableIdleTrackingPtr& get_enable_idle_tracking() {
    CHECK(tag_ == Tag::kEnableIdleTracking);
    return data_.enable_idle_tracking;
  }
  void set_enable_idle_tracking(EnableIdleTrackingPtr enable_idle_tracking);

  bool is_message_ack() const { return tag_ == Tag::kMessageAck; }
  const MessageAckPtr& get_message_ack() const {
    CHECK(tag_ == Tag::kMessageAck);
    return data_.message_ack;
  }
  MessageAckPtr& get_message_ack() {
    CHECK(tag_ == Tag::kMessageAck);
    return data_.message_ack;
  }
  void set_message_ack(MessageAckPtr message_ack);

  bool is_notify_idle() const { return tag_ == Tag::kNotifyIdle; }
  const NotifyIdlePtr& get_notify_idle() const {
    CHECK(tag_ == Tag::kNotifyIdle);
    return data_.notify_idle;
  }
  NotifyIdlePtr& get_notify_idle() {
    CHECK(tag_ == Tag::kNotifyIdle);
    return data_.notify_idle;
  }
  void set_notify_idle(NotifyIdlePtr notify_idle);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunOrClosePipeInput::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RunOrClosePipeInput::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRequireVersion)>,
        RequireVersionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEnableIdleTracking)>,
        EnableIdleTrackingPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMessageAck)>,
        MessageAckPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNotifyIdle)>,
        NotifyIdlePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    RequireVersionPtr require_version;
    EnableIdleTrackingPtr enable_idle_tracking;
    MessageAckPtr message_ack;
    NotifyIdlePtr notify_idle;
  };

  RunOrClosePipeInput(
      std::in_place_index_t<static_cast<size_t>(Tag::kRequireVersion)>,
      RequireVersionPtr value);
  RunOrClosePipeInput(
      std::in_place_index_t<static_cast<size_t>(Tag::kEnableIdleTracking)>,
      EnableIdleTrackingPtr value);
  RunOrClosePipeInput(
      std::in_place_index_t<static_cast<size_t>(Tag::kMessageAck)>,
      MessageAckPtr value);
  RunOrClosePipeInput(
      std::in_place_index_t<static_cast<size_t>(Tag::kNotifyIdle)>,
      NotifyIdlePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunMessageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RunMessageParams, T>::value>;
  using DataView = RunMessageParamsDataView;
  using Data_ = internal::RunMessageParams_Data;

  template <typename... Args>
  static RunMessageParamsPtr New(Args&&... args) {
    return RunMessageParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RunMessageParamsPtr From(const U& u) {
    return mojo::TypeConverter<RunMessageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunMessageParams>::Convert(*this);
  }


  RunMessageParams();

  explicit RunMessageParams(
      RunInputPtr input);

RunMessageParams(const RunMessageParams&) = delete;
RunMessageParams& operator=(const RunMessageParams&) = delete;

  ~RunMessageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RunMessageParamsPtr>
  RunMessageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunMessageParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunMessageParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunMessageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RunMessageParams_UnserializedMessageContext<
            UserType, RunMessageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RunMessageParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RunMessageParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RunMessageParams_UnserializedMessageContext<
            UserType, RunMessageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RunMessageParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  RunInputPtr input;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunResponseMessageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RunResponseMessageParams, T>::value>;
  using DataView = RunResponseMessageParamsDataView;
  using Data_ = internal::RunResponseMessageParams_Data;

  template <typename... Args>
  static RunResponseMessageParamsPtr New(Args&&... args) {
    return RunResponseMessageParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RunResponseMessageParamsPtr From(const U& u) {
    return mojo::TypeConverter<RunResponseMessageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunResponseMessageParams>::Convert(*this);
  }


  RunResponseMessageParams();

  explicit RunResponseMessageParams(
      RunOutputPtr output);

RunResponseMessageParams(const RunResponseMessageParams&) = delete;
RunResponseMessageParams& operator=(const RunResponseMessageParams&) = delete;

  ~RunResponseMessageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RunResponseMessageParamsPtr>
  RunResponseMessageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunResponseMessageParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunResponseMessageParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunResponseMessageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RunResponseMessageParams_UnserializedMessageContext<
            UserType, RunResponseMessageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RunResponseMessageParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RunResponseMessageParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RunResponseMessageParams_UnserializedMessageContext<
            UserType, RunResponseMessageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RunResponseMessageParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  RunOutputPtr output;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunOrClosePipeMessageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RunOrClosePipeMessageParams, T>::value>;
  using DataView = RunOrClosePipeMessageParamsDataView;
  using Data_ = internal::RunOrClosePipeMessageParams_Data;

  template <typename... Args>
  static RunOrClosePipeMessageParamsPtr New(Args&&... args) {
    return RunOrClosePipeMessageParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RunOrClosePipeMessageParamsPtr From(const U& u) {
    return mojo::TypeConverter<RunOrClosePipeMessageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunOrClosePipeMessageParams>::Convert(*this);
  }


  RunOrClosePipeMessageParams();

  explicit RunOrClosePipeMessageParams(
      RunOrClosePipeInputPtr input);

RunOrClosePipeMessageParams(const RunOrClosePipeMessageParams&) = delete;
RunOrClosePipeMessageParams& operator=(const RunOrClosePipeMessageParams&) = delete;

  ~RunOrClosePipeMessageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RunOrClosePipeMessageParamsPtr>
  RunOrClosePipeMessageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunOrClosePipeMessageParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunOrClosePipeMessageParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunOrClosePipeMessageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RunOrClosePipeMessageParams_UnserializedMessageContext<
            UserType, RunOrClosePipeMessageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RunOrClosePipeMessageParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RunOrClosePipeMessageParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RunOrClosePipeMessageParams_UnserializedMessageContext<
            UserType, RunOrClosePipeMessageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RunOrClosePipeMessageParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  RunOrClosePipeInputPtr input;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename UnionPtrType>
RunInputPtr RunInput::Clone() const {
  switch (tag_) {
    case Tag::kQueryVersion:
      return NewQueryVersion(
          mojo::Clone(data_.query_version));
    case Tag::kFlushForTesting:
      return NewFlushForTesting(
          mojo::Clone(data_.flush_for_testing));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RunInput>::value>::type*>
bool RunInput::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kQueryVersion:
      return mojo::Equals(data_.query_version, other.data_.query_version);
    case Tag::kFlushForTesting:
      return mojo::Equals(data_.flush_for_testing, other.data_.flush_for_testing);
  }

  return false;
}
template <typename UnionPtrType>
RunOutputPtr RunOutput::Clone() const {
  switch (tag_) {
    case Tag::kQueryVersionResult:
      return NewQueryVersionResult(
          mojo::Clone(data_.query_version_result));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RunOutput>::value>::type*>
bool RunOutput::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kQueryVersionResult:
      return mojo::Equals(data_.query_version_result, other.data_.query_version_result);
  }

  return false;
}
template <typename UnionPtrType>
RunOrClosePipeInputPtr RunOrClosePipeInput::Clone() const {
  switch (tag_) {
    case Tag::kRequireVersion:
      return NewRequireVersion(
          mojo::Clone(data_.require_version));
    case Tag::kEnableIdleTracking:
      return NewEnableIdleTracking(
          mojo::Clone(data_.enable_idle_tracking));
    case Tag::kMessageAck:
      return NewMessageAck(
          mojo::Clone(data_.message_ack));
    case Tag::kNotifyIdle:
      return NewNotifyIdle(
          mojo::Clone(data_.notify_idle));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RunOrClosePipeInput>::value>::type*>
bool RunOrClosePipeInput::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kRequireVersion:
      return mojo::Equals(data_.require_version, other.data_.require_version);
    case Tag::kEnableIdleTracking:
      return mojo::Equals(data_.enable_idle_tracking, other.data_.enable_idle_tracking);
    case Tag::kMessageAck:
      return mojo::Equals(data_.message_ack, other.data_.message_ack);
    case Tag::kNotifyIdle:
      return mojo::Equals(data_.notify_idle, other.data_.notify_idle);
  }

  return false;
}
template <typename StructPtrType>
RunMessageParamsPtr RunMessageParams::Clone() const {
  return New(
      mojo::Clone(input)
  );
}

template <typename T, RunMessageParams::EnableIfSame<T>*>
bool RunMessageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  return true;
}

template <typename T, RunMessageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input < rhs.input)
    return true;
  if (rhs.input < lhs.input)
    return false;
  return false;
}
template <typename StructPtrType>
RunResponseMessageParamsPtr RunResponseMessageParams::Clone() const {
  return New(
      mojo::Clone(output)
  );
}

template <typename T, RunResponseMessageParams::EnableIfSame<T>*>
bool RunResponseMessageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->output, other_struct.output))
    return false;
  return true;
}

template <typename T, RunResponseMessageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.output < rhs.output)
    return true;
  if (rhs.output < lhs.output)
    return false;
  return false;
}
template <typename StructPtrType>
QueryVersionPtr QueryVersion::Clone() const {
  return New(
  );
}

template <typename T, QueryVersion::EnableIfSame<T>*>
bool QueryVersion::Equals(const T& other_struct) const {
  return true;
}

template <typename T, QueryVersion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
QueryVersionResultPtr QueryVersionResult::Clone() const {
  return New(
      mojo::Clone(version)
  );
}

template <typename T, QueryVersionResult::EnableIfSame<T>*>
bool QueryVersionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  return true;
}

template <typename T, QueryVersionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  return false;
}
template <typename StructPtrType>
FlushForTestingPtr FlushForTesting::Clone() const {
  return New(
  );
}

template <typename T, FlushForTesting::EnableIfSame<T>*>
bool FlushForTesting::Equals(const T& other_struct) const {
  return true;
}

template <typename T, FlushForTesting::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
RunOrClosePipeMessageParamsPtr RunOrClosePipeMessageParams::Clone() const {
  return New(
      mojo::Clone(input)
  );
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>*>
bool RunOrClosePipeMessageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  return true;
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input < rhs.input)
    return true;
  if (rhs.input < lhs.input)
    return false;
  return false;
}
template <typename StructPtrType>
RequireVersionPtr RequireVersion::Clone() const {
  return New(
      mojo::Clone(version)
  );
}

template <typename T, RequireVersion::EnableIfSame<T>*>
bool RequireVersion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  return true;
}

template <typename T, RequireVersion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  return false;
}
template <typename StructPtrType>
EnableIdleTrackingPtr EnableIdleTracking::Clone() const {
  return New(
      mojo::Clone(timeout_in_microseconds)
  );
}

template <typename T, EnableIdleTracking::EnableIfSame<T>*>
bool EnableIdleTracking::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timeout_in_microseconds, other_struct.timeout_in_microseconds))
    return false;
  return true;
}

template <typename T, EnableIdleTracking::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.timeout_in_microseconds < rhs.timeout_in_microseconds)
    return true;
  if (rhs.timeout_in_microseconds < lhs.timeout_in_microseconds)
    return false;
  return false;
}
template <typename StructPtrType>
MessageAckPtr MessageAck::Clone() const {
  return New(
  );
}

template <typename T, MessageAck::EnableIfSame<T>*>
bool MessageAck::Equals(const T& other_struct) const {
  return true;
}

template <typename T, MessageAck::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
NotifyIdlePtr NotifyIdle::Clone() const {
  return New(
  );
}

template <typename T, NotifyIdle::EnableIfSame<T>*>
bool NotifyIdle::Equals(const T& other_struct) const {
  return true;
}

template <typename T, NotifyIdle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}


}  // mojo::interface_control

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::RunMessageParams::DataView,
                                         ::mojo::interface_control::RunMessageParamsPtr> {
  static bool IsNull(const ::mojo::interface_control::RunMessageParamsPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunMessageParamsPtr* output) { output->reset(); }

  static const decltype(::mojo::interface_control::RunMessageParams::input)& input(
      const ::mojo::interface_control::RunMessageParamsPtr& input) {
    return input->input;
  }

  static bool Read(::mojo::interface_control::RunMessageParams::DataView input, ::mojo::interface_control::RunMessageParamsPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::RunResponseMessageParams::DataView,
                                         ::mojo::interface_control::RunResponseMessageParamsPtr> {
  static bool IsNull(const ::mojo::interface_control::RunResponseMessageParamsPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunResponseMessageParamsPtr* output) { output->reset(); }

  static const decltype(::mojo::interface_control::RunResponseMessageParams::output)& output(
      const ::mojo::interface_control::RunResponseMessageParamsPtr& input) {
    return input->output;
  }

  static bool Read(::mojo::interface_control::RunResponseMessageParams::DataView input, ::mojo::interface_control::RunResponseMessageParamsPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::QueryVersion::DataView,
                                         ::mojo::interface_control::QueryVersionPtr> {
  static bool IsNull(const ::mojo::interface_control::QueryVersionPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::QueryVersionPtr* output) { output->reset(); }

  static bool Read(::mojo::interface_control::QueryVersion::DataView input, ::mojo::interface_control::QueryVersionPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::QueryVersionResult::DataView,
                                         ::mojo::interface_control::QueryVersionResultPtr> {
  static bool IsNull(const ::mojo::interface_control::QueryVersionResultPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::QueryVersionResultPtr* output) { output->reset(); }

  static decltype(::mojo::interface_control::QueryVersionResult::version) version(
      const ::mojo::interface_control::QueryVersionResultPtr& input) {
    return input->version;
  }

  static bool Read(::mojo::interface_control::QueryVersionResult::DataView input, ::mojo::interface_control::QueryVersionResultPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::FlushForTesting::DataView,
                                         ::mojo::interface_control::FlushForTestingPtr> {
  static bool IsNull(const ::mojo::interface_control::FlushForTestingPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::FlushForTestingPtr* output) { output->reset(); }

  static bool Read(::mojo::interface_control::FlushForTesting::DataView input, ::mojo::interface_control::FlushForTestingPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::RunOrClosePipeMessageParams::DataView,
                                         ::mojo::interface_control::RunOrClosePipeMessageParamsPtr> {
  static bool IsNull(const ::mojo::interface_control::RunOrClosePipeMessageParamsPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunOrClosePipeMessageParamsPtr* output) { output->reset(); }

  static const decltype(::mojo::interface_control::RunOrClosePipeMessageParams::input)& input(
      const ::mojo::interface_control::RunOrClosePipeMessageParamsPtr& input) {
    return input->input;
  }

  static bool Read(::mojo::interface_control::RunOrClosePipeMessageParams::DataView input, ::mojo::interface_control::RunOrClosePipeMessageParamsPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::RequireVersion::DataView,
                                         ::mojo::interface_control::RequireVersionPtr> {
  static bool IsNull(const ::mojo::interface_control::RequireVersionPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RequireVersionPtr* output) { output->reset(); }

  static decltype(::mojo::interface_control::RequireVersion::version) version(
      const ::mojo::interface_control::RequireVersionPtr& input) {
    return input->version;
  }

  static bool Read(::mojo::interface_control::RequireVersion::DataView input, ::mojo::interface_control::RequireVersionPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::EnableIdleTracking::DataView,
                                         ::mojo::interface_control::EnableIdleTrackingPtr> {
  static bool IsNull(const ::mojo::interface_control::EnableIdleTrackingPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::EnableIdleTrackingPtr* output) { output->reset(); }

  static decltype(::mojo::interface_control::EnableIdleTracking::timeout_in_microseconds) timeout_in_microseconds(
      const ::mojo::interface_control::EnableIdleTrackingPtr& input) {
    return input->timeout_in_microseconds;
  }

  static bool Read(::mojo::interface_control::EnableIdleTracking::DataView input, ::mojo::interface_control::EnableIdleTrackingPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::MessageAck::DataView,
                                         ::mojo::interface_control::MessageAckPtr> {
  static bool IsNull(const ::mojo::interface_control::MessageAckPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::MessageAckPtr* output) { output->reset(); }

  static bool Read(::mojo::interface_control::MessageAck::DataView input, ::mojo::interface_control::MessageAckPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::NotifyIdle::DataView,
                                         ::mojo::interface_control::NotifyIdlePtr> {
  static bool IsNull(const ::mojo::interface_control::NotifyIdlePtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::NotifyIdlePtr* output) { output->reset(); }

  static bool Read(::mojo::interface_control::NotifyIdle::DataView input, ::mojo::interface_control::NotifyIdlePtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) UnionTraits<::mojo::interface_control::RunInput::DataView,
                                        ::mojo::interface_control::RunInputPtr> {
  static bool IsNull(const ::mojo::interface_control::RunInputPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunInputPtr* output) { output->reset(); }

  static ::mojo::interface_control::RunInput::Tag GetTag(const ::mojo::interface_control::RunInputPtr& input) {
    return input->which();
  }

  static const ::mojo::interface_control::QueryVersionPtr& query_version(const ::mojo::interface_control::RunInputPtr& input) {
    return input->get_query_version();
  }

  static const ::mojo::interface_control::FlushForTestingPtr& flush_for_testing(const ::mojo::interface_control::RunInputPtr& input) {
    return input->get_flush_for_testing();
  }

  static bool Read(::mojo::interface_control::RunInput::DataView input, ::mojo::interface_control::RunInputPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) UnionTraits<::mojo::interface_control::RunOutput::DataView,
                                        ::mojo::interface_control::RunOutputPtr> {
  static bool IsNull(const ::mojo::interface_control::RunOutputPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunOutputPtr* output) { output->reset(); }

  static ::mojo::interface_control::RunOutput::Tag GetTag(const ::mojo::interface_control::RunOutputPtr& input) {
    return input->which();
  }

  static const ::mojo::interface_control::QueryVersionResultPtr& query_version_result(const ::mojo::interface_control::RunOutputPtr& input) {
    return input->get_query_version_result();
  }

  static bool Read(::mojo::interface_control::RunOutput::DataView input, ::mojo::interface_control::RunOutputPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) UnionTraits<::mojo::interface_control::RunOrClosePipeInput::DataView,
                                        ::mojo::interface_control::RunOrClosePipeInputPtr> {
  static bool IsNull(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunOrClosePipeInputPtr* output) { output->reset(); }

  static ::mojo::interface_control::RunOrClosePipeInput::Tag GetTag(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) {
    return input->which();
  }

  static const ::mojo::interface_control::RequireVersionPtr& require_version(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) {
    return input->get_require_version();
  }

  static const ::mojo::interface_control::EnableIdleTrackingPtr& enable_idle_tracking(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) {
    return input->get_enable_idle_tracking();
  }

  static const ::mojo::interface_control::MessageAckPtr& message_ack(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) {
    return input->get_message_ack();
  }

  static const ::mojo::interface_control::NotifyIdlePtr& notify_idle(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) {
    return input->get_notify_idle();
  }

  static bool Read(::mojo::interface_control::RunOrClosePipeInput::DataView input, ::mojo::interface_control::RunOrClosePipeInputPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_H_