// mojo/public/interfaces/bindings/interface_control_messages.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_SHARED_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/interfaces/bindings/interface_control_messages.mojom-shared-internal.h"




#include "mojo/public/interfaces/bindings/interface_control_messages.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::RunMessageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::interface_control::RunMessageParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::interface_control::internal::RunMessageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input(input)) in_input = Traits::input(input);
    mojo::internal::MessageFragment<decltype(fragment->input)>
        input_fragment(fragment.message());
    input_fragment.Claim(&fragment->input);
    
    mojo::internal::Serialize<::mojo::interface_control::RunInputDataView>(
      in_input,
      input_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input in RunMessageParams struct");
  }

  static bool Deserialize(::mojo::interface_control::internal::RunMessageParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::RunMessageParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::RunResponseMessageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::interface_control::RunResponseMessageParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::interface_control::internal::RunResponseMessageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::output(input)) in_output = Traits::output(input);
    mojo::internal::MessageFragment<decltype(fragment->output)>
        output_fragment(fragment.message());
    output_fragment.Claim(&fragment->output);
    
    mojo::internal::Serialize<::mojo::interface_control::RunOutputDataView>(
      in_output,
      output_fragment,
      true);
  }

  static bool Deserialize(::mojo::interface_control::internal::RunResponseMessageParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::RunResponseMessageParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::QueryVersionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::interface_control::QueryVersionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::interface_control::internal::QueryVersion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::mojo::interface_control::internal::QueryVersion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::QueryVersionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::QueryVersionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::interface_control::QueryVersionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::interface_control::internal::QueryVersionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->version = Traits::version(input);
  }

  static bool Deserialize(::mojo::interface_control::internal::QueryVersionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::QueryVersionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::FlushForTestingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::interface_control::FlushForTestingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::interface_control::internal::FlushForTesting_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::mojo::interface_control::internal::FlushForTesting_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::FlushForTestingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::RunOrClosePipeMessageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::interface_control::RunOrClosePipeMessageParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::interface_control::internal::RunOrClosePipeMessageParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::input(input)) in_input = Traits::input(input);
    mojo::internal::MessageFragment<decltype(fragment->input)>
        input_fragment(fragment.message());
    input_fragment.Claim(&fragment->input);
    
    mojo::internal::Serialize<::mojo::interface_control::RunOrClosePipeInputDataView>(
      in_input,
      input_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input in RunOrClosePipeMessageParams struct");
  }

  static bool Deserialize(::mojo::interface_control::internal::RunOrClosePipeMessageParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::RunOrClosePipeMessageParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::RequireVersionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::interface_control::RequireVersionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::interface_control::internal::RequireVersion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->version = Traits::version(input);
  }

  static bool Deserialize(::mojo::interface_control::internal::RequireVersion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::RequireVersionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::EnableIdleTrackingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::interface_control::EnableIdleTrackingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::interface_control::internal::EnableIdleTracking_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->timeout_in_microseconds = Traits::timeout_in_microseconds(input);
  }

  static bool Deserialize(::mojo::interface_control::internal::EnableIdleTracking_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::EnableIdleTrackingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::MessageAckDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::interface_control::MessageAckDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::interface_control::internal::MessageAck_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::mojo::interface_control::internal::MessageAck_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::MessageAckDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::NotifyIdleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::interface_control::NotifyIdleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo::interface_control::internal::NotifyIdle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::mojo::interface_control::internal::NotifyIdle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::NotifyIdleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::RunInputDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojo::interface_control::RunInputDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojo::interface_control::internal::RunInput_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojo::interface_control::RunInputDataView::Tag::kQueryVersion: {
    decltype(Traits::query_version(input))
    in_query_version = Traits::query_version(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_query_version)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo::interface_control::QueryVersionDataView>(
  in_query_version,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null query_version in RunInput union");
    fragment->data.f_query_version.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo::interface_control::RunInputDataView::Tag::kFlushForTesting: {
    decltype(Traits::flush_for_testing(input))
    in_flush_for_testing = Traits::flush_for_testing(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_flush_for_testing)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo::interface_control::FlushForTestingDataView>(
  in_flush_for_testing,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null flush_for_testing in RunInput union");
    fragment->data.f_flush_for_testing.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::mojo::interface_control::internal::RunInput_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::RunInputDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::RunOutputDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojo::interface_control::RunOutputDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojo::interface_control::internal::RunOutput_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojo::interface_control::RunOutputDataView::Tag::kQueryVersionResult: {
    decltype(Traits::query_version_result(input))
    in_query_version_result = Traits::query_version_result(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_query_version_result)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo::interface_control::QueryVersionResultDataView>(
  in_query_version_result,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null query_version_result in RunOutput union");
    fragment->data.f_query_version_result.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::mojo::interface_control::internal::RunOutput_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::RunOutputDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::interface_control::RunOrClosePipeInputDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojo::interface_control::RunOrClosePipeInputDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojo::interface_control::internal::RunOrClosePipeInput_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojo::interface_control::RunOrClosePipeInputDataView::Tag::kRequireVersion: {
    decltype(Traits::require_version(input))
    in_require_version = Traits::require_version(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_require_version)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo::interface_control::RequireVersionDataView>(
  in_require_version,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null require_version in RunOrClosePipeInput union");
    fragment->data.f_require_version.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo::interface_control::RunOrClosePipeInputDataView::Tag::kEnableIdleTracking: {
    decltype(Traits::enable_idle_tracking(input))
    in_enable_idle_tracking = Traits::enable_idle_tracking(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_enable_idle_tracking)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo::interface_control::EnableIdleTrackingDataView>(
  in_enable_idle_tracking,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null enable_idle_tracking in RunOrClosePipeInput union");
    fragment->data.f_enable_idle_tracking.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo::interface_control::RunOrClosePipeInputDataView::Tag::kMessageAck: {
    decltype(Traits::message_ack(input))
    in_message_ack = Traits::message_ack(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_message_ack)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo::interface_control::MessageAckDataView>(
  in_message_ack,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null message_ack in RunOrClosePipeInput union");
    fragment->data.f_message_ack.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo::interface_control::RunOrClosePipeInputDataView::Tag::kNotifyIdle: {
    decltype(Traits::notify_idle(input))
    in_notify_idle = Traits::notify_idle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_notify_idle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo::interface_control::NotifyIdleDataView>(
  in_notify_idle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null notify_idle in RunOrClosePipeInput union");
    fragment->data.f_notify_idle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::mojo::interface_control::internal::RunOrClosePipeInput_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::interface_control::RunOrClosePipeInputDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojo::interface_control {

inline void RunMessageParamsDataView::GetInputDataView(
    RunInputDataView* output) {
  auto pointer = &data_->input;
  *output = RunInputDataView(pointer, message_);
}


inline void RunResponseMessageParamsDataView::GetOutputDataView(
    RunOutputDataView* output) {
  auto pointer = &data_->output;
  *output = RunOutputDataView(pointer, message_);
}








inline void RunOrClosePipeMessageParamsDataView::GetInputDataView(
    RunOrClosePipeInputDataView* output) {
  auto pointer = &data_->input;
  *output = RunOrClosePipeInputDataView(pointer, message_);
}










inline void RunInputDataView::GetQueryVersionDataView(
    QueryVersionDataView* output) const {
  CHECK(is_query_version());
  *output = QueryVersionDataView(data_->data.f_query_version.Get(), message_);
}
inline void RunInputDataView::GetFlushForTestingDataView(
    FlushForTestingDataView* output) const {
  CHECK(is_flush_for_testing());
  *output = FlushForTestingDataView(data_->data.f_flush_for_testing.Get(), message_);
}

inline void RunOutputDataView::GetQueryVersionResultDataView(
    QueryVersionResultDataView* output) const {
  CHECK(is_query_version_result());
  *output = QueryVersionResultDataView(data_->data.f_query_version_result.Get(), message_);
}

inline void RunOrClosePipeInputDataView::GetRequireVersionDataView(
    RequireVersionDataView* output) const {
  CHECK(is_require_version());
  *output = RequireVersionDataView(data_->data.f_require_version.Get(), message_);
}
inline void RunOrClosePipeInputDataView::GetEnableIdleTrackingDataView(
    EnableIdleTrackingDataView* output) const {
  CHECK(is_enable_idle_tracking());
  *output = EnableIdleTrackingDataView(data_->data.f_enable_idle_tracking.Get(), message_);
}
inline void RunOrClosePipeInputDataView::GetMessageAckDataView(
    MessageAckDataView* output) const {
  CHECK(is_message_ack());
  *output = MessageAckDataView(data_->data.f_message_ack.Get(), message_);
}
inline void RunOrClosePipeInputDataView::GetNotifyIdleDataView(
    NotifyIdleDataView* output) const {
  CHECK(is_notify_idle());
  *output = NotifyIdleDataView(data_->data.f_notify_idle.Get(), message_);
}


}  // mojo::interface_control

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_SHARED_H_