// mojo/public/interfaces/bindings/interface_control_messages.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_DATA_VIEW_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "mojo/public/interfaces/bindings/interface_control_messages.mojom-shared-internal.h"


namespace mojo::interface_control {
class RunMessageParamsDataView;

class RunResponseMessageParamsDataView;

class QueryVersionDataView;

class QueryVersionResultDataView;

class FlushForTestingDataView;

class RunOrClosePipeMessageParamsDataView;

class RequireVersionDataView;

class EnableIdleTrackingDataView;

class MessageAckDataView;

class NotifyIdleDataView;

class RunInputDataView;
class RunOutputDataView;
class RunOrClosePipeInputDataView;


}  // mojo::interface_control


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo::interface_control::RunMessageParamsDataView> {
  using Data = ::mojo::interface_control::internal::RunMessageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::RunResponseMessageParamsDataView> {
  using Data = ::mojo::interface_control::internal::RunResponseMessageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::QueryVersionDataView> {
  using Data = ::mojo::interface_control::internal::QueryVersion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::QueryVersionResultDataView> {
  using Data = ::mojo::interface_control::internal::QueryVersionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::FlushForTestingDataView> {
  using Data = ::mojo::interface_control::internal::FlushForTesting_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::RunOrClosePipeMessageParamsDataView> {
  using Data = ::mojo::interface_control::internal::RunOrClosePipeMessageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::RequireVersionDataView> {
  using Data = ::mojo::interface_control::internal::RequireVersion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::EnableIdleTrackingDataView> {
  using Data = ::mojo::interface_control::internal::EnableIdleTracking_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::MessageAckDataView> {
  using Data = ::mojo::interface_control::internal::MessageAck_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::NotifyIdleDataView> {
  using Data = ::mojo::interface_control::internal::NotifyIdle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::RunInputDataView> {
  using Data = ::mojo::interface_control::internal::RunInput_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::RunOutputDataView> {
  using Data = ::mojo::interface_control::internal::RunOutput_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::mojo::interface_control::RunOrClosePipeInputDataView> {
  using Data = ::mojo::interface_control::internal::RunOrClosePipeInput_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace mojo::interface_control {


class RunMessageParamsDataView {
 public:
  RunMessageParamsDataView() = default;

  RunMessageParamsDataView(
      internal::RunMessageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputDataView(
      RunInputDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = !data_->input.is_null() ? &data_->input : nullptr;
    return mojo::internal::Deserialize<::mojo::interface_control::RunInputDataView>(
        pointer, output, message_);
  }
 private:
  internal::RunMessageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RunResponseMessageParamsDataView {
 public:
  RunResponseMessageParamsDataView() = default;

  RunResponseMessageParamsDataView(
      internal::RunResponseMessageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOutputDataView(
      RunOutputDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutput(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo::interface_control::RunOutputDataView, UserType>(),
    "Attempting to read the optional `output` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOutput` instead "
    "of `ReadOutput if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->output.is_null() ? &data_->output : nullptr;
    return mojo::internal::Deserialize<::mojo::interface_control::RunOutputDataView>(
        pointer, output, message_);
  }
 private:
  internal::RunResponseMessageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class QueryVersionDataView {
 public:
  QueryVersionDataView() = default;

  QueryVersionDataView(
      internal::QueryVersion_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::QueryVersion_Data* data_ = nullptr;
};


class QueryVersionResultDataView {
 public:
  QueryVersionResultDataView() = default;

  QueryVersionResultDataView(
      internal::QueryVersionResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t version() const {
    return data_->version;
  }
 private:
  internal::QueryVersionResult_Data* data_ = nullptr;
};


class FlushForTestingDataView {
 public:
  FlushForTestingDataView() = default;

  FlushForTestingDataView(
      internal::FlushForTesting_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::FlushForTesting_Data* data_ = nullptr;
};


class RunOrClosePipeMessageParamsDataView {
 public:
  RunOrClosePipeMessageParamsDataView() = default;

  RunOrClosePipeMessageParamsDataView(
      internal::RunOrClosePipeMessageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputDataView(
      RunOrClosePipeInputDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = !data_->input.is_null() ? &data_->input : nullptr;
    return mojo::internal::Deserialize<::mojo::interface_control::RunOrClosePipeInputDataView>(
        pointer, output, message_);
  }
 private:
  internal::RunOrClosePipeMessageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RequireVersionDataView {
 public:
  RequireVersionDataView() = default;

  RequireVersionDataView(
      internal::RequireVersion_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t version() const {
    return data_->version;
  }
 private:
  internal::RequireVersion_Data* data_ = nullptr;
};


class EnableIdleTrackingDataView {
 public:
  EnableIdleTrackingDataView() = default;

  EnableIdleTrackingDataView(
      internal::EnableIdleTracking_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t timeout_in_microseconds() const {
    return data_->timeout_in_microseconds;
  }
 private:
  internal::EnableIdleTracking_Data* data_ = nullptr;
};


class MessageAckDataView {
 public:
  MessageAckDataView() = default;

  MessageAckDataView(
      internal::MessageAck_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MessageAck_Data* data_ = nullptr;
};


class NotifyIdleDataView {
 public:
  NotifyIdleDataView() = default;

  NotifyIdleDataView(
      internal::NotifyIdle_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NotifyIdle_Data* data_ = nullptr;
};


class RunInputDataView {
 public:
  using Tag = internal::RunInput_Data::RunInput_Tag;

  RunInputDataView() = default;

  RunInputDataView(
      internal::RunInput_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_query_version() const { return data_->tag == Tag::kQueryVersion; }
  inline void GetQueryVersionDataView(
      QueryVersionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadQueryVersion(UserType* output) const {
    
    CHECK(is_query_version());
    return mojo::internal::Deserialize<::mojo::interface_control::QueryVersionDataView>(
        data_->data.f_query_version.Get(), output, message_);
  }
  bool is_flush_for_testing() const { return data_->tag == Tag::kFlushForTesting; }
  inline void GetFlushForTestingDataView(
      FlushForTestingDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFlushForTesting(UserType* output) const {
    
    CHECK(is_flush_for_testing());
    return mojo::internal::Deserialize<::mojo::interface_control::FlushForTestingDataView>(
        data_->data.f_flush_for_testing.Get(), output, message_);
  }

 private:
  internal::RunInput_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class RunOutputDataView {
 public:
  using Tag = internal::RunOutput_Data::RunOutput_Tag;

  RunOutputDataView() = default;

  RunOutputDataView(
      internal::RunOutput_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_query_version_result() const { return data_->tag == Tag::kQueryVersionResult; }
  inline void GetQueryVersionResultDataView(
      QueryVersionResultDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadQueryVersionResult(UserType* output) const {
    
    CHECK(is_query_version_result());
    return mojo::internal::Deserialize<::mojo::interface_control::QueryVersionResultDataView>(
        data_->data.f_query_version_result.Get(), output, message_);
  }

 private:
  internal::RunOutput_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class RunOrClosePipeInputDataView {
 public:
  using Tag = internal::RunOrClosePipeInput_Data::RunOrClosePipeInput_Tag;

  RunOrClosePipeInputDataView() = default;

  RunOrClosePipeInputDataView(
      internal::RunOrClosePipeInput_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_require_version() const { return data_->tag == Tag::kRequireVersion; }
  inline void GetRequireVersionDataView(
      RequireVersionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRequireVersion(UserType* output) const {
    
    CHECK(is_require_version());
    return mojo::internal::Deserialize<::mojo::interface_control::RequireVersionDataView>(
        data_->data.f_require_version.Get(), output, message_);
  }
  bool is_enable_idle_tracking() const { return data_->tag == Tag::kEnableIdleTracking; }
  inline void GetEnableIdleTrackingDataView(
      EnableIdleTrackingDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEnableIdleTracking(UserType* output) const {
    
    CHECK(is_enable_idle_tracking());
    return mojo::internal::Deserialize<::mojo::interface_control::EnableIdleTrackingDataView>(
        data_->data.f_enable_idle_tracking.Get(), output, message_);
  }
  bool is_message_ack() const { return data_->tag == Tag::kMessageAck; }
  inline void GetMessageAckDataView(
      MessageAckDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMessageAck(UserType* output) const {
    
    CHECK(is_message_ack());
    return mojo::internal::Deserialize<::mojo::interface_control::MessageAckDataView>(
        data_->data.f_message_ack.Get(), output, message_);
  }
  bool is_notify_idle() const { return data_->tag == Tag::kNotifyIdle; }
  inline void GetNotifyIdleDataView(
      NotifyIdleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNotifyIdle(UserType* output) const {
    
    CHECK(is_notify_idle());
    return mojo::internal::Deserialize<::mojo::interface_control::NotifyIdleDataView>(
        data_->data.f_notify_idle.Get(), output, message_);
  }

 private:
  internal::RunOrClosePipeInput_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // mojo::interface_control

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_DATA_VIEW_H_