// media/mojo/mojom/webrtc_video_perf.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/webrtc_video_perf.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "media/mojo/mojom/webrtc_video_perf.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::WebrtcPredictionFeaturesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::WebrtcPredictionFeaturesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::WebrtcPredictionFeatures_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_decode_stats = Traits::is_decode_stats(input);

    
    mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
      Traits::profile(input),
      &fragment->profile);

    fragment->video_pixels = Traits::video_pixels(input);

    fragment->hardware_accelerated = Traits::hardware_accelerated(input);
  }

  static bool Deserialize(::media::mojom::internal::WebrtcPredictionFeatures_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::WebrtcPredictionFeaturesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::WebrtcVideoStatsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::WebrtcVideoStatsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::WebrtcVideoStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->frames_processed = Traits::frames_processed(input);

    fragment->key_frames_processed = Traits::key_frames_processed(input);

    fragment->p99_processing_time_ms = Traits::p99_processing_time_ms(input);
  }

  static bool Deserialize(::media::mojom::internal::WebrtcVideoStats_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::WebrtcVideoStatsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {






}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_SHARED_H_