// media/mojo/mojom/webrtc_video_perf.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  WebrtcVideoPerfRecorder_UpdateRecord_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebrtcPredictionFeatures_Data> features;
  mojo::internal::Pointer<internal::WebrtcVideoStats_Data> video_stats;

 private:
  friend class mojo::internal::MessageFragment<WebrtcVideoPerfRecorder_UpdateRecord_Params_Data>;

  WebrtcVideoPerfRecorder_UpdateRecord_Params_Data();
  ~WebrtcVideoPerfRecorder_UpdateRecord_Params_Data() = delete;
};
static_assert(sizeof(WebrtcVideoPerfRecorder_UpdateRecord_Params_Data) == 24,
              "Bad sizeof(WebrtcVideoPerfRecorder_UpdateRecord_Params_Data)");
class  WebrtcVideoPerfHistory_GetPerfInfo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebrtcPredictionFeatures_Data> features;
  int32_t frames_per_second;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<WebrtcVideoPerfHistory_GetPerfInfo_Params_Data>;

  WebrtcVideoPerfHistory_GetPerfInfo_Params_Data();
  ~WebrtcVideoPerfHistory_GetPerfInfo_Params_Data() = delete;
};
static_assert(sizeof(WebrtcVideoPerfHistory_GetPerfInfo_Params_Data) == 24,
              "Bad sizeof(WebrtcVideoPerfHistory_GetPerfInfo_Params_Data)");
class  WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_smooth : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data>;

  WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data();
  ~WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data() = delete;
};
static_assert(sizeof(WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data) == 16,
              "Bad sizeof(WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data)");

}  // namespace internal


class WebrtcVideoPerfRecorder_UpdateRecord_ParamsDataView {
 public:
  WebrtcVideoPerfRecorder_UpdateRecord_ParamsDataView() = default;

  WebrtcVideoPerfRecorder_UpdateRecord_ParamsDataView(
      internal::WebrtcVideoPerfRecorder_UpdateRecord_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFeaturesDataView(
      WebrtcPredictionFeaturesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatures(UserType* output) {
    
    auto* pointer = data_->features.Get();
    return mojo::internal::Deserialize<::media::mojom::WebrtcPredictionFeaturesDataView>(
        pointer, output, message_);
  }
  inline void GetVideoStatsDataView(
      WebrtcVideoStatsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoStats(UserType* output) {
    
    auto* pointer = data_->video_stats.Get();
    return mojo::internal::Deserialize<::media::mojom::WebrtcVideoStatsDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebrtcVideoPerfRecorder_UpdateRecord_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebrtcVideoPerfHistory_GetPerfInfo_ParamsDataView {
 public:
  WebrtcVideoPerfHistory_GetPerfInfo_ParamsDataView() = default;

  WebrtcVideoPerfHistory_GetPerfInfo_ParamsDataView(
      internal::WebrtcVideoPerfHistory_GetPerfInfo_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFeaturesDataView(
      WebrtcPredictionFeaturesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatures(UserType* output) {
    
    auto* pointer = data_->features.Get();
    return mojo::internal::Deserialize<::media::mojom::WebrtcPredictionFeaturesDataView>(
        pointer, output, message_);
  }
  int32_t frames_per_second() const {
    return data_->frames_per_second;
  }
 private:
  internal::WebrtcVideoPerfHistory_GetPerfInfo_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebrtcVideoPerfHistory_GetPerfInfo_ResponseParamsDataView {
 public:
  WebrtcVideoPerfHistory_GetPerfInfo_ResponseParamsDataView() = default;

  WebrtcVideoPerfHistory_GetPerfInfo_ResponseParamsDataView(
      internal::WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_smooth() const {
    return data_->is_smooth;
  }
 private:
  internal::WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data* data_ = nullptr;
};

inline void WebrtcVideoPerfRecorder_UpdateRecord_ParamsDataView::GetFeaturesDataView(
    WebrtcPredictionFeaturesDataView* output) {
  auto pointer = data_->features.Get();
  *output = WebrtcPredictionFeaturesDataView(pointer, message_);
}
inline void WebrtcVideoPerfRecorder_UpdateRecord_ParamsDataView::GetVideoStatsDataView(
    WebrtcVideoStatsDataView* output) {
  auto pointer = data_->video_stats.Get();
  *output = WebrtcVideoStatsDataView(pointer, message_);
}


inline void WebrtcVideoPerfHistory_GetPerfInfo_ParamsDataView::GetFeaturesDataView(
    WebrtcPredictionFeaturesDataView* output) {
  auto pointer = data_->features.Get();
  *output = WebrtcPredictionFeaturesDataView(pointer, message_);
}





}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_PARAMS_DATA_H_