// media/mojo/mojom/watch_time_recorder.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/mojo/mojom/watch_time_recorder.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace media::mojom {
class PlaybackPropertiesDataView;

class SecondaryPlaybackPropertiesDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::PlaybackPropertiesDataView> {
  using Data = ::media::mojom::internal::PlaybackProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SecondaryPlaybackPropertiesDataView> {
  using Data = ::media::mojom::internal::SecondaryPlaybackProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class WatchTimeRecorderInterfaceBase {};

using WatchTimeRecorderPtrDataView =
    mojo::InterfacePtrDataView<WatchTimeRecorderInterfaceBase>;
using WatchTimeRecorderRequestDataView =
    mojo::InterfaceRequestDataView<WatchTimeRecorderInterfaceBase>;
using WatchTimeRecorderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WatchTimeRecorderInterfaceBase>;
using WatchTimeRecorderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WatchTimeRecorderInterfaceBase>;


class PlaybackPropertiesDataView {
 public:
  PlaybackPropertiesDataView() = default;

  PlaybackPropertiesDataView(
      internal::PlaybackProperties_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_audio() const {
    return data_->has_audio;
  }
  bool has_video() const {
    return data_->has_video;
  }
  bool is_background() const {
    return data_->is_background;
  }
  bool is_muted() const {
    return data_->is_muted;
  }
  bool is_eme() const {
    return data_->is_eme;
  }
  bool is_embedded_media_experience() const {
    return data_->is_embedded_media_experience;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMediaStreamType(UserType* output) const {
    auto data_value = data_->media_stream_type;
    return mojo::internal::Deserialize<::media::mojom::MediaStreamType>(
        data_value, output);
  }
  ::media::mojom::MediaStreamType media_stream_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MediaStreamType>(data_->media_stream_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRendererType(UserType* output) const {
    auto data_value = data_->renderer_type;
    return mojo::internal::Deserialize<::media::mojom::RendererType>(
        data_value, output);
  }
  ::media::mojom::RendererType renderer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::RendererType>(data_->renderer_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDemuxerType(UserType* output) const {
    auto data_value = data_->demuxer_type;
    return mojo::internal::Deserialize<::media::mojom::DemuxerType>(
        data_value, output);
  }
  ::media::mojom::DemuxerType demuxer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::DemuxerType>(data_->demuxer_type));
  }
 private:
  internal::PlaybackProperties_Data* data_ = nullptr;
};


class SecondaryPlaybackPropertiesDataView {
 public:
  SecondaryPlaybackPropertiesDataView() = default;

  SecondaryPlaybackPropertiesDataView(
      internal::SecondaryPlaybackProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAudioCodec(UserType* output) const {
    auto data_value = data_->audio_codec;
    return mojo::internal::Deserialize<::media::mojom::AudioCodec>(
        data_value, output);
  }
  ::media::mojom::AudioCodec audio_codec() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioCodec>(data_->audio_codec));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVideoCodec(UserType* output) const {
    auto data_value = data_->video_codec;
    return mojo::internal::Deserialize<::media::mojom::VideoCodec>(
        data_value, output);
  }
  ::media::mojom::VideoCodec video_codec() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodec>(data_->video_codec));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAudioCodecProfile(UserType* output) const {
    auto data_value = data_->audio_codec_profile;
    return mojo::internal::Deserialize<::media::mojom::AudioCodecProfile>(
        data_value, output);
  }
  ::media::mojom::AudioCodecProfile audio_codec_profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioCodecProfile>(data_->audio_codec_profile));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVideoCodecProfile(UserType* output) const {
    auto data_value = data_->video_codec_profile;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  ::media::mojom::VideoCodecProfile video_codec_profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->video_codec_profile));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAudioDecoder(UserType* output) const {
    auto data_value = data_->audio_decoder;
    return mojo::internal::Deserialize<::media::mojom::AudioDecoderType>(
        data_value, output);
  }
  ::media::mojom::AudioDecoderType audio_decoder() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioDecoderType>(data_->audio_decoder));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVideoDecoder(UserType* output) const {
    auto data_value = data_->video_decoder;
    return mojo::internal::Deserialize<::media::mojom::VideoDecoderType>(
        data_value, output);
  }
  ::media::mojom::VideoDecoderType video_decoder() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoDecoderType>(data_->video_decoder));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAudioEncryptionScheme(UserType* output) const {
    auto data_value = data_->audio_encryption_scheme;
    return mojo::internal::Deserialize<::media::mojom::EncryptionScheme>(
        data_value, output);
  }
  ::media::mojom::EncryptionScheme audio_encryption_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EncryptionScheme>(data_->audio_encryption_scheme));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVideoEncryptionScheme(UserType* output) const {
    auto data_value = data_->video_encryption_scheme;
    return mojo::internal::Deserialize<::media::mojom::EncryptionScheme>(
        data_value, output);
  }
  ::media::mojom::EncryptionScheme video_encryption_scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EncryptionScheme>(data_->video_encryption_scheme));
  }
  inline void GetNaturalSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNaturalSize(UserType* output) {
    
    auto* pointer = data_->natural_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::SecondaryPlaybackProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_DATA_VIEW_H_