// media/mojo/mojom/video_encoder_metrics_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODER_METRICS_PROVIDER_MOJOM_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODER_METRICS_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class VideoEncoderMetricsProviderProxy;

template <typename ImplRefTraits>
class VideoEncoderMetricsProviderStub;

class VideoEncoderMetricsProviderRequestValidator;


class VideoEncoderMetricsProvider
    : public VideoEncoderMetricsProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.VideoEncoderMetricsProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoEncoderMetricsProviderInterfaceBase;
  using Proxy_ = VideoEncoderMetricsProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoEncoderMetricsProviderStub<ImplRefTraits>;

  using RequestValidator_ = VideoEncoderMetricsProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kSetEncodedFrameCountMinVersion = 0,
    kSetErrorMinVersion = 0,
    kCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEncodedFrameCount_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Complete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoEncoderMetricsProvider() = default;

  virtual void Initialize(uint64_t encoder_id, VideoEncoderUseCase encoder_use_case, ::media::VideoCodecProfile profile, const ::gfx::Size& encode_size, bool is_hardware_encoder, ::media::SVCScalabilityMode svc_mode) = 0;

  virtual void SetEncodedFrameCount(uint64_t encoder_id, uint64_t num_encoded_frames) = 0;

  virtual void SetError(uint64_t encoder_id, const ::media::EncoderStatus& status) = 0;

  virtual void Complete(uint64_t encoder_id) = 0;
};



class  VideoEncoderMetricsProviderProxy
    : public VideoEncoderMetricsProvider {
 public:
  using InterfaceType = VideoEncoderMetricsProvider;

  explicit VideoEncoderMetricsProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Initialize(uint64_t encoder_id, VideoEncoderUseCase encoder_use_case, ::media::VideoCodecProfile profile, const ::gfx::Size& encode_size, bool is_hardware_encoder, ::media::SVCScalabilityMode svc_mode) final;
  
  void SetEncodedFrameCount(uint64_t encoder_id, uint64_t num_encoded_frames) final;
  
  void SetError(uint64_t encoder_id, const ::media::EncoderStatus& status) final;
  
  void Complete(uint64_t encoder_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoEncoderMetricsProviderStubDispatch {
 public:
  static bool Accept(VideoEncoderMetricsProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoEncoderMetricsProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoEncoderMetricsProvider>>
class VideoEncoderMetricsProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoEncoderMetricsProviderStub() = default;
  ~VideoEncoderMetricsProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncoderMetricsProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoEncoderMetricsProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoEncoderMetricsProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODER_METRICS_PROVIDER_MOJOM_H_