// media/mojo/mojom/video_encoder_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/video_encoder_info.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/video_encoder_info.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/video_encoder_info.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "media/mojo/mojom/video_encoder_info_mojom_traits.h"




namespace media::mojom {









class  ResolutionRateLimit {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResolutionRateLimit, T>::value>;
  using DataView = ResolutionRateLimitDataView;
  using Data_ = internal::ResolutionRateLimit_Data;

  template <typename... Args>
  static ResolutionRateLimitPtr New(Args&&... args) {
    return ResolutionRateLimitPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResolutionRateLimitPtr From(const U& u) {
    return mojo::TypeConverter<ResolutionRateLimitPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResolutionRateLimit>::Convert(*this);
  }


  ResolutionRateLimit();

  ResolutionRateLimit(
      const ::gfx::Size& frame_size,
      int32_t min_start_bitrate_bps,
      int32_t min_bitrate_bps,
      int32_t max_bitrate_bps,
      uint32_t max_framerate_numerator,
      uint32_t max_framerate_denominator);


  ~ResolutionRateLimit();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResolutionRateLimitPtr>
  ResolutionRateLimitPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResolutionRateLimit::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResolutionRateLimit::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResolutionRateLimit::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResolutionRateLimit::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResolutionRateLimit::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResolutionRateLimit::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResolutionRateLimit_UnserializedMessageContext<
            UserType, ResolutionRateLimit::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResolutionRateLimit::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResolutionRateLimit::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResolutionRateLimit_UnserializedMessageContext<
            UserType, ResolutionRateLimit::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResolutionRateLimit::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Size frame_size;
  
  int32_t min_start_bitrate_bps;
  
  int32_t min_bitrate_bps;
  
  int32_t max_bitrate_bps;
  
  uint32_t max_framerate_numerator;
  
  uint32_t max_framerate_denominator;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResolutionRateLimit::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResolutionRateLimit::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResolutionRateLimit::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResolutionRateLimit::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoEncoderInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoEncoderInfo, T>::value>;
  using DataView = VideoEncoderInfoDataView;
  using Data_ = internal::VideoEncoderInfo_Data;

  template <typename... Args>
  static VideoEncoderInfoPtr New(Args&&... args) {
    return VideoEncoderInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoEncoderInfoPtr From(const U& u) {
    return mojo::TypeConverter<VideoEncoderInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoEncoderInfo>::Convert(*this);
  }


  VideoEncoderInfo();

  VideoEncoderInfo(
      const std::string& implementation_name,
      bool has_frame_delay,
      int32_t frame_delay,
      bool has_input_capacity,
      int32_t input_capacity,
      bool supports_native_handle,
      bool has_trusted_rate_controller,
      bool is_hardware_accelerated,
      bool supports_simulcast,
      bool reports_average_qp,
      uint32_t requested_resolution_alignment,
      bool apply_alignment_to_all_simulcast_layers,
      bool supports_frame_size_change,
      std::vector<std::vector<uint8_t>> fps_allocation,
      std::vector<ResolutionRateLimitPtr> resolution_rate_limits,
      std::vector<::media::VideoPixelFormat> gpu_supported_pixel_formats,
      bool supports_gpu_shared_images);

VideoEncoderInfo(const VideoEncoderInfo&) = delete;
VideoEncoderInfo& operator=(const VideoEncoderInfo&) = delete;

  ~VideoEncoderInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoEncoderInfoPtr>
  VideoEncoderInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoEncoderInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoEncoderInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoEncoderInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoEncoderInfo_UnserializedMessageContext<
            UserType, VideoEncoderInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoEncoderInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoEncoderInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoEncoderInfo_UnserializedMessageContext<
            UserType, VideoEncoderInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoEncoderInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string implementation_name;
  
  bool has_frame_delay;
  
  int32_t frame_delay;
  
  bool has_input_capacity;
  
  int32_t input_capacity;
  
  bool supports_native_handle;
  
  bool has_trusted_rate_controller;
  
  bool is_hardware_accelerated;
  
  bool supports_simulcast;
  
  bool reports_average_qp;
  
  uint32_t requested_resolution_alignment;
  
  bool apply_alignment_to_all_simulcast_layers;
  
  bool supports_frame_size_change;
  
  std::vector<std::vector<uint8_t>> fps_allocation;
  
  std::vector<ResolutionRateLimitPtr> resolution_rate_limits;
  
  std::vector<::media::VideoPixelFormat> gpu_supported_pixel_formats;
  
  bool supports_gpu_shared_images;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoEncoderInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ResolutionRateLimitPtr ResolutionRateLimit::Clone() const {
  return New(
      mojo::Clone(frame_size),
      mojo::Clone(min_start_bitrate_bps),
      mojo::Clone(min_bitrate_bps),
      mojo::Clone(max_bitrate_bps),
      mojo::Clone(max_framerate_numerator),
      mojo::Clone(max_framerate_denominator)
  );
}

template <typename T, ResolutionRateLimit::EnableIfSame<T>*>
bool ResolutionRateLimit::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_size, other_struct.frame_size))
    return false;
  if (!mojo::Equals(this->min_start_bitrate_bps, other_struct.min_start_bitrate_bps))
    return false;
  if (!mojo::Equals(this->min_bitrate_bps, other_struct.min_bitrate_bps))
    return false;
  if (!mojo::Equals(this->max_bitrate_bps, other_struct.max_bitrate_bps))
    return false;
  if (!mojo::Equals(this->max_framerate_numerator, other_struct.max_framerate_numerator))
    return false;
  if (!mojo::Equals(this->max_framerate_denominator, other_struct.max_framerate_denominator))
    return false;
  return true;
}

template <typename T, ResolutionRateLimit::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_size < rhs.frame_size)
    return true;
  if (rhs.frame_size < lhs.frame_size)
    return false;
  if (lhs.min_start_bitrate_bps < rhs.min_start_bitrate_bps)
    return true;
  if (rhs.min_start_bitrate_bps < lhs.min_start_bitrate_bps)
    return false;
  if (lhs.min_bitrate_bps < rhs.min_bitrate_bps)
    return true;
  if (rhs.min_bitrate_bps < lhs.min_bitrate_bps)
    return false;
  if (lhs.max_bitrate_bps < rhs.max_bitrate_bps)
    return true;
  if (rhs.max_bitrate_bps < lhs.max_bitrate_bps)
    return false;
  if (lhs.max_framerate_numerator < rhs.max_framerate_numerator)
    return true;
  if (rhs.max_framerate_numerator < lhs.max_framerate_numerator)
    return false;
  if (lhs.max_framerate_denominator < rhs.max_framerate_denominator)
    return true;
  if (rhs.max_framerate_denominator < lhs.max_framerate_denominator)
    return false;
  return false;
}
template <typename StructPtrType>
VideoEncoderInfoPtr VideoEncoderInfo::Clone() const {
  return New(
      mojo::Clone(implementation_name),
      mojo::Clone(has_frame_delay),
      mojo::Clone(frame_delay),
      mojo::Clone(has_input_capacity),
      mojo::Clone(input_capacity),
      mojo::Clone(supports_native_handle),
      mojo::Clone(has_trusted_rate_controller),
      mojo::Clone(is_hardware_accelerated),
      mojo::Clone(supports_simulcast),
      mojo::Clone(reports_average_qp),
      mojo::Clone(requested_resolution_alignment),
      mojo::Clone(apply_alignment_to_all_simulcast_layers),
      mojo::Clone(supports_frame_size_change),
      mojo::Clone(fps_allocation),
      mojo::Clone(resolution_rate_limits),
      mojo::Clone(gpu_supported_pixel_formats),
      mojo::Clone(supports_gpu_shared_images)
  );
}

template <typename T, VideoEncoderInfo::EnableIfSame<T>*>
bool VideoEncoderInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->implementation_name, other_struct.implementation_name))
    return false;
  if (!mojo::Equals(this->has_frame_delay, other_struct.has_frame_delay))
    return false;
  if (!mojo::Equals(this->frame_delay, other_struct.frame_delay))
    return false;
  if (!mojo::Equals(this->has_input_capacity, other_struct.has_input_capacity))
    return false;
  if (!mojo::Equals(this->input_capacity, other_struct.input_capacity))
    return false;
  if (!mojo::Equals(this->supports_native_handle, other_struct.supports_native_handle))
    return false;
  if (!mojo::Equals(this->has_trusted_rate_controller, other_struct.has_trusted_rate_controller))
    return false;
  if (!mojo::Equals(this->is_hardware_accelerated, other_struct.is_hardware_accelerated))
    return false;
  if (!mojo::Equals(this->supports_simulcast, other_struct.supports_simulcast))
    return false;
  if (!mojo::Equals(this->reports_average_qp, other_struct.reports_average_qp))
    return false;
  if (!mojo::Equals(this->requested_resolution_alignment, other_struct.requested_resolution_alignment))
    return false;
  if (!mojo::Equals(this->apply_alignment_to_all_simulcast_layers, other_struct.apply_alignment_to_all_simulcast_layers))
    return false;
  if (!mojo::Equals(this->supports_frame_size_change, other_struct.supports_frame_size_change))
    return false;
  if (!mojo::Equals(this->fps_allocation, other_struct.fps_allocation))
    return false;
  if (!mojo::Equals(this->resolution_rate_limits, other_struct.resolution_rate_limits))
    return false;
  if (!mojo::Equals(this->gpu_supported_pixel_formats, other_struct.gpu_supported_pixel_formats))
    return false;
  if (!mojo::Equals(this->supports_gpu_shared_images, other_struct.supports_gpu_shared_images))
    return false;
  return true;
}

template <typename T, VideoEncoderInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.implementation_name < rhs.implementation_name)
    return true;
  if (rhs.implementation_name < lhs.implementation_name)
    return false;
  if (lhs.has_frame_delay < rhs.has_frame_delay)
    return true;
  if (rhs.has_frame_delay < lhs.has_frame_delay)
    return false;
  if (lhs.frame_delay < rhs.frame_delay)
    return true;
  if (rhs.frame_delay < lhs.frame_delay)
    return false;
  if (lhs.has_input_capacity < rhs.has_input_capacity)
    return true;
  if (rhs.has_input_capacity < lhs.has_input_capacity)
    return false;
  if (lhs.input_capacity < rhs.input_capacity)
    return true;
  if (rhs.input_capacity < lhs.input_capacity)
    return false;
  if (lhs.supports_native_handle < rhs.supports_native_handle)
    return true;
  if (rhs.supports_native_handle < lhs.supports_native_handle)
    return false;
  if (lhs.has_trusted_rate_controller < rhs.has_trusted_rate_controller)
    return true;
  if (rhs.has_trusted_rate_controller < lhs.has_trusted_rate_controller)
    return false;
  if (lhs.is_hardware_accelerated < rhs.is_hardware_accelerated)
    return true;
  if (rhs.is_hardware_accelerated < lhs.is_hardware_accelerated)
    return false;
  if (lhs.supports_simulcast < rhs.supports_simulcast)
    return true;
  if (rhs.supports_simulcast < lhs.supports_simulcast)
    return false;
  if (lhs.reports_average_qp < rhs.reports_average_qp)
    return true;
  if (rhs.reports_average_qp < lhs.reports_average_qp)
    return false;
  if (lhs.requested_resolution_alignment < rhs.requested_resolution_alignment)
    return true;
  if (rhs.requested_resolution_alignment < lhs.requested_resolution_alignment)
    return false;
  if (lhs.apply_alignment_to_all_simulcast_layers < rhs.apply_alignment_to_all_simulcast_layers)
    return true;
  if (rhs.apply_alignment_to_all_simulcast_layers < lhs.apply_alignment_to_all_simulcast_layers)
    return false;
  if (lhs.supports_frame_size_change < rhs.supports_frame_size_change)
    return true;
  if (rhs.supports_frame_size_change < lhs.supports_frame_size_change)
    return false;
  if (lhs.fps_allocation < rhs.fps_allocation)
    return true;
  if (rhs.fps_allocation < lhs.fps_allocation)
    return false;
  if (lhs.resolution_rate_limits < rhs.resolution_rate_limits)
    return true;
  if (rhs.resolution_rate_limits < lhs.resolution_rate_limits)
    return false;
  if (lhs.gpu_supported_pixel_formats < rhs.gpu_supported_pixel_formats)
    return true;
  if (rhs.gpu_supported_pixel_formats < lhs.gpu_supported_pixel_formats)
    return false;
  if (lhs.supports_gpu_shared_images < rhs.supports_gpu_shared_images)
    return true;
  if (rhs.supports_gpu_shared_images < lhs.supports_gpu_shared_images)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::ResolutionRateLimit::DataView,
                                         ::media::mojom::ResolutionRateLimitPtr> {
  static bool IsNull(const ::media::mojom::ResolutionRateLimitPtr& input) { return !input; }
  static void SetToNull(::media::mojom::ResolutionRateLimitPtr* output) { output->reset(); }

  static const decltype(::media::mojom::ResolutionRateLimit::frame_size)& frame_size(
      const ::media::mojom::ResolutionRateLimitPtr& input) {
    return input->frame_size;
  }

  static decltype(::media::mojom::ResolutionRateLimit::min_start_bitrate_bps) min_start_bitrate_bps(
      const ::media::mojom::ResolutionRateLimitPtr& input) {
    return input->min_start_bitrate_bps;
  }

  static decltype(::media::mojom::ResolutionRateLimit::min_bitrate_bps) min_bitrate_bps(
      const ::media::mojom::ResolutionRateLimitPtr& input) {
    return input->min_bitrate_bps;
  }

  static decltype(::media::mojom::ResolutionRateLimit::max_bitrate_bps) max_bitrate_bps(
      const ::media::mojom::ResolutionRateLimitPtr& input) {
    return input->max_bitrate_bps;
  }

  static decltype(::media::mojom::ResolutionRateLimit::max_framerate_numerator) max_framerate_numerator(
      const ::media::mojom::ResolutionRateLimitPtr& input) {
    return input->max_framerate_numerator;
  }

  static decltype(::media::mojom::ResolutionRateLimit::max_framerate_denominator) max_framerate_denominator(
      const ::media::mojom::ResolutionRateLimitPtr& input) {
    return input->max_framerate_denominator;
  }

  static bool Read(::media::mojom::ResolutionRateLimit::DataView input, ::media::mojom::ResolutionRateLimitPtr* output);
};


template <>
struct  StructTraits<::media::mojom::VideoEncoderInfo::DataView,
                                         ::media::mojom::VideoEncoderInfoPtr> {
  static bool IsNull(const ::media::mojom::VideoEncoderInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::VideoEncoderInfoPtr* output) { output->reset(); }

  static const decltype(::media::mojom::VideoEncoderInfo::implementation_name)& implementation_name(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->implementation_name;
  }

  static decltype(::media::mojom::VideoEncoderInfo::has_frame_delay) has_frame_delay(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->has_frame_delay;
  }

  static decltype(::media::mojom::VideoEncoderInfo::frame_delay) frame_delay(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->frame_delay;
  }

  static decltype(::media::mojom::VideoEncoderInfo::has_input_capacity) has_input_capacity(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->has_input_capacity;
  }

  static decltype(::media::mojom::VideoEncoderInfo::input_capacity) input_capacity(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->input_capacity;
  }

  static decltype(::media::mojom::VideoEncoderInfo::supports_native_handle) supports_native_handle(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->supports_native_handle;
  }

  static decltype(::media::mojom::VideoEncoderInfo::has_trusted_rate_controller) has_trusted_rate_controller(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->has_trusted_rate_controller;
  }

  static decltype(::media::mojom::VideoEncoderInfo::is_hardware_accelerated) is_hardware_accelerated(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->is_hardware_accelerated;
  }

  static decltype(::media::mojom::VideoEncoderInfo::supports_simulcast) supports_simulcast(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->supports_simulcast;
  }

  static decltype(::media::mojom::VideoEncoderInfo::reports_average_qp) reports_average_qp(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->reports_average_qp;
  }

  static decltype(::media::mojom::VideoEncoderInfo::requested_resolution_alignment) requested_resolution_alignment(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->requested_resolution_alignment;
  }

  static decltype(::media::mojom::VideoEncoderInfo::apply_alignment_to_all_simulcast_layers) apply_alignment_to_all_simulcast_layers(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->apply_alignment_to_all_simulcast_layers;
  }

  static decltype(::media::mojom::VideoEncoderInfo::supports_frame_size_change) supports_frame_size_change(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->supports_frame_size_change;
  }

  static const decltype(::media::mojom::VideoEncoderInfo::fps_allocation)& fps_allocation(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->fps_allocation;
  }

  static const decltype(::media::mojom::VideoEncoderInfo::resolution_rate_limits)& resolution_rate_limits(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->resolution_rate_limits;
  }

  static const decltype(::media::mojom::VideoEncoderInfo::gpu_supported_pixel_formats)& gpu_supported_pixel_formats(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->gpu_supported_pixel_formats;
  }

  static decltype(::media::mojom::VideoEncoderInfo::supports_gpu_shared_images) supports_gpu_shared_images(
      const ::media::mojom::VideoEncoderInfoPtr& input) {
    return input->supports_gpu_shared_images;
  }

  static bool Read(::media::mojom::VideoEncoderInfo::DataView input, ::media::mojom::VideoEncoderInfoPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_H_