// media/mojo/mojom/video_encoder_info.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/video_encoder_info.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "media/mojo/mojom/video_encoder_info.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::ResolutionRateLimitDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ResolutionRateLimitDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::ResolutionRateLimit_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::frame_size(input)) in_frame_size = Traits::frame_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_size)::BaseType> frame_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_frame_size,
        frame_size_fragment);

      fragment->frame_size.Set(
          frame_size_fragment.is_null() ? nullptr : frame_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_size in ResolutionRateLimit struct");

      fragment->min_start_bitrate_bps = Traits::min_start_bitrate_bps(input);

      fragment->min_bitrate_bps = Traits::min_bitrate_bps(input);

      fragment->max_bitrate_bps = Traits::max_bitrate_bps(input);

      fragment->max_framerate_numerator = Traits::max_framerate_numerator(input);

      fragment->max_framerate_denominator = Traits::max_framerate_denominator(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoEncoderInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoEncoderInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoEncoderInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::implementation_name(input)) in_implementation_name = Traits::implementation_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->implementation_name)::BaseType> implementation_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_implementation_name,
        implementation_name_fragment);

      fragment->implementation_name.Set(
          implementation_name_fragment.is_null() ? nullptr : implementation_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->implementation_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null implementation_name in VideoEncoderInfo struct");

      fragment->has_frame_delay = Traits::has_frame_delay(input);

      fragment->frame_delay = Traits::frame_delay(input);

      fragment->has_input_capacity = Traits::has_input_capacity(input);

      fragment->input_capacity = Traits::input_capacity(input);

      fragment->supports_native_handle = Traits::supports_native_handle(input);

      fragment->has_trusted_rate_controller = Traits::has_trusted_rate_controller(input);

      fragment->is_hardware_accelerated = Traits::is_hardware_accelerated(input);

      fragment->supports_simulcast = Traits::supports_simulcast(input);

      fragment->reports_average_qp = Traits::reports_average_qp(input);

      fragment->requested_resolution_alignment = Traits::requested_resolution_alignment(input);

      fragment->apply_alignment_to_all_simulcast_layers = Traits::apply_alignment_to_all_simulcast_layers(input);

      fragment->supports_frame_size_change = Traits::supports_frame_size_change(input);

      decltype(Traits::fps_allocation(input)) in_fps_allocation = Traits::fps_allocation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fps_allocation)::BaseType>
          fps_allocation_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& fps_allocation_validate_params =
          mojo::internal::GetArrayValidator<5, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_fps_allocation,
        fps_allocation_fragment,
        &fps_allocation_validate_params);

      fragment->fps_allocation.Set(
          fps_allocation_fragment.is_null() ? nullptr : fps_allocation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fps_allocation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fps_allocation in VideoEncoderInfo struct");

      decltype(Traits::resolution_rate_limits(input)) in_resolution_rate_limits = Traits::resolution_rate_limits(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resolution_rate_limits)::BaseType>
          resolution_rate_limits_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& resolution_rate_limits_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::ResolutionRateLimitDataView>, send_validation>(
        in_resolution_rate_limits,
        resolution_rate_limits_fragment,
        &resolution_rate_limits_validate_params);

      fragment->resolution_rate_limits.Set(
          resolution_rate_limits_fragment.is_null() ? nullptr : resolution_rate_limits_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resolution_rate_limits.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resolution_rate_limits in VideoEncoderInfo struct");

      decltype(Traits::gpu_supported_pixel_formats(input)) in_gpu_supported_pixel_formats = Traits::gpu_supported_pixel_formats(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gpu_supported_pixel_formats)::BaseType>
          gpu_supported_pixel_formats_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& gpu_supported_pixel_formats_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::VideoPixelFormat_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoPixelFormat>, send_validation>(
        in_gpu_supported_pixel_formats,
        gpu_supported_pixel_formats_fragment,
        &gpu_supported_pixel_formats_validate_params);

      fragment->gpu_supported_pixel_formats.Set(
          gpu_supported_pixel_formats_fragment.is_null() ? nullptr : gpu_supported_pixel_formats_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gpu_supported_pixel_formats.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gpu_supported_pixel_formats in VideoEncoderInfo struct");

      fragment->supports_gpu_shared_images = Traits::supports_gpu_shared_images(input);
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_SEND_VALIDATION_H_