// media/mojo/mojom/video_encode_accelerator.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/mojo/mojom/video_encode_accelerator.mojom-shared-internal.h"
#include "media/mojo/mojom/media_log.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "media/mojo/mojom/video_encoder_info.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"


namespace media::mojom {
class VideoEncodeAcceleratorSupportedProfileDataView;

class EncodeCommandBufferIdDataView;

class VariableBitratePeakDataView;

class VideoBitrateAllocationDataView;

class SpatialLayerDataView;

class ConstantBitrateDataView;

class VariableBitrateDataView;

class ExternalBitrateDataView;

class VideoEncodeAcceleratorConfigDataView;

class VideoEncodeOptionsDataView;

class DropFrameMetadataDataView;

class H264MetadataDataView;

class Vp8MetadataDataView;

class Vp9MetadataDataView;

class SVCGenericMetadataDataView;

class BitstreamBufferMetadataDataView;

class BitrateDataView;
class OptionalMetadataDataView;


}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::VideoEncodeAcceleratorSupportedProfileDataView> {
  using Data = ::media::mojom::internal::VideoEncodeAcceleratorSupportedProfile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::EncodeCommandBufferIdDataView> {
  using Data = ::media::mojom::internal::EncodeCommandBufferId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VariableBitratePeakDataView> {
  using Data = ::media::mojom::internal::VariableBitratePeak_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoBitrateAllocationDataView> {
  using Data = ::media::mojom::internal::VideoBitrateAllocation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SpatialLayerDataView> {
  using Data = ::media::mojom::internal::SpatialLayer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::ConstantBitrateDataView> {
  using Data = ::media::mojom::internal::ConstantBitrate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VariableBitrateDataView> {
  using Data = ::media::mojom::internal::VariableBitrate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::ExternalBitrateDataView> {
  using Data = ::media::mojom::internal::ExternalBitrate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoEncodeAcceleratorConfigDataView> {
  using Data = ::media::mojom::internal::VideoEncodeAcceleratorConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoEncodeOptionsDataView> {
  using Data = ::media::mojom::internal::VideoEncodeOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::DropFrameMetadataDataView> {
  using Data = ::media::mojom::internal::DropFrameMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::H264MetadataDataView> {
  using Data = ::media::mojom::internal::H264Metadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::Vp8MetadataDataView> {
  using Data = ::media::mojom::internal::Vp8Metadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::Vp9MetadataDataView> {
  using Data = ::media::mojom::internal::Vp9Metadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SVCGenericMetadataDataView> {
  using Data = ::media::mojom::internal::SVCGenericMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::BitstreamBufferMetadataDataView> {
  using Data = ::media::mojom::internal::BitstreamBufferMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::BitrateDataView> {
  using Data = ::media::mojom::internal::Bitrate_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::media::mojom::OptionalMetadataDataView> {
  using Data = ::media::mojom::internal::OptionalMetadata_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class VideoEncodeAcceleratorSupportedRateControlMode : int32_t {
  
  kNoMode = 0,
  
  kConstantMode = 1,
  
  kVariableMode = 2,
  
  kExternalMode = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorSupportedRateControlMode value);
inline bool IsKnownEnumValue(VideoEncodeAcceleratorSupportedRateControlMode value) {
  return internal::VideoEncodeAcceleratorSupportedRateControlMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoEncodeAcceleratorConfig_ContentType : int32_t {
  
  kCamera = 0,
  
  kDisplay = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_ContentType value);
inline bool IsKnownEnumValue(VideoEncodeAcceleratorConfig_ContentType value) {
  return internal::VideoEncodeAcceleratorConfig_ContentType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoEncodeAcceleratorConfig_StorageType : int32_t {
  
  kShmem = 0,
  
  kGpuMemoryBuffer = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_StorageType value);
inline bool IsKnownEnumValue(VideoEncodeAcceleratorConfig_StorageType value) {
  return internal::VideoEncodeAcceleratorConfig_StorageType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoEncodeAcceleratorConfig_EncoderType : int32_t {
  
  kHardware = 0,
  
  kSoftware = 1,
  
  kNoPreference = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, VideoEncodeAcceleratorConfig_EncoderType value);
inline bool IsKnownEnumValue(VideoEncodeAcceleratorConfig_EncoderType value) {
  return internal::VideoEncodeAcceleratorConfig_EncoderType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class VideoEncodeAcceleratorProviderInterfaceBase {};

using VideoEncodeAcceleratorProviderPtrDataView =
    mojo::InterfacePtrDataView<VideoEncodeAcceleratorProviderInterfaceBase>;
using VideoEncodeAcceleratorProviderRequestDataView =
    mojo::InterfaceRequestDataView<VideoEncodeAcceleratorProviderInterfaceBase>;
using VideoEncodeAcceleratorProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoEncodeAcceleratorProviderInterfaceBase>;
using VideoEncodeAcceleratorProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoEncodeAcceleratorProviderInterfaceBase>;
class VideoEncodeAcceleratorInterfaceBase {};

using VideoEncodeAcceleratorPtrDataView =
    mojo::InterfacePtrDataView<VideoEncodeAcceleratorInterfaceBase>;
using VideoEncodeAcceleratorRequestDataView =
    mojo::InterfaceRequestDataView<VideoEncodeAcceleratorInterfaceBase>;
using VideoEncodeAcceleratorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoEncodeAcceleratorInterfaceBase>;
using VideoEncodeAcceleratorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoEncodeAcceleratorInterfaceBase>;
class VideoEncodeAcceleratorClientInterfaceBase {};

using VideoEncodeAcceleratorClientPtrDataView =
    mojo::InterfacePtrDataView<VideoEncodeAcceleratorClientInterfaceBase>;
using VideoEncodeAcceleratorClientRequestDataView =
    mojo::InterfaceRequestDataView<VideoEncodeAcceleratorClientInterfaceBase>;
using VideoEncodeAcceleratorClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoEncodeAcceleratorClientInterfaceBase>;
using VideoEncodeAcceleratorClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoEncodeAcceleratorClientInterfaceBase>;


class VideoEncodeAcceleratorSupportedProfileDataView {
 public:
  VideoEncodeAcceleratorSupportedProfileDataView() = default;

  VideoEncodeAcceleratorSupportedProfileDataView(
      internal::VideoEncodeAcceleratorSupportedProfile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  ::media::mojom::VideoCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->profile));
  }
  inline void GetMinResolutionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinResolution(UserType* output) {
    
    auto* pointer = data_->min_resolution.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetMaxResolutionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxResolution(UserType* output) {
    
    auto* pointer = data_->max_resolution.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  uint32_t max_framerate_numerator() const {
    return data_->max_framerate_numerator;
  }
  uint32_t max_framerate_denominator() const {
    return data_->max_framerate_denominator;
  }
  inline void GetRateControlModesDataView(
      mojo::ArrayDataView<VideoEncodeAcceleratorSupportedRateControlMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRateControlModes(UserType* output) {
    
    auto* pointer = data_->rate_control_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::VideoEncodeAcceleratorSupportedRateControlMode>>(
        pointer, output, message_);
  }
  inline void GetScalabilityModesDataView(
      mojo::ArrayDataView<::media::mojom::SVCScalabilityMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScalabilityModes(UserType* output) {
    
    auto* pointer = data_->scalability_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::SVCScalabilityMode>>(
        pointer, output, message_);
  }
  bool is_software_codec() const {
    return data_->is_software_codec;
  }
  inline void GetGpuSupportedPixelFormatsDataView(
      mojo::ArrayDataView<::media::mojom::VideoPixelFormat>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuSupportedPixelFormats(UserType* output) {
    
    auto* pointer = data_->gpu_supported_pixel_formats.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::VideoPixelFormat>>(
        pointer, output, message_);
  }
  bool supports_gpu_shared_images() const {
    return data_->supports_gpu_shared_images;
  }
 private:
  internal::VideoEncodeAcceleratorSupportedProfile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EncodeCommandBufferIdDataView {
 public:
  EncodeCommandBufferIdDataView() = default;

  EncodeCommandBufferIdDataView(
      internal::EncodeCommandBufferId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetChannelTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChannelToken(UserType* output) {
    
    auto* pointer = data_->channel_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  int32_t route_id() const {
    return data_->route_id;
  }
 private:
  internal::EncodeCommandBufferId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VariableBitratePeakDataView {
 public:
  VariableBitratePeakDataView() = default;

  VariableBitratePeakDataView(
      internal::VariableBitratePeak_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t bps() const {
    return data_->bps;
  }
 private:
  internal::VariableBitratePeak_Data* data_ = nullptr;
};


class VideoBitrateAllocationDataView {
 public:
  VideoBitrateAllocationDataView() = default;

  VideoBitrateAllocationDataView(
      internal::VideoBitrateAllocation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBitratesDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitrates(UserType* output) {
    
    auto* pointer = data_->bitrates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetVariableBitratePeakDataView(
      VariableBitratePeakDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVariableBitratePeak(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::VariableBitratePeakDataView, UserType>(),
    "Attempting to read the optional `variable_bitrate_peak` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVariableBitratePeak` instead "
    "of `ReadVariableBitratePeak if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->variable_bitrate_peak.Get();
    return mojo::internal::Deserialize<::media::mojom::VariableBitratePeakDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoBitrateAllocation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpatialLayerDataView {
 public:
  SpatialLayerDataView() = default;

  SpatialLayerDataView(
      internal::SpatialLayer_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t width() const {
    return data_->width;
  }
  int32_t height() const {
    return data_->height;
  }
  uint32_t bitrate_bps() const {
    return data_->bitrate_bps;
  }
  uint32_t framerate() const {
    return data_->framerate;
  }
  uint8_t max_qp() const {
    return data_->max_qp;
  }
  uint8_t num_of_temporal_layers() const {
    return data_->num_of_temporal_layers;
  }
 private:
  internal::SpatialLayer_Data* data_ = nullptr;
};


class ConstantBitrateDataView {
 public:
  ConstantBitrateDataView() = default;

  ConstantBitrateDataView(
      internal::ConstantBitrate_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t target_bps() const {
    return data_->target_bps;
  }
 private:
  internal::ConstantBitrate_Data* data_ = nullptr;
};


class VariableBitrateDataView {
 public:
  VariableBitrateDataView() = default;

  VariableBitrateDataView(
      internal::VariableBitrate_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t target_bps() const {
    return data_->target_bps;
  }
  uint32_t peak_bps() const {
    return data_->peak_bps;
  }
 private:
  internal::VariableBitrate_Data* data_ = nullptr;
};


class ExternalBitrateDataView {
 public:
  ExternalBitrateDataView() = default;

  ExternalBitrateDataView(
      internal::ExternalBitrate_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ExternalBitrate_Data* data_ = nullptr;
};


class VideoEncodeAcceleratorConfigDataView {
 public:
  VideoEncodeAcceleratorConfigDataView() = default;

  VideoEncodeAcceleratorConfigDataView(
      internal::VideoEncodeAcceleratorConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadInputFormat(UserType* output) const {
    auto data_value = data_->input_format;
    return mojo::internal::Deserialize<::media::mojom::VideoPixelFormat>(
        data_value, output);
  }
  ::media::mojom::VideoPixelFormat input_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoPixelFormat>(data_->input_format));
  }
  inline void GetInputVisibleSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputVisibleSize(UserType* output) {
    
    auto* pointer = data_->input_visible_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOutputProfile(UserType* output) const {
    auto data_value = data_->output_profile;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  ::media::mojom::VideoCodecProfile output_profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->output_profile));
  }
  inline void GetBitrateDataView(
      BitrateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitrate(UserType* output) {
    
    auto* pointer = !data_->bitrate.is_null() ? &data_->bitrate : nullptr;
    return mojo::internal::Deserialize<::media::mojom::BitrateDataView>(
        pointer, output, message_);
  }
  uint32_t framerate() const {
    return data_->framerate;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageType(UserType* output) const {
    auto data_value = data_->storage_type;
    return mojo::internal::Deserialize<::media::mojom::VideoEncodeAcceleratorConfig_StorageType>(
        data_value, output);
  }
  VideoEncodeAcceleratorConfig_StorageType storage_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoEncodeAcceleratorConfig_StorageType>(data_->storage_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContentType(UserType* output) const {
    auto data_value = data_->content_type;
    return mojo::internal::Deserialize<::media::mojom::VideoEncodeAcceleratorConfig_ContentType>(
        data_value, output);
  }
  VideoEncodeAcceleratorConfig_ContentType content_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoEncodeAcceleratorConfig_ContentType>(data_->content_type));
  }
  uint32_t gop_length() const {
    return data_->gop_length;
  }
  bool has_gop_length() const {
    return data_->has_gop_length;
  }
  uint8_t h264_output_level() const {
    return data_->h264_output_level;
  }
  bool has_h264_output_level() const {
    return data_->has_h264_output_level;
  }
  bool is_constrained_h264() const {
    return data_->is_constrained_h264;
  }
  uint8_t drop_frame_thresh_percentage() const {
    return data_->drop_frame_thresh_percentage;
  }
  inline void GetSpatialLayersDataView(
      mojo::ArrayDataView<SpatialLayerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpatialLayers(UserType* output) {
    
    auto* pointer = data_->spatial_layers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::SpatialLayerDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInterLayerPred(UserType* output) const {
    auto data_value = data_->inter_layer_pred;
    return mojo::internal::Deserialize<::media::mojom::SVCInterLayerPredMode>(
        data_value, output);
  }
  ::media::mojom::SVCInterLayerPredMode inter_layer_pred() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::SVCInterLayerPredMode>(data_->inter_layer_pred));
  }
  bool require_low_delay() const {
    return data_->require_low_delay;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequiredEncoderType(UserType* output) const {
    auto data_value = data_->required_encoder_type;
    return mojo::internal::Deserialize<::media::mojom::VideoEncodeAcceleratorConfig_EncoderType>(
        data_value, output);
  }
  VideoEncodeAcceleratorConfig_EncoderType required_encoder_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoEncodeAcceleratorConfig_EncoderType>(data_->required_encoder_type));
  }
  bool manual_reference_buffer_control() const {
    return data_->manual_reference_buffer_control;
  }
 private:
  internal::VideoEncodeAcceleratorConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeOptionsDataView {
 public:
  VideoEncodeOptionsDataView() = default;

  VideoEncodeOptionsDataView(
      internal::VideoEncodeOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool force_keyframe() const {
    return data_->force_keyframe;
  }
  int32_t quantizer() const {
    return data_->quantizer;
  }
  std::optional<uint8_t> update_buffer() const {

    return data_->update_buffer_$flag
        ? std::make_optional(data_->update_buffer_$value)
        : std::nullopt;
  }
  inline void GetReferenceBuffersDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferenceBuffers(UserType* output) {
    
    auto* pointer = data_->reference_buffers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncodeOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DropFrameMetadataDataView {
 public:
  DropFrameMetadataDataView() = default;

  DropFrameMetadataDataView(
      internal::DropFrameMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t spatial_idx() const {
    return data_->spatial_idx;
  }
  bool end_of_picture() const {
    return data_->end_of_picture;
  }
 private:
  internal::DropFrameMetadata_Data* data_ = nullptr;
};


class H264MetadataDataView {
 public:
  H264MetadataDataView() = default;

  H264MetadataDataView(
      internal::H264Metadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t temporal_idx() const {
    return data_->temporal_idx;
  }
  bool layer_sync() const {
    return data_->layer_sync;
  }
 private:
  internal::H264Metadata_Data* data_ = nullptr;
};


class Vp8MetadataDataView {
 public:
  Vp8MetadataDataView() = default;

  Vp8MetadataDataView(
      internal::Vp8Metadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool non_reference() const {
    return data_->non_reference;
  }
  uint8_t temporal_idx() const {
    return data_->temporal_idx;
  }
  bool layer_sync() const {
    return data_->layer_sync;
  }
 private:
  internal::Vp8Metadata_Data* data_ = nullptr;
};


class Vp9MetadataDataView {
 public:
  Vp9MetadataDataView() = default;

  Vp9MetadataDataView(
      internal::Vp9Metadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool inter_pic_predicted() const {
    return data_->inter_pic_predicted;
  }
  bool temporal_up_switch() const {
    return data_->temporal_up_switch;
  }
  bool referenced_by_upper_spatial_layers() const {
    return data_->referenced_by_upper_spatial_layers;
  }
  bool reference_lower_spatial_layers() const {
    return data_->reference_lower_spatial_layers;
  }
  bool end_of_picture() const {
    return data_->end_of_picture;
  }
  uint8_t temporal_idx() const {
    return data_->temporal_idx;
  }
  uint8_t spatial_idx() const {
    return data_->spatial_idx;
  }
  inline void GetSpatialLayerResolutionsDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpatialLayerResolutions(UserType* output) {
    
    auto* pointer = data_->spatial_layer_resolutions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
  uint8_t begin_active_spatial_layer_index() const {
    return data_->begin_active_spatial_layer_index;
  }
  uint8_t end_active_spatial_layer_index() const {
    return data_->end_active_spatial_layer_index;
  }
  inline void GetPDiffsDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPDiffs(UserType* output) {
    
    auto* pointer = data_->p_diffs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::Vp9Metadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SVCGenericMetadataDataView {
 public:
  SVCGenericMetadataDataView() = default;

  SVCGenericMetadataDataView(
      internal::SVCGenericMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool follow_svc_spec() const {
    return data_->follow_svc_spec;
  }
  uint8_t temporal_idx() const {
    return data_->temporal_idx;
  }
  uint8_t spatial_idx() const {
    return data_->spatial_idx;
  }
  std::optional<uint16_t> reference_flags() const {

    return data_->reference_flags_$flag
        ? std::make_optional(data_->reference_flags_$value)
        : std::nullopt;
  }
  std::optional<uint16_t> refresh_flags() const {

    return data_->refresh_flags_$flag
        ? std::make_optional(data_->refresh_flags_$value)
        : std::nullopt;
  }
 private:
  internal::SVCGenericMetadata_Data* data_ = nullptr;
};


class BitstreamBufferMetadataDataView {
 public:
  BitstreamBufferMetadataDataView() = default;

  BitstreamBufferMetadataDataView(
      internal::BitstreamBufferMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t payload_size_bytes() const {
    return data_->payload_size_bytes;
  }
  bool key_frame() const {
    return data_->key_frame;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  int32_t qp() const {
    return data_->qp;
  }
  inline void GetOptionalMetadataDataView(
      OptionalMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptionalMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::OptionalMetadataDataView, UserType>(),
    "Attempting to read the optional `optional_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOptionalMetadata` instead "
    "of `ReadOptionalMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->optional_metadata.is_null() ? &data_->optional_metadata : nullptr;
    return mojo::internal::Deserialize<::media::mojom::OptionalMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetSvcGenericDataView(
      SVCGenericMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSvcGeneric(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::SVCGenericMetadataDataView, UserType>(),
    "Attempting to read the optional `svc_generic` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSvcGeneric` instead "
    "of `ReadSvcGeneric if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->svc_generic.Get();
    return mojo::internal::Deserialize<::media::mojom::SVCGenericMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetEncodedSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodedSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `encoded_size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEncodedSize` instead "
    "of `ReadEncodedSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->encoded_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetEncodedColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodedColorSpace(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ColorSpaceDataView, UserType>(),
    "Attempting to read the optional `encoded_color_space` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEncodedColorSpace` instead "
    "of `ReadEncodedColorSpace if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->encoded_color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
 private:
  internal::BitstreamBufferMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BitrateDataView {
 public:
  using Tag = internal::Bitrate_Data::Bitrate_Tag;

  BitrateDataView() = default;

  BitrateDataView(
      internal::Bitrate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_constant() const { return data_->tag == Tag::kConstant; }
  inline void GetConstantDataView(
      ConstantBitrateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadConstant(UserType* output) const {
    
    CHECK(is_constant());
    return mojo::internal::Deserialize<::media::mojom::ConstantBitrateDataView>(
        data_->data.f_constant.Get(), output, message_);
  }
  bool is_variable() const { return data_->tag == Tag::kVariable; }
  inline void GetVariableDataView(
      VariableBitrateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadVariable(UserType* output) const {
    
    CHECK(is_variable());
    return mojo::internal::Deserialize<::media::mojom::VariableBitrateDataView>(
        data_->data.f_variable.Get(), output, message_);
  }
  bool is_external() const { return data_->tag == Tag::kExternal; }
  inline void GetExternalDataView(
      ExternalBitrateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadExternal(UserType* output) const {
    
    CHECK(is_external());
    return mojo::internal::Deserialize<::media::mojom::ExternalBitrateDataView>(
        data_->data.f_external.Get(), output, message_);
  }

 private:
  internal::Bitrate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class OptionalMetadataDataView {
 public:
  using Tag = internal::OptionalMetadata_Data::OptionalMetadata_Tag;

  OptionalMetadataDataView() = default;

  OptionalMetadataDataView(
      internal::OptionalMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_drop() const { return data_->tag == Tag::kDrop; }
  inline void GetDropDataView(
      DropFrameMetadataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDrop(UserType* output) const {
    
    CHECK(is_drop());
    return mojo::internal::Deserialize<::media::mojom::DropFrameMetadataDataView>(
        data_->data.f_drop.Get(), output, message_);
  }
  bool is_h264() const { return data_->tag == Tag::kH264; }
  inline void GetH264DataView(
      H264MetadataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadH264(UserType* output) const {
    
    CHECK(is_h264());
    return mojo::internal::Deserialize<::media::mojom::H264MetadataDataView>(
        data_->data.f_h264.Get(), output, message_);
  }
  bool is_vp8() const { return data_->tag == Tag::kVp8; }
  inline void GetVp8DataView(
      Vp8MetadataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadVp8(UserType* output) const {
    
    CHECK(is_vp8());
    return mojo::internal::Deserialize<::media::mojom::Vp8MetadataDataView>(
        data_->data.f_vp8.Get(), output, message_);
  }
  bool is_vp9() const { return data_->tag == Tag::kVp9; }
  inline void GetVp9DataView(
      Vp9MetadataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadVp9(UserType* output) const {
    
    CHECK(is_vp9());
    return mojo::internal::Deserialize<::media::mojom::Vp9MetadataDataView>(
        data_->data.f_vp9.Get(), output, message_);
  }

 private:
  internal::OptionalMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_DATA_VIEW_H_