// media/mojo/mojom/video_encode_accelerator.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_BLINK_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_BLINK_TEST_UTILS_H_

#include "media/mojo/mojom/video_encode_accelerator.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace media::mojom::blink {


class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProviderInterceptorForTesting : public VideoEncodeAcceleratorProvider {
  virtual VideoEncodeAcceleratorProvider* GetForwardingInterface() = 0;
  void CreateVideoEncodeAccelerator(EncodeCommandBufferIdPtr command_buffer_id, ::mojo::PendingReceiver<VideoEncodeAccelerator> receiver) override;
  void GetVideoEncodeAcceleratorSupportedProfiles(GetVideoEncodeAcceleratorSupportedProfilesCallback callback) override;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorProviderAsyncWaiter {
 public:
  explicit VideoEncodeAcceleratorProviderAsyncWaiter(VideoEncodeAcceleratorProvider* proxy);

  VideoEncodeAcceleratorProviderAsyncWaiter(const VideoEncodeAcceleratorProviderAsyncWaiter&) = delete;
  VideoEncodeAcceleratorProviderAsyncWaiter& operator=(const VideoEncodeAcceleratorProviderAsyncWaiter&) = delete;

  ~VideoEncodeAcceleratorProviderAsyncWaiter();
  void GetVideoEncodeAcceleratorSupportedProfiles(
      ::blink::Vector<VideoEncodeAcceleratorSupportedProfilePtr>* out_profiles);
  ::blink::Vector<VideoEncodeAcceleratorSupportedProfilePtr> GetVideoEncodeAcceleratorSupportedProfiles();

 private:
  VideoEncodeAcceleratorProvider* const proxy_;
};


class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorInterceptorForTesting : public VideoEncodeAccelerator {
  virtual VideoEncodeAccelerator* GetForwardingInterface() = 0;
  void Initialize(VideoEncodeAcceleratorConfigPtr config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log, InitializeCallback callback) override;
  void Encode(::media::mojom::blink::VideoFramePtr frame, VideoEncodeOptionsPtr options, EncodeCallback callback) override;
  void UseOutputBitstreamBuffer(int32_t bitstream_buffer_id, ::base::UnsafeSharedMemoryRegion region) override;
  void RequestEncodingParametersChangeWithLayers(VideoBitrateAllocationPtr bitrate_allocation, uint32_t framerate, const std::optional<::gfx::Size>& size) override;
  void RequestEncodingParametersChangeWithBitrate(BitratePtr bitrate, uint32_t framerate, const std::optional<::gfx::Size>& size) override;
  void IsFlushSupported(IsFlushSupportedCallback callback) override;
  void Flush(FlushCallback callback) override;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorAsyncWaiter {
 public:
  explicit VideoEncodeAcceleratorAsyncWaiter(VideoEncodeAccelerator* proxy);

  VideoEncodeAcceleratorAsyncWaiter(const VideoEncodeAcceleratorAsyncWaiter&) = delete;
  VideoEncodeAcceleratorAsyncWaiter& operator=(const VideoEncodeAcceleratorAsyncWaiter&) = delete;

  ~VideoEncodeAcceleratorAsyncWaiter();
  void Initialize(
      VideoEncodeAcceleratorConfigPtr config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log, ::media::mojom::blink::EncoderStatusPtr* out_result);
  ::media::mojom::blink::EncoderStatusPtr Initialize(VideoEncodeAcceleratorConfigPtr config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::blink::MediaLog> media_log);
  void Encode(
      ::media::mojom::blink::VideoFramePtr frame, VideoEncodeOptionsPtr options);
  
  void IsFlushSupported(
      bool* out_result);
  bool IsFlushSupported();
  void Flush(
      bool* out_result);
  bool Flush();

 private:
  VideoEncodeAccelerator* const proxy_;
};


class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorClientInterceptorForTesting : public VideoEncodeAcceleratorClient {
  virtual VideoEncodeAcceleratorClient* GetForwardingInterface() = 0;
  void RequireBitstreamBuffers(uint32_t input_count, const ::gfx::Size& input_coded_size, uint32_t output_buffer_size) override;
  void BitstreamBufferReady(int32_t bitstream_buffer_id, BitstreamBufferMetadataPtr metadata) override;
  void NotifyErrorStatus(::media::mojom::blink::EncoderStatusPtr status) override;
  void NotifyEncoderInfoChange(::media::mojom::blink::VideoEncoderInfoPtr info) override;
};
class BLINK_PLATFORM_EXPORT VideoEncodeAcceleratorClientAsyncWaiter {
 public:
  explicit VideoEncodeAcceleratorClientAsyncWaiter(VideoEncodeAcceleratorClient* proxy);

  VideoEncodeAcceleratorClientAsyncWaiter(const VideoEncodeAcceleratorClientAsyncWaiter&) = delete;
  VideoEncodeAcceleratorClientAsyncWaiter& operator=(const VideoEncodeAcceleratorClientAsyncWaiter&) = delete;

  ~VideoEncodeAcceleratorClientAsyncWaiter();

 private:
  VideoEncodeAcceleratorClient* const proxy_;
};




}  // media::mojom::blink

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_BLINK_TEST_UTILS_H_