// media/mojo/mojom/video_decoder.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  SyncToken as gpu_mojom_SyncToken,
  SyncTokenSpec as gpu_mojom_SyncTokenSpec
} from '../../../gpu/ipc/common/sync_token.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  ColorSpace as gfx_mojom_ColorSpace,
  ColorSpaceSpec as gfx_mojom_ColorSpaceSpec
} from '../../../ui/gfx/mojom/color_space.mojom.m.js';

import {
  MediaLogRemote as media_mojom_MediaLogRemote,
  MediaLogPendingReceiver as media_mojom_MediaLogPendingReceiver
} from './media_log.mojom.m.js';

import {
  VideoCodecProfile as media_mojom_VideoCodecProfile,
  VideoCodecProfileSpec as media_mojom_VideoCodecProfileSpec,
  VideoDecoderType as media_mojom_VideoDecoderType,
  VideoDecoderTypeSpec as media_mojom_VideoDecoderTypeSpec,
  WaitingReason as media_mojom_WaitingReason,
  WaitingReasonSpec as media_mojom_WaitingReasonSpec,
  DecoderStatus as media_mojom_DecoderStatus,
  DecoderStatusSpec as media_mojom_DecoderStatusSpec,
  VideoDecoderConfig as media_mojom_VideoDecoderConfig,
  VideoDecoderConfigSpec as media_mojom_VideoDecoderConfigSpec,
  VideoFrame as media_mojom_VideoFrame,
  VideoFrameSpec as media_mojom_VideoFrameSpec,
  DecoderBuffer as media_mojom_DecoderBuffer,
  DecoderBufferSpec as media_mojom_DecoderBufferSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoFrameHandleReleaserPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoFrameHandleReleaser', scope);
  }
}

/** @interface */
export class VideoFrameHandleReleaserInterface {
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } releaseToken
   * @param { ?gpu_mojom_SyncToken } releaseSyncToken
   */

  releaseVideoFrame(releaseToken, releaseSyncToken) {}
}

/**
 * @implements { VideoFrameHandleReleaserInterface }
 */
export class VideoFrameHandleReleaserRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoFrameHandleReleaserPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoFrameHandleReleaserPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoFrameHandleReleaserPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } releaseToken
   * @param { ?gpu_mojom_SyncToken } releaseSyncToken
   */

  releaseVideoFrame(
      releaseToken,
      releaseSyncToken) {
    this.proxy.sendMessage(
        0,
        VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec.$,
        null,
        [
          releaseToken,
          releaseSyncToken
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoFrameHandleReleaser
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoFrameHandleReleaserReceiver {
  /**
   * @param {!VideoFrameHandleReleaserInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoFrameHandleReleaserRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoFrameHandleReleaserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoFrameHandleReleaserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec.$,
        null,
        impl.releaseVideoFrame.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoFrameHandleReleaser {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoFrameHandleReleaser";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoFrameHandleReleaserRemote}
   */
  static getRemote() {
    let remote = new VideoFrameHandleReleaserRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoFrameHandleReleaser
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoFrameHandleReleaserCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoFrameHandleReleaserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoFrameHandleReleaserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.releaseVideoFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec.$,
        null,
        this.releaseVideoFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoDecoderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoDecoder', scope);
  }
}

/** @interface */
export class VideoDecoderInterface {
  
  /**
   * @return {!Promise<{
        supportedConfigs: !Array<!SupportedVideoDecoderConfig>,
        decoderType: !media_mojom_VideoDecoderType,
   *  }>}
   */

  getSupportedConfigs() {}
  
  /**
   * @param { !Object } client
   * @param { !media_mojom_MediaLogRemote } mediaLog
   * @param { !VideoFrameHandleReleaserPendingReceiver } videoFrameHandleReleaser
   * @param { !MojoHandle } decoderBufferPipe
   * @param { ?CommandBufferId } commandBufferId
   * @param { !gfx_mojom_ColorSpace } targetColorSpace
   */

  construct(client, mediaLog, videoFrameHandleReleaser, decoderBufferPipe, commandBufferId, targetColorSpace) {}
  
  /**
   * @param { !media_mojom_VideoDecoderConfig } config
   * @param { !boolean } lowDelay
   * @param { ?Cdm } cdm
   * @return {!Promise<{
        status: !media_mojom_DecoderStatus,
        needsBitstreamConversion: !boolean,
        maxDecodeRequests: !number,
        decoderType: !media_mojom_VideoDecoderType,
        needsTranscryption: !boolean,
   *  }>}
   */

  initialize(config, lowDelay, cdm) {}
  
  /**
   * @param { !media_mojom_DecoderBuffer } buffer
   * @return {!Promise<{
        status: !media_mojom_DecoderStatus,
   *  }>}
   */

  decode(buffer) {}
  
  /**
   * @return {!Promise}
   */

  reset() {}
  
  /**
   * @param { !OverlayInfo } overlayInfo
   */

  onOverlayInfoChanged(overlayInfo) {}
}

/**
 * @implements { VideoDecoderInterface }
 */
export class VideoDecoderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoDecoderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoDecoderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoDecoderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        supportedConfigs: !Array<!SupportedVideoDecoderConfig>,
        decoderType: !media_mojom_VideoDecoderType,
   *  }>}
   */

  getSupportedConfigs() {
    return this.proxy.sendMessage(
        0,
        VideoDecoder_GetSupportedConfigs_ParamsSpec.$,
        VideoDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   * @param { !media_mojom_MediaLogRemote } mediaLog
   * @param { !VideoFrameHandleReleaserPendingReceiver } videoFrameHandleReleaser
   * @param { !MojoHandle } decoderBufferPipe
   * @param { ?CommandBufferId } commandBufferId
   * @param { !gfx_mojom_ColorSpace } targetColorSpace
   */

  construct(
      client,
      mediaLog,
      videoFrameHandleReleaser,
      decoderBufferPipe,
      commandBufferId,
      targetColorSpace) {
    this.proxy.sendMessage(
        1,
        VideoDecoder_Construct_ParamsSpec.$,
        null,
        [
          client,
          mediaLog,
          videoFrameHandleReleaser,
          decoderBufferPipe,
          commandBufferId,
          targetColorSpace
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoDecoderConfig } config
   * @param { !boolean } lowDelay
   * @param { ?Cdm } cdm
   * @return {!Promise<{
        status: !media_mojom_DecoderStatus,
        needsBitstreamConversion: !boolean,
        maxDecodeRequests: !number,
        decoderType: !media_mojom_VideoDecoderType,
        needsTranscryption: !boolean,
   *  }>}
   */

  initialize(
      config,
      lowDelay,
      cdm) {
    return this.proxy.sendMessage(
        2,
        VideoDecoder_Initialize_ParamsSpec.$,
        VideoDecoder_Initialize_ResponseParamsSpec.$,
        [
          config,
          lowDelay,
          cdm
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_DecoderBuffer } buffer
   * @return {!Promise<{
        status: !media_mojom_DecoderStatus,
   *  }>}
   */

  decode(
      buffer) {
    return this.proxy.sendMessage(
        3,
        VideoDecoder_Decode_ParamsSpec.$,
        VideoDecoder_Decode_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  reset() {
    return this.proxy.sendMessage(
        4,
        VideoDecoder_Reset_ParamsSpec.$,
        VideoDecoder_Reset_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !OverlayInfo } overlayInfo
   */

  onOverlayInfoChanged(
      overlayInfo) {
    this.proxy.sendMessage(
        5,
        VideoDecoder_OnOverlayInfoChanged_ParamsSpec.$,
        null,
        [
          overlayInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoDecoder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoDecoderReceiver {
  /**
   * @param {!VideoDecoderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoDecoderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoDecoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoDecoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoDecoder_GetSupportedConfigs_ParamsSpec.$,
        VideoDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        impl.getSupportedConfigs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        VideoDecoder_Construct_ParamsSpec.$,
        null,
        impl.construct.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        VideoDecoder_Initialize_ParamsSpec.$,
        VideoDecoder_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        VideoDecoder_Decode_ParamsSpec.$,
        VideoDecoder_Decode_ResponseParamsSpec.$,
        impl.decode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        VideoDecoder_Reset_ParamsSpec.$,
        VideoDecoder_Reset_ResponseParamsSpec.$,
        impl.reset.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        VideoDecoder_OnOverlayInfoChanged_ParamsSpec.$,
        null,
        impl.onOverlayInfoChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoDecoder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoDecoder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoDecoderRemote}
   */
  static getRemote() {
    let remote = new VideoDecoderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoDecoder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoDecoderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoDecoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoDecoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSupportedConfigs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoDecoder_GetSupportedConfigs_ParamsSpec.$,
        VideoDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        this.getSupportedConfigs.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.construct =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        VideoDecoder_Construct_ParamsSpec.$,
        null,
        this.construct.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        VideoDecoder_Initialize_ParamsSpec.$,
        VideoDecoder_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        VideoDecoder_Decode_ParamsSpec.$,
        VideoDecoder_Decode_ResponseParamsSpec.$,
        this.decode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        VideoDecoder_Reset_ParamsSpec.$,
        VideoDecoder_Reset_ResponseParamsSpec.$,
        this.reset.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onOverlayInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        VideoDecoder_OnOverlayInfoChanged_ParamsSpec.$,
        null,
        this.onOverlayInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoDecoderClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoDecoderClient', scope);
  }
}

/** @interface */
export class VideoDecoderClientInterface {
  
  /**
   * @param { !media_mojom_VideoFrame } frame
   * @param { !boolean } canReadWithoutStalling
   * @param { ?mojoBase_mojom_UnguessableToken } releaseToken
   */

  onVideoFrameDecoded(frame, canReadWithoutStalling, releaseToken) {}
  
  /**
   * @param { !media_mojom_WaitingReason } reason
   */

  onWaiting(reason) {}
  
  /**
   */

  requestOverlayInfo() {}
}

/**
 * @implements { VideoDecoderClientInterface }
 */
export class VideoDecoderClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoDecoderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoDecoderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoDecoderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_VideoFrame } frame
   * @param { !boolean } canReadWithoutStalling
   * @param { ?mojoBase_mojom_UnguessableToken } releaseToken
   */

  onVideoFrameDecoded(
      frame,
      canReadWithoutStalling,
      releaseToken) {
    this.proxy.sendMessage(
        0,
        VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec.$,
        null,
        [
          frame,
          canReadWithoutStalling,
          releaseToken
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_WaitingReason } reason
   */

  onWaiting(
      reason) {
    this.proxy.sendMessage(
        1,
        VideoDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }

  
  /**
   */

  requestOverlayInfo() {
    this.proxy.sendMessage(
        2,
        VideoDecoderClient_RequestOverlayInfo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoDecoderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoDecoderClientReceiver {
  /**
   * @param {!VideoDecoderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoDecoderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoDecoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoDecoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec.$,
        null,
        impl.onVideoFrameDecoded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        VideoDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        impl.onWaiting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        VideoDecoderClient_RequestOverlayInfo_ParamsSpec.$,
        null,
        impl.requestOverlayInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoDecoderClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoDecoderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoDecoderClientRemote}
   */
  static getRemote() {
    let remote = new VideoDecoderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoDecoderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoDecoderClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoDecoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoDecoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoFrameDecoded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec.$,
        null,
        this.onVideoFrameDecoded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWaiting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        VideoDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        this.onWaiting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestOverlayInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        VideoDecoderClient_RequestOverlayInfo_ParamsSpec.$,
        null,
        this.requestOverlayInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SupportedVideoDecoderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CommandBufferIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OverlayInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoder_GetSupportedConfigs_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoder_GetSupportedConfigs_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoder_Construct_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoder_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoder_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoder_Decode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoder_Decode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoder_Reset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoder_Reset_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoder_OnOverlayInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoderClient_OnWaiting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoderClient_RequestOverlayInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const CdmSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SupportedVideoDecoderConfigSpec.$,
    'SupportedVideoDecoderConfig',
    [
      mojo.internal.StructField(
        'profileMin', 0,
        0,
        media_mojom_VideoCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'profileMax', 4,
        0,
        media_mojom_VideoCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codedSizeMin', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codedSizeMax', 16,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowEncrypted', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requireEncrypted', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class SupportedVideoDecoderConfig {
  constructor() {
    /** @type { !media_mojom_VideoCodecProfile } */
    this.profileMin;
    /** @type { !media_mojom_VideoCodecProfile } */
    this.profileMax;
    /** @type { !gfx_mojom_Size } */
    this.codedSizeMin;
    /** @type { !gfx_mojom_Size } */
    this.codedSizeMax;
    /** @type { !boolean } */
    this.allowEncrypted;
    /** @type { !boolean } */
    this.requireEncrypted;
  }
}



mojo.internal.Struct(
    CommandBufferIdSpec.$,
    'CommandBufferId',
    [
      mojo.internal.StructField(
        'channelToken', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'routeId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CommandBufferId {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.channelToken;
    /** @type { !number } */
    this.routeId;
  }
}



mojo.internal.Struct(
    OverlayInfoSpec.$,
    'OverlayInfo',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class OverlayInfo {
  constructor() {
  }
}



mojo.internal.Struct(
    VideoFrameHandleReleaser_ReleaseVideoFrame_ParamsSpec.$,
    'VideoFrameHandleReleaser_ReleaseVideoFrame_Params',
    [
      mojo.internal.StructField(
        'releaseToken', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'releaseSyncToken', 8,
        0,
        gpu_mojom_SyncTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoFrameHandleReleaser_ReleaseVideoFrame_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.releaseToken;
    /** @type { (gpu_mojom_SyncToken|undefined) } */
    this.releaseSyncToken;
  }
}



mojo.internal.Struct(
    VideoDecoder_GetSupportedConfigs_ParamsSpec.$,
    'VideoDecoder_GetSupportedConfigs_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VideoDecoder_GetSupportedConfigs_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    VideoDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
    'VideoDecoder_GetSupportedConfigs_ResponseParams',
    [
      mojo.internal.StructField(
        'supportedConfigs', 0,
        0,
        mojo.internal.Array(SupportedVideoDecoderConfigSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decoderType', 8,
        0,
        media_mojom_VideoDecoderTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoDecoder_GetSupportedConfigs_ResponseParams {
  constructor() {
    /** @type { !Array<!SupportedVideoDecoderConfig> } */
    this.supportedConfigs;
    /** @type { !media_mojom_VideoDecoderType } */
    this.decoderType;
  }
}



mojo.internal.Struct(
    VideoDecoder_Construct_ParamsSpec.$,
    'VideoDecoder_Construct_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(VideoDecoderClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaLog', 8,
        0,
        mojo.internal.InterfaceProxy(media_mojom_MediaLogRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoFrameHandleReleaser', 16,
        0,
        mojo.internal.InterfaceRequest(VideoFrameHandleReleaserPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decoderBufferPipe', 20,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'commandBufferId', 24,
        0,
        CommandBufferIdSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetColorSpace', 32,
        0,
        gfx_mojom_ColorSpaceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class VideoDecoder_Construct_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
    /** @type { !media_mojom_MediaLogRemote } */
    this.mediaLog;
    /** @type { !VideoFrameHandleReleaserPendingReceiver } */
    this.videoFrameHandleReleaser;
    /** @type { !MojoHandle } */
    this.decoderBufferPipe;
    /** @type { (CommandBufferId|undefined) } */
    this.commandBufferId;
    /** @type { !gfx_mojom_ColorSpace } */
    this.targetColorSpace;
  }
}



mojo.internal.Struct(
    VideoDecoder_Initialize_ParamsSpec.$,
    'VideoDecoder_Initialize_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media_mojom_VideoDecoderConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lowDelay', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cdm', 16,
        0,
        CdmSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class VideoDecoder_Initialize_Params {
  constructor() {
    /** @type { !media_mojom_VideoDecoderConfig } */
    this.config;
    /** @type { !boolean } */
    this.lowDelay;
    /** @type { (Cdm|undefined) } */
    this.cdm;
  }
}



mojo.internal.Struct(
    VideoDecoder_Initialize_ResponseParamsSpec.$,
    'VideoDecoder_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_DecoderStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'needsBitstreamConversion', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxDecodeRequests', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decoderType', 16,
        0,
        media_mojom_VideoDecoderTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'needsTranscryption', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class VideoDecoder_Initialize_ResponseParams {
  constructor() {
    /** @type { !media_mojom_DecoderStatus } */
    this.status;
    /** @type { !boolean } */
    this.needsBitstreamConversion;
    /** @type { !number } */
    this.maxDecodeRequests;
    /** @type { !media_mojom_VideoDecoderType } */
    this.decoderType;
    /** @type { !boolean } */
    this.needsTranscryption;
  }
}



mojo.internal.Struct(
    VideoDecoder_Decode_ParamsSpec.$,
    'VideoDecoder_Decode_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media_mojom_DecoderBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoDecoder_Decode_Params {
  constructor() {
    /** @type { !media_mojom_DecoderBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    VideoDecoder_Decode_ResponseParamsSpec.$,
    'VideoDecoder_Decode_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_DecoderStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoDecoder_Decode_ResponseParams {
  constructor() {
    /** @type { !media_mojom_DecoderStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    VideoDecoder_Reset_ParamsSpec.$,
    'VideoDecoder_Reset_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VideoDecoder_Reset_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    VideoDecoder_Reset_ResponseParamsSpec.$,
    'VideoDecoder_Reset_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VideoDecoder_Reset_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    VideoDecoder_OnOverlayInfoChanged_ParamsSpec.$,
    'VideoDecoder_OnOverlayInfoChanged_Params',
    [
      mojo.internal.StructField(
        'overlayInfo', 0,
        0,
        OverlayInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoDecoder_OnOverlayInfoChanged_Params {
  constructor() {
    /** @type { !OverlayInfo } */
    this.overlayInfo;
  }
}



mojo.internal.Struct(
    VideoDecoderClient_OnVideoFrameDecoded_ParamsSpec.$,
    'VideoDecoderClient_OnVideoFrameDecoded_Params',
    [
      mojo.internal.StructField(
        'frame', 0,
        0,
        media_mojom_VideoFrameSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'canReadWithoutStalling', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'releaseToken', 16,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class VideoDecoderClient_OnVideoFrameDecoded_Params {
  constructor() {
    /** @type { !media_mojom_VideoFrame } */
    this.frame;
    /** @type { !boolean } */
    this.canReadWithoutStalling;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.releaseToken;
  }
}



mojo.internal.Struct(
    VideoDecoderClient_OnWaiting_ParamsSpec.$,
    'VideoDecoderClient_OnWaiting_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        media_mojom_WaitingReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoDecoderClient_OnWaiting_Params {
  constructor() {
    /** @type { !media_mojom_WaitingReason } */
    this.reason;
  }
}



mojo.internal.Struct(
    VideoDecoderClient_RequestOverlayInfo_ParamsSpec.$,
    'VideoDecoderClient_RequestOverlayInfo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VideoDecoderClient_RequestOverlayInfo_Params {
  constructor() {
  }
}

mojo.internal.Union(
    CdmSpec.$, 'Cdm',
    {
      'cdmId': {
        'ordinal': 0,
        'type': mojoBase_mojom_UnguessableTokenSpec.$,
      },
    });

/**
 * @typedef { {
 *   cdmId: (!mojoBase_mojom_UnguessableToken|undefined),
 * } }
 */
export const Cdm = {};
