// media/mojo/mojom/video_decoder.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_TEST_UTILS_H_

#include "media/mojo/mojom/video_decoder.mojom.h"


namespace media::mojom {


class  VideoFrameHandleReleaserInterceptorForTesting : public VideoFrameHandleReleaser {
  virtual VideoFrameHandleReleaser* GetForwardingInterface() = 0;
  void ReleaseVideoFrame(const ::base::UnguessableToken& release_token, const std::optional<::gpu::SyncToken>& release_sync_token) override;
};
class  VideoFrameHandleReleaserAsyncWaiter {
 public:
  explicit VideoFrameHandleReleaserAsyncWaiter(VideoFrameHandleReleaser* proxy);

  VideoFrameHandleReleaserAsyncWaiter(const VideoFrameHandleReleaserAsyncWaiter&) = delete;
  VideoFrameHandleReleaserAsyncWaiter& operator=(const VideoFrameHandleReleaserAsyncWaiter&) = delete;

  ~VideoFrameHandleReleaserAsyncWaiter();

 private:
  VideoFrameHandleReleaser* const proxy_;
};


class  VideoDecoderInterceptorForTesting : public VideoDecoder {
  virtual VideoDecoder* GetForwardingInterface() = 0;
  void GetSupportedConfigs(GetSupportedConfigsCallback callback) override;
  void Construct(::mojo::PendingAssociatedRemote<VideoDecoderClient> client, ::mojo::PendingRemote<::media::mojom::MediaLog> media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle decoder_buffer_pipe, CommandBufferIdPtr command_buffer_id, const ::gfx::ColorSpace& target_color_space) override;
  void Initialize(const ::media::VideoDecoderConfig& config, bool low_delay, CdmPtr cdm, InitializeCallback callback) override;
  void Decode(::media::mojom::DecoderBufferPtr buffer, DecodeCallback callback) override;
  void Reset(ResetCallback callback) override;
  void OnOverlayInfoChanged(const ::media::OverlayInfo& overlay_info) override;
};
class  VideoDecoderAsyncWaiter {
 public:
  explicit VideoDecoderAsyncWaiter(VideoDecoder* proxy);

  VideoDecoderAsyncWaiter(const VideoDecoderAsyncWaiter&) = delete;
  VideoDecoderAsyncWaiter& operator=(const VideoDecoderAsyncWaiter&) = delete;

  ~VideoDecoderAsyncWaiter();
  void GetSupportedConfigs(
      std::vector<::media::SupportedVideoDecoderConfig>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type);
  
  void Initialize(
      const ::media::VideoDecoderConfig& config, bool low_delay, CdmPtr cdm, ::media::DecoderStatus* out_status, bool* out_needs_bitstream_conversion, int32_t* out_max_decode_requests, ::media::VideoDecoderType* out_decoder_type, bool* out_needs_transcryption);
  
  void Decode(
      ::media::mojom::DecoderBufferPtr buffer, ::media::DecoderStatus* out_status);
  ::media::DecoderStatus Decode(::media::mojom::DecoderBufferPtr buffer);
  void Reset(
      );
  

 private:
  VideoDecoder* const proxy_;
};


class  VideoDecoderClientInterceptorForTesting : public VideoDecoderClient {
  virtual VideoDecoderClient* GetForwardingInterface() = 0;
  void OnVideoFrameDecoded(const ::scoped_refptr<::media::VideoFrame>& frame, bool can_read_without_stalling, const std::optional<::base::UnguessableToken>& release_token) override;
  void OnWaiting(::media::WaitingReason reason) override;
  void RequestOverlayInfo() override;
};
class  VideoDecoderClientAsyncWaiter {
 public:
  explicit VideoDecoderClientAsyncWaiter(VideoDecoderClient* proxy);

  VideoDecoderClientAsyncWaiter(const VideoDecoderClientAsyncWaiter&) = delete;
  VideoDecoderClientAsyncWaiter& operator=(const VideoDecoderClientAsyncWaiter&) = delete;

  ~VideoDecoderClientAsyncWaiter();

 private:
  VideoDecoderClient* const proxy_;
};




}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_TEST_UTILS_H_