// media/mojo/mojom/video_decoder.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/video_decoder.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "media/mojo/mojom/media_log.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"

#include "media/mojo/mojom/video_decoder.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::SupportedVideoDecoderConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SupportedVideoDecoderConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SupportedVideoDecoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::profile_min(input),
        &fragment->profile_min);

      
      mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::profile_max(input),
        &fragment->profile_max);

      decltype(Traits::coded_size_min(input)) in_coded_size_min = Traits::coded_size_min(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->coded_size_min)::BaseType> coded_size_min_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_coded_size_min,
        coded_size_min_fragment);

      fragment->coded_size_min.Set(
          coded_size_min_fragment.is_null() ? nullptr : coded_size_min_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->coded_size_min.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size_min in SupportedVideoDecoderConfig struct");

      decltype(Traits::coded_size_max(input)) in_coded_size_max = Traits::coded_size_max(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->coded_size_max)::BaseType> coded_size_max_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_coded_size_max,
        coded_size_max_fragment);

      fragment->coded_size_max.Set(
          coded_size_max_fragment.is_null() ? nullptr : coded_size_max_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->coded_size_max.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size_max in SupportedVideoDecoderConfig struct");

      fragment->allow_encrypted = Traits::allow_encrypted(input);

      fragment->require_encrypted = Traits::require_encrypted(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::CommandBufferIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CommandBufferIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CommandBufferId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::channel_token(input)) in_channel_token = Traits::channel_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->channel_token)::BaseType> channel_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_channel_token,
        channel_token_fragment);

      fragment->channel_token.Set(
          channel_token_fragment.is_null() ? nullptr : channel_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->channel_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null channel_token in CommandBufferId struct");

      fragment->route_id = Traits::route_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::OverlayInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::OverlayInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::OverlayInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::CdmDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::CdmDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::Cdm_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::CdmDataView::Tag::kCdmId: {
    decltype(Traits::cdm_id(input))
    in_cdm_id = Traits::cdm_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cdm_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
  in_cdm_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cdm_id in Cdm union");
    fragment->data.f_cdm_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_SEND_VALIDATION_H_