// media/mojo/mojom/speech_recognizer.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_TEST_UTILS_H_

#include "media/mojo/mojom/speech_recognizer.mojom.h"


namespace media::mojom {


class  SpeechRecognizerInterceptorForTesting : public SpeechRecognizer {
  virtual SpeechRecognizer* GetForwardingInterface() = 0;
  void Start(StartSpeechRecognitionRequestParamsPtr params) override;
};
class  SpeechRecognizerAsyncWaiter {
 public:
  explicit SpeechRecognizerAsyncWaiter(SpeechRecognizer* proxy);

  SpeechRecognizerAsyncWaiter(const SpeechRecognizerAsyncWaiter&) = delete;
  SpeechRecognizerAsyncWaiter& operator=(const SpeechRecognizerAsyncWaiter&) = delete;

  ~SpeechRecognizerAsyncWaiter();

 private:
  SpeechRecognizer* const proxy_;
};


class  OnDeviceSpeechRecognitionInterceptorForTesting : public OnDeviceSpeechRecognition {
  virtual OnDeviceSpeechRecognition* GetForwardingInterface() = 0;
  void Available(const std::vector<std::string>& languages, AvailableCallback callback) override;
  void Install(const std::vector<std::string>& languages, InstallCallback callback) override;
};
class  OnDeviceSpeechRecognitionAsyncWaiter {
 public:
  explicit OnDeviceSpeechRecognitionAsyncWaiter(OnDeviceSpeechRecognition* proxy);

  OnDeviceSpeechRecognitionAsyncWaiter(const OnDeviceSpeechRecognitionAsyncWaiter&) = delete;
  OnDeviceSpeechRecognitionAsyncWaiter& operator=(const OnDeviceSpeechRecognitionAsyncWaiter&) = delete;

  ~OnDeviceSpeechRecognitionAsyncWaiter();
  void Available(
      const std::vector<std::string>& languages, AvailabilityStatus* out_status);
  AvailabilityStatus Available(const std::vector<std::string>& languages);
  void Install(
      const std::vector<std::string>& languages, bool* out_success);
  bool Install(const std::vector<std::string>& languages);

 private:
  OnDeviceSpeechRecognition* const proxy_;
};


class  SpeechRecognitionSessionInterceptorForTesting : public SpeechRecognitionSession {
  virtual SpeechRecognitionSession* GetForwardingInterface() = 0;
  void Abort() override;
  void StopCapture() override;
  void UpdateRecognitionContext(const ::media::SpeechRecognitionRecognitionContext& recognition_context) override;
};
class  SpeechRecognitionSessionAsyncWaiter {
 public:
  explicit SpeechRecognitionSessionAsyncWaiter(SpeechRecognitionSession* proxy);

  SpeechRecognitionSessionAsyncWaiter(const SpeechRecognitionSessionAsyncWaiter&) = delete;
  SpeechRecognitionSessionAsyncWaiter& operator=(const SpeechRecognitionSessionAsyncWaiter&) = delete;

  ~SpeechRecognitionSessionAsyncWaiter();

 private:
  SpeechRecognitionSession* const proxy_;
};


class  SpeechRecognitionSessionClientInterceptorForTesting : public SpeechRecognitionSessionClient {
  virtual SpeechRecognitionSessionClient* GetForwardingInterface() = 0;
  void ResultRetrieved(std::vector<::media::mojom::WebSpeechRecognitionResultPtr> results) override;
  void ErrorOccurred(::media::mojom::SpeechRecognitionErrorPtr error) override;
  void Started() override;
  void AudioStarted() override;
  void SoundStarted() override;
  void SoundEnded() override;
  void AudioEnded() override;
  void Ended() override;
};
class  SpeechRecognitionSessionClientAsyncWaiter {
 public:
  explicit SpeechRecognitionSessionClientAsyncWaiter(SpeechRecognitionSessionClient* proxy);

  SpeechRecognitionSessionClientAsyncWaiter(const SpeechRecognitionSessionClientAsyncWaiter&) = delete;
  SpeechRecognitionSessionClientAsyncWaiter& operator=(const SpeechRecognitionSessionClientAsyncWaiter&) = delete;

  ~SpeechRecognitionSessionClientAsyncWaiter();

 private:
  SpeechRecognitionSessionClient* const proxy_;
};




}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_TEST_UTILS_H_