// media/mojo/mojom/speech_recognizer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/mojo/mojom/speech_recognizer.mojom-shared-internal.h"
#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_error.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_grammar.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_result.mojom-shared.h"
#include "media/mojo/mojom/speech_recognition_recognition_context.mojom-shared.h"


namespace media::mojom {
class StartSpeechRecognitionRequestParamsDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::StartSpeechRecognitionRequestParamsDataView> {
  using Data = ::media::mojom::internal::StartSpeechRecognitionRequestParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class AvailabilityStatus : int32_t {
  
  kUnavailable = 0,
  
  kDownloadable = 1,
  
  kDownloading = 2,
  
  kAvailable = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, AvailabilityStatus value);
inline bool IsKnownEnumValue(AvailabilityStatus value) {
  return internal::AvailabilityStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SpeechRecognizerInterfaceBase {};

using SpeechRecognizerPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognizerInterfaceBase>;
using SpeechRecognizerRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognizerInterfaceBase>;
using SpeechRecognizerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognizerInterfaceBase>;
using SpeechRecognizerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognizerInterfaceBase>;
class OnDeviceSpeechRecognitionInterfaceBase {};

using OnDeviceSpeechRecognitionPtrDataView =
    mojo::InterfacePtrDataView<OnDeviceSpeechRecognitionInterfaceBase>;
using OnDeviceSpeechRecognitionRequestDataView =
    mojo::InterfaceRequestDataView<OnDeviceSpeechRecognitionInterfaceBase>;
using OnDeviceSpeechRecognitionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<OnDeviceSpeechRecognitionInterfaceBase>;
using OnDeviceSpeechRecognitionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<OnDeviceSpeechRecognitionInterfaceBase>;
class SpeechRecognitionSessionInterfaceBase {};

using SpeechRecognitionSessionPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionSessionInterfaceBase>;
using SpeechRecognitionSessionRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionSessionInterfaceBase>;
using SpeechRecognitionSessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionSessionInterfaceBase>;
using SpeechRecognitionSessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionSessionInterfaceBase>;
class SpeechRecognitionSessionClientInterfaceBase {};

using SpeechRecognitionSessionClientPtrDataView =
    mojo::InterfacePtrDataView<SpeechRecognitionSessionClientInterfaceBase>;
using SpeechRecognitionSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<SpeechRecognitionSessionClientInterfaceBase>;
using SpeechRecognitionSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpeechRecognitionSessionClientInterfaceBase>;
using SpeechRecognitionSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpeechRecognitionSessionClientInterfaceBase>;


class StartSpeechRecognitionRequestParamsDataView {
 public:
  StartSpeechRecognitionRequestParamsDataView() = default;

  StartSpeechRecognitionRequestParamsDataView(
      internal::StartSpeechRecognitionRequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSessionReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionSessionInterfaceBase>>(
            &data_->session_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionSessionClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGrammarsDataView(
      mojo::ArrayDataView<::media::mojom::SpeechRecognitionGrammarDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGrammars(UserType* output) {
    
    auto* pointer = data_->grammars.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::SpeechRecognitionGrammarDataView>>(
        pointer, output, message_);
  }
  inline void GetRecognitionContextDataView(
      ::media::mojom::SpeechRecognitionRecognitionContextDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecognitionContext(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::SpeechRecognitionRecognitionContextDataView, UserType>(),
    "Attempting to read the optional `recognition_context` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecognitionContext` instead "
    "of `ReadRecognitionContext if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recognition_context.Get();
    return mojo::internal::Deserialize<::media::mojom::SpeechRecognitionRecognitionContextDataView>(
        pointer, output, message_);
  }
  uint32_t max_hypotheses() const {
    return data_->max_hypotheses;
  }
  bool continuous() const {
    return data_->continuous;
  }
  bool interim_results() const {
    return data_->interim_results;
  }
  bool on_device() const {
    return data_->on_device;
  }
  bool allow_cloud_fallback() const {
    return data_->allow_cloud_fallback;
  }
  template <typename UserType>
  UserType TakeAudioForwarder() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionAudioForwarderInterfaceBase>>(
            &data_->audio_forwarder, &result, message_);
    DCHECK(ret);
    return result;
  }
  int32_t channel_count() const {
    return data_->channel_count;
  }
  int32_t sample_rate() const {
    return data_->sample_rate;
  }
 private:
  internal::StartSpeechRecognitionRequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_DATA_VIEW_H_