// media/mojo/mojom/speech_recognition_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/speech_recognition_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var audio_data$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_data.mojom', 'audio_data.mojom.js');
  }
  var audio_parameters$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_parameters.mojom', 'audio_parameters.mojom.js');
  }
  var audio_stream_factory$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_stream_factory.mojom', 'audio_stream_factory.mojom.js');
  }
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }
  var speech_recognition$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/speech_recognition.mojom', 'speech_recognition.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var context$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/context.mojom', '../../../sandbox/policy/mojom/context.mojom.js');
  }
  var sandbox$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/sandbox.mojom', '../../../sandbox/policy/mojom/sandbox.mojom.js');
  }



  function AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.prototype.initDefaults_ = function() {
    this.fetcherReceiver = new bindings.InterfaceRequest();
    this.client = new speech_recognition$.SpeechRecognitionRecognizerClientPtr();
    this.options = null;
  };
  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.fetcherReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, speech_recognition$.SpeechRecognitionOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.encodedSize = codec.kStructHeaderSize + 24;

  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.decode = function(decoder) {
    var packed;
    var val = new AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fetcherReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.client =
        decoder.decodeStruct(new codec.Interface(speech_recognition$.SpeechRecognitionRecognizerClientPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.options =
        decoder.decodeStructPointer(speech_recognition$.SpeechRecognitionOptions);
    return val;
  };

  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.fetcherReceiver);
    encoder.encodeStruct(new codec.Interface(speech_recognition$.SpeechRecognitionRecognizerClientPtr), val.client);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(speech_recognition$.SpeechRecognitionOptions, val.options);
  };
  function AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams.prototype.initDefaults_ = function() {
    this.isMultichannelSupported = false;
  };
  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isMultichannelSupported = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isMultichannelSupported & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionService_BindSpeechRecognitionContext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionService_BindSpeechRecognitionContext_Params.prototype.initDefaults_ = function() {
    this.context = new bindings.InterfaceRequest();
  };
  SpeechRecognitionService_BindSpeechRecognitionContext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionService_BindSpeechRecognitionContext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionService_BindSpeechRecognitionContext_Params.context
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionService_BindSpeechRecognitionContext_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionService_BindSpeechRecognitionContext_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionService_BindSpeechRecognitionContext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.context =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionService_BindSpeechRecognitionContext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionService_BindSpeechRecognitionContext_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.context);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params.prototype.initDefaults_ = function() {
    this.context = new bindings.InterfaceRequest();
  };
  SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params.context
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.context =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.context);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionService_SetSodaPaths_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionService_SetSodaPaths_Params.prototype.initDefaults_ = function() {
    this.binaryPath = null;
    this.configPaths = null;
    this.primaryLanguageName = null;
  };
  SpeechRecognitionService_SetSodaPaths_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionService_SetSodaPaths_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionService_SetSodaPaths_Params.binaryPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionService_SetSodaPaths_Params.configPaths
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, codec.String, new codec.PointerTo(file_path$.FilePath), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionService_SetSodaPaths_Params.primaryLanguageName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionService_SetSodaPaths_Params.encodedSize = codec.kStructHeaderSize + 24;

  SpeechRecognitionService_SetSodaPaths_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionService_SetSodaPaths_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.binaryPath =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.configPaths =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(file_path$.FilePath));
    val.primaryLanguageName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SpeechRecognitionService_SetSodaPaths_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionService_SetSodaPaths_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.binaryPath);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(file_path$.FilePath), val.configPaths);
    encoder.encodeStruct(codec.String, val.primaryLanguageName);
  };
  function SpeechRecognitionService_SetSodaParams_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionService_SetSodaParams_Params.prototype.initDefaults_ = function() {
    this.maskOffensiveWords = false;
  };
  SpeechRecognitionService_SetSodaParams_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionService_SetSodaParams_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SpeechRecognitionService_SetSodaParams_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionService_SetSodaParams_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionService_SetSodaParams_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.maskOffensiveWords = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionService_SetSodaParams_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionService_SetSodaParams_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.maskOffensiveWords & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionService_SetSodaConfigPaths_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionService_SetSodaConfigPaths_Params.prototype.initDefaults_ = function() {
    this.configPaths = null;
  };
  SpeechRecognitionService_SetSodaConfigPaths_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionService_SetSodaConfigPaths_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionService_SetSodaConfigPaths_Params.configPaths
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.PointerTo(file_path$.FilePath), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionService_SetSodaConfigPaths_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionService_SetSodaConfigPaths_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionService_SetSodaConfigPaths_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.configPaths =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(file_path$.FilePath));
    return val;
  };

  SpeechRecognitionService_SetSodaConfigPaths_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionService_SetSodaConfigPaths_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(file_path$.FilePath), val.configPaths);
  };
  function AudioSourceFetcher_Start_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioSourceFetcher_Start_Params.prototype.initDefaults_ = function() {
    this.factory = new audio_stream_factory$.AudioStreamFactoryPtr();
    this.deviceId = null;
    this.audioParameters = null;
  };
  AudioSourceFetcher_Start_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioSourceFetcher_Start_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioSourceFetcher_Start_Params.factory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioSourceFetcher_Start_Params.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioSourceFetcher_Start_Params.audioParameters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, audio_parameters$.AudioParameters, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioSourceFetcher_Start_Params.encodedSize = codec.kStructHeaderSize + 24;

  AudioSourceFetcher_Start_Params.decode = function(decoder) {
    var packed;
    var val = new AudioSourceFetcher_Start_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.factory =
        decoder.decodeStruct(new codec.Interface(audio_stream_factory$.AudioStreamFactoryPtr));
    val.deviceId =
        decoder.decodeStruct(codec.String);
    val.audioParameters =
        decoder.decodeStructPointer(audio_parameters$.AudioParameters);
    return val;
  };

  AudioSourceFetcher_Start_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioSourceFetcher_Start_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(audio_stream_factory$.AudioStreamFactoryPtr), val.factory);
    encoder.encodeStruct(codec.String, val.deviceId);
    encoder.encodeStructPointer(audio_parameters$.AudioParameters, val.audioParameters);
  };
  function AudioSourceFetcher_Stop_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioSourceFetcher_Stop_Params.prototype.initDefaults_ = function() {
  };
  AudioSourceFetcher_Stop_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioSourceFetcher_Stop_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioSourceFetcher_Stop_Params.encodedSize = codec.kStructHeaderSize + 0;

  AudioSourceFetcher_Stop_Params.decode = function(decoder) {
    var packed;
    var val = new AudioSourceFetcher_Stop_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AudioSourceFetcher_Stop_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioSourceFetcher_Stop_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kAudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Name = 0;

  function AudioSourceSpeechRecognitionContextPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AudioSourceSpeechRecognitionContext,
                                                   handleOrPtrInfo);
  }

  function AudioSourceSpeechRecognitionContextAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AudioSourceSpeechRecognitionContext, associatedInterfacePtrInfo);
  }

  AudioSourceSpeechRecognitionContextAssociatedPtr.prototype =
      Object.create(AudioSourceSpeechRecognitionContextPtr.prototype);
  AudioSourceSpeechRecognitionContextAssociatedPtr.prototype.constructor =
      AudioSourceSpeechRecognitionContextAssociatedPtr;

  function AudioSourceSpeechRecognitionContextProxy(receiver) {
    this.receiver_ = receiver;
  }
  AudioSourceSpeechRecognitionContextPtr.prototype.bindAudioSourceFetcher = function() {
    return AudioSourceSpeechRecognitionContextProxy.prototype.bindAudioSourceFetcher
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioSourceSpeechRecognitionContextProxy.prototype.bindAudioSourceFetcher = function(fetcherReceiver, client, options) {
    var params_ = new AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params();
    params_.fetcherReceiver = fetcherReceiver;
    params_.client = client;
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Name,
          codec.align(AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AudioSourceSpeechRecognitionContextStub(delegate) {
    this.delegate_ = delegate;
  }
  AudioSourceSpeechRecognitionContextStub.prototype.bindAudioSourceFetcher = function(fetcherReceiver, client, options) {
    return this.delegate_ && this.delegate_.bindAudioSourceFetcher && this.delegate_.bindAudioSourceFetcher(fetcherReceiver, client, options);
  }

  AudioSourceSpeechRecognitionContextStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  AudioSourceSpeechRecognitionContextStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Name:
      var params = reader.decodeStruct(AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params);
      this.bindAudioSourceFetcher(params.fetcherReceiver, params.client, params.options).then(function(response) {
        var responseParams =
            new AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams();
        responseParams.isMultichannelSupported = response.isMultichannelSupported;
        var builder = new codec.MessageV1Builder(
            kAudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Name,
            codec.align(AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAudioSourceSpeechRecognitionContextRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Name:
        if (message.expectsResponse())
          paramsClass = AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAudioSourceSpeechRecognitionContextResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Name:
        if (message.isResponse())
          paramsClass = AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AudioSourceSpeechRecognitionContext = {
    name: 'media.mojom.AudioSourceSpeechRecognitionContext',
    kVersion: 0,
    ptrClass: AudioSourceSpeechRecognitionContextPtr,
    proxyClass: AudioSourceSpeechRecognitionContextProxy,
    stubClass: AudioSourceSpeechRecognitionContextStub,
    validateRequest: validateAudioSourceSpeechRecognitionContextRequest,
    validateResponse: validateAudioSourceSpeechRecognitionContextResponse,
  };
  AudioSourceSpeechRecognitionContextStub.prototype.validator = validateAudioSourceSpeechRecognitionContextRequest;
  AudioSourceSpeechRecognitionContextProxy.prototype.validator = validateAudioSourceSpeechRecognitionContextResponse;
  var kSpeechRecognitionService_BindSpeechRecognitionContext_Name = 0;
  var kSpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Name = 1;
  var kSpeechRecognitionService_SetSodaPaths_Name = 2;
  var kSpeechRecognitionService_SetSodaParams_Name = 3;
  var kSpeechRecognitionService_SetSodaConfigPaths_Name = 4;

  function SpeechRecognitionServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionService,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionService, associatedInterfacePtrInfo);
  }

  SpeechRecognitionServiceAssociatedPtr.prototype =
      Object.create(SpeechRecognitionServicePtr.prototype);
  SpeechRecognitionServiceAssociatedPtr.prototype.constructor =
      SpeechRecognitionServiceAssociatedPtr;

  function SpeechRecognitionServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionServicePtr.prototype.bindSpeechRecognitionContext = function() {
    return SpeechRecognitionServiceProxy.prototype.bindSpeechRecognitionContext
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionServiceProxy.prototype.bindSpeechRecognitionContext = function(context) {
    var params_ = new SpeechRecognitionService_BindSpeechRecognitionContext_Params();
    params_.context = context;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionService_BindSpeechRecognitionContext_Name,
        codec.align(SpeechRecognitionService_BindSpeechRecognitionContext_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionService_BindSpeechRecognitionContext_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionServicePtr.prototype.bindAudioSourceSpeechRecognitionContext = function() {
    return SpeechRecognitionServiceProxy.prototype.bindAudioSourceSpeechRecognitionContext
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionServiceProxy.prototype.bindAudioSourceSpeechRecognitionContext = function(context) {
    var params_ = new SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params();
    params_.context = context;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Name,
        codec.align(SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionServicePtr.prototype.setSodaPaths = function() {
    return SpeechRecognitionServiceProxy.prototype.setSodaPaths
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionServiceProxy.prototype.setSodaPaths = function(binaryPath, configPaths, primaryLanguageName) {
    var params_ = new SpeechRecognitionService_SetSodaPaths_Params();
    params_.binaryPath = binaryPath;
    params_.configPaths = configPaths;
    params_.primaryLanguageName = primaryLanguageName;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionService_SetSodaPaths_Name,
        codec.align(SpeechRecognitionService_SetSodaPaths_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionService_SetSodaPaths_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionServicePtr.prototype.setSodaParams = function() {
    return SpeechRecognitionServiceProxy.prototype.setSodaParams
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionServiceProxy.prototype.setSodaParams = function(maskOffensiveWords) {
    var params_ = new SpeechRecognitionService_SetSodaParams_Params();
    params_.maskOffensiveWords = maskOffensiveWords;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionService_SetSodaParams_Name,
        codec.align(SpeechRecognitionService_SetSodaParams_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionService_SetSodaParams_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionServicePtr.prototype.setSodaConfigPaths = function() {
    return SpeechRecognitionServiceProxy.prototype.setSodaConfigPaths
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionServiceProxy.prototype.setSodaConfigPaths = function(configPaths) {
    var params_ = new SpeechRecognitionService_SetSodaConfigPaths_Params();
    params_.configPaths = configPaths;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionService_SetSodaConfigPaths_Name,
        codec.align(SpeechRecognitionService_SetSodaConfigPaths_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionService_SetSodaConfigPaths_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognitionServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionServiceStub.prototype.bindSpeechRecognitionContext = function(context) {
    return this.delegate_ && this.delegate_.bindSpeechRecognitionContext && this.delegate_.bindSpeechRecognitionContext(context);
  }
  SpeechRecognitionServiceStub.prototype.bindAudioSourceSpeechRecognitionContext = function(context) {
    return this.delegate_ && this.delegate_.bindAudioSourceSpeechRecognitionContext && this.delegate_.bindAudioSourceSpeechRecognitionContext(context);
  }
  SpeechRecognitionServiceStub.prototype.setSodaPaths = function(binaryPath, configPaths, primaryLanguageName) {
    return this.delegate_ && this.delegate_.setSodaPaths && this.delegate_.setSodaPaths(binaryPath, configPaths, primaryLanguageName);
  }
  SpeechRecognitionServiceStub.prototype.setSodaParams = function(maskOffensiveWords) {
    return this.delegate_ && this.delegate_.setSodaParams && this.delegate_.setSodaParams(maskOffensiveWords);
  }
  SpeechRecognitionServiceStub.prototype.setSodaConfigPaths = function(configPaths) {
    return this.delegate_ && this.delegate_.setSodaConfigPaths && this.delegate_.setSodaConfigPaths(configPaths);
  }

  SpeechRecognitionServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionService_BindSpeechRecognitionContext_Name:
      var params = reader.decodeStruct(SpeechRecognitionService_BindSpeechRecognitionContext_Params);
      this.bindSpeechRecognitionContext(params.context);
      return true;
    case kSpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Name:
      var params = reader.decodeStruct(SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params);
      this.bindAudioSourceSpeechRecognitionContext(params.context);
      return true;
    case kSpeechRecognitionService_SetSodaPaths_Name:
      var params = reader.decodeStruct(SpeechRecognitionService_SetSodaPaths_Params);
      this.setSodaPaths(params.binaryPath, params.configPaths, params.primaryLanguageName);
      return true;
    case kSpeechRecognitionService_SetSodaParams_Name:
      var params = reader.decodeStruct(SpeechRecognitionService_SetSodaParams_Params);
      this.setSodaParams(params.maskOffensiveWords);
      return true;
    case kSpeechRecognitionService_SetSodaConfigPaths_Name:
      var params = reader.decodeStruct(SpeechRecognitionService_SetSodaConfigPaths_Params);
      this.setSodaConfigPaths(params.configPaths);
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechRecognitionServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionService_BindSpeechRecognitionContext_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionService_BindSpeechRecognitionContext_Params;
      break;
      case kSpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params;
      break;
      case kSpeechRecognitionService_SetSodaPaths_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionService_SetSodaPaths_Params;
      break;
      case kSpeechRecognitionService_SetSodaParams_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionService_SetSodaParams_Params;
      break;
      case kSpeechRecognitionService_SetSodaConfigPaths_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionService_SetSodaConfigPaths_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionServiceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechRecognitionService = {
    name: 'media.mojom.SpeechRecognitionService',
    kVersion: 0,
    ptrClass: SpeechRecognitionServicePtr,
    proxyClass: SpeechRecognitionServiceProxy,
    stubClass: SpeechRecognitionServiceStub,
    validateRequest: validateSpeechRecognitionServiceRequest,
    validateResponse: null,
  };
  SpeechRecognitionServiceStub.prototype.validator = validateSpeechRecognitionServiceRequest;
  SpeechRecognitionServiceProxy.prototype.validator = null;
  var kAudioSourceFetcher_Start_Name = 0;
  var kAudioSourceFetcher_Stop_Name = 1;

  function AudioSourceFetcherPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AudioSourceFetcher,
                                                   handleOrPtrInfo);
  }

  function AudioSourceFetcherAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AudioSourceFetcher, associatedInterfacePtrInfo);
  }

  AudioSourceFetcherAssociatedPtr.prototype =
      Object.create(AudioSourceFetcherPtr.prototype);
  AudioSourceFetcherAssociatedPtr.prototype.constructor =
      AudioSourceFetcherAssociatedPtr;

  function AudioSourceFetcherProxy(receiver) {
    this.receiver_ = receiver;
  }
  AudioSourceFetcherPtr.prototype.start = function() {
    return AudioSourceFetcherProxy.prototype.start
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioSourceFetcherProxy.prototype.start = function(factory, deviceId, audioParameters) {
    var params_ = new AudioSourceFetcher_Start_Params();
    params_.factory = factory;
    params_.deviceId = deviceId;
    params_.audioParameters = audioParameters;
    var builder = new codec.MessageV0Builder(
        kAudioSourceFetcher_Start_Name,
        codec.align(AudioSourceFetcher_Start_Params.encodedSize));
    builder.encodeStruct(AudioSourceFetcher_Start_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioSourceFetcherPtr.prototype.stop = function() {
    return AudioSourceFetcherProxy.prototype.stop
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioSourceFetcherProxy.prototype.stop = function() {
    var params_ = new AudioSourceFetcher_Stop_Params();
    var builder = new codec.MessageV0Builder(
        kAudioSourceFetcher_Stop_Name,
        codec.align(AudioSourceFetcher_Stop_Params.encodedSize));
    builder.encodeStruct(AudioSourceFetcher_Stop_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AudioSourceFetcherStub(delegate) {
    this.delegate_ = delegate;
  }
  AudioSourceFetcherStub.prototype.start = function(factory, deviceId, audioParameters) {
    return this.delegate_ && this.delegate_.start && this.delegate_.start(factory, deviceId, audioParameters);
  }
  AudioSourceFetcherStub.prototype.stop = function() {
    return this.delegate_ && this.delegate_.stop && this.delegate_.stop();
  }

  AudioSourceFetcherStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioSourceFetcher_Start_Name:
      var params = reader.decodeStruct(AudioSourceFetcher_Start_Params);
      this.start(params.factory, params.deviceId, params.audioParameters);
      return true;
    case kAudioSourceFetcher_Stop_Name:
      var params = reader.decodeStruct(AudioSourceFetcher_Stop_Params);
      this.stop();
      return true;
    default:
      return false;
    }
  };

  AudioSourceFetcherStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAudioSourceFetcherRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAudioSourceFetcher_Start_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioSourceFetcher_Start_Params;
      break;
      case kAudioSourceFetcher_Stop_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioSourceFetcher_Stop_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAudioSourceFetcherResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AudioSourceFetcher = {
    name: 'media.mojom.AudioSourceFetcher',
    kVersion: 0,
    ptrClass: AudioSourceFetcherPtr,
    proxyClass: AudioSourceFetcherProxy,
    stubClass: AudioSourceFetcherStub,
    validateRequest: validateAudioSourceFetcherRequest,
    validateResponse: null,
  };
  AudioSourceFetcherStub.prototype.validator = validateAudioSourceFetcherRequest;
  AudioSourceFetcherProxy.prototype.validator = null;
  exports.AudioSourceSpeechRecognitionContext = AudioSourceSpeechRecognitionContext;
  exports.AudioSourceSpeechRecognitionContextPtr = AudioSourceSpeechRecognitionContextPtr;
  exports.AudioSourceSpeechRecognitionContextAssociatedPtr = AudioSourceSpeechRecognitionContextAssociatedPtr;
  exports.SpeechRecognitionService = SpeechRecognitionService;
  exports.SpeechRecognitionServicePtr = SpeechRecognitionServicePtr;
  exports.SpeechRecognitionServiceAssociatedPtr = SpeechRecognitionServiceAssociatedPtr;
  exports.AudioSourceFetcher = AudioSourceFetcher;
  exports.AudioSourceFetcherPtr = AudioSourceFetcherPtr;
  exports.AudioSourceFetcherAssociatedPtr = AudioSourceFetcherAssociatedPtr;
})();