// media/mojo/mojom/speech_recognition_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/speech_recognition_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/speech_recognition_service.mojom-params-data.h"
#include "media/mojo/mojom/speech_recognition_service.mojom-shared-message-ids.h"

#include "media/mojo/mojom/speech_recognition_service.mojom-blink-import-headers.h"
#include "media/mojo/mojom/speech_recognition_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
// The declaration includes the definition on other builds.

AudioSourceSpeechRecognitionContext::IPCStableHashFunction AudioSourceSpeechRecognitionContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioSourceSpeechRecognitionContext>(message.name())) {
    case messages::AudioSourceSpeechRecognitionContext::kBindAudioSourceFetcher: {
      return &AudioSourceSpeechRecognitionContext::BindAudioSourceFetcher_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioSourceSpeechRecognitionContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioSourceSpeechRecognitionContext>(message.name())) {
      case messages::AudioSourceSpeechRecognitionContext::kBindAudioSourceFetcher:
            return "Receive media::mojom::AudioSourceSpeechRecognitionContext::BindAudioSourceFetcher";
    }
  } else {
    switch (static_cast<messages::AudioSourceSpeechRecognitionContext>(message.name())) {
      case messages::AudioSourceSpeechRecognitionContext::kBindAudioSourceFetcher:
            return "Receive reply media::mojom::AudioSourceSpeechRecognitionContext::BindAudioSourceFetcher";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioSourceSpeechRecognitionContext::BindAudioSourceFetcher_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4841075e;  // IPCStableHash for media::mojom::AudioSourceSpeechRecognitionContext::BindAudioSourceFetcher
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback(
      AudioSourceSpeechRecognitionContext::BindAudioSourceFetcherCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback(const AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback&) = delete;
  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback& operator=(const AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioSourceSpeechRecognitionContext::BindAudioSourceFetcherCallback callback_;
};

AudioSourceSpeechRecognitionContextProxy::AudioSourceSpeechRecognitionContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioSourceSpeechRecognitionContextProxy::BindAudioSourceFetcher(
    ::mojo::PendingReceiver<AudioSourceFetcher> in_fetcher_receiver, ::mojo::PendingRemote<::media::mojom::blink::SpeechRecognitionRecognizerClient> in_client, ::media::mojom::blink::SpeechRecognitionOptionsPtr in_options, BindAudioSourceFetcherCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioSourceSpeechRecognitionContext::BindAudioSourceFetcher", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fetcher_receiver"), in_fetcher_receiver,
                        "<value of type ::mojo::PendingReceiver<AudioSourceFetcher>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::media::mojom::blink::SpeechRecognitionRecognizerClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::media::mojom::blink::SpeechRecognitionOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioSourceSpeechRecognitionContext::kBindAudioSourceFetcher), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioSourceFetcherInterfaceBase>>(
    in_fetcher_receiver,
    &params->fetcher_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->fetcher_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid fetcher_receiver in AudioSourceSpeechRecognitionContext.BindAudioSourceFetcher request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionRecognizerClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AudioSourceSpeechRecognitionContext.BindAudioSourceFetcher request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in AudioSourceSpeechRecognitionContext.BindAudioSourceFetcher request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioSourceSpeechRecognitionContext::Name_);
  message.set_method_name("BindAudioSourceFetcher");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioSourceSpeechRecognitionContext::BindAudioSourceFetcherCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder> proxy(
        new AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AudioSourceSpeechRecognitionContext::BindAudioSourceFetcherCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_multichannel_supported);
};

bool AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioSourceSpeechRecognitionContext.0
  bool success = true;
  bool p_is_multichannel_supported{};
  AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_multichannel_supported = input_data_view.is_multichannel_supported();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioSourceSpeechRecognitionContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_multichannel_supported));
  }
  return true;
}

void AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder::Run(
    bool in_is_multichannel_supported) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioSourceSpeechRecognitionContext::BindAudioSourceFetcher", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_multichannel_supported"), in_is_multichannel_supported,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioSourceSpeechRecognitionContext::kBindAudioSourceFetcher), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_multichannel_supported = in_is_multichannel_supported;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioSourceSpeechRecognitionContext::Name_);
  message.set_method_name("BindAudioSourceFetcher");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioSourceSpeechRecognitionContextStubDispatch::Accept(
    AudioSourceSpeechRecognitionContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioSourceSpeechRecognitionContext>(message->header()->name)) {
    case messages::AudioSourceSpeechRecognitionContext::kBindAudioSourceFetcher: {
      break;
    }
  }
  return false;
}

// static
bool AudioSourceSpeechRecognitionContextStubDispatch::AcceptWithResponder(
    AudioSourceSpeechRecognitionContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioSourceSpeechRecognitionContext>(message->header()->name)) {
    case messages::AudioSourceSpeechRecognitionContext::kBindAudioSourceFetcher: {
      internal::AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params_Data* params =
          reinterpret_cast<
              internal::AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioSourceSpeechRecognitionContext.0
      bool success = true;
      ::mojo::PendingReceiver<AudioSourceFetcher> p_fetcher_receiver{};
      ::mojo::PendingRemote<::media::mojom::blink::SpeechRecognitionRecognizerClient> p_client{};
      ::media::mojom::blink::SpeechRecognitionOptionsPtr p_options{};
      AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_fetcher_receiver =
            input_data_view.TakeFetcherReceiver<decltype(p_fetcher_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioSourceSpeechRecognitionContext::Name_, 0, false);
        return false;
      }
      auto callback =
          AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAudioSourceFetcher(        
        std::move(p_fetcher_receiver), 
        std::move(p_client), 
        std::move(p_options), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioSourceSpeechRecognitionContextValidationInfo[] = {
    { &internal::AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params_Data::Validate,
     &internal::AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams_Data::Validate},
};

bool AudioSourceSpeechRecognitionContextRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::AudioSourceSpeechRecognitionContext::Name_,
    kAudioSourceSpeechRecognitionContextValidationInfo);
}

bool AudioSourceSpeechRecognitionContextResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::blink::AudioSourceSpeechRecognitionContext::Name_,
    kAudioSourceSpeechRecognitionContextValidationInfo);
}
// The declaration includes the definition on other builds.

SpeechRecognitionService::IPCStableHashFunction SpeechRecognitionService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SpeechRecognitionService>(message.name())) {
    case messages::SpeechRecognitionService::kBindSpeechRecognitionContext: {
      return &SpeechRecognitionService::BindSpeechRecognitionContext_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionService::kBindAudioSourceSpeechRecognitionContext: {
      return &SpeechRecognitionService::BindAudioSourceSpeechRecognitionContext_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionService::kSetSodaPaths: {
      return &SpeechRecognitionService::SetSodaPaths_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionService::kSetSodaParams: {
      return &SpeechRecognitionService::SetSodaParams_Sym::IPCStableHash;
    }
    case messages::SpeechRecognitionService::kSetSodaConfigPaths: {
      return &SpeechRecognitionService::SetSodaConfigPaths_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SpeechRecognitionService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SpeechRecognitionService>(message.name())) {
      case messages::SpeechRecognitionService::kBindSpeechRecognitionContext:
            return "Receive media::mojom::SpeechRecognitionService::BindSpeechRecognitionContext";
      case messages::SpeechRecognitionService::kBindAudioSourceSpeechRecognitionContext:
            return "Receive media::mojom::SpeechRecognitionService::BindAudioSourceSpeechRecognitionContext";
      case messages::SpeechRecognitionService::kSetSodaPaths:
            return "Receive media::mojom::SpeechRecognitionService::SetSodaPaths";
      case messages::SpeechRecognitionService::kSetSodaParams:
            return "Receive media::mojom::SpeechRecognitionService::SetSodaParams";
      case messages::SpeechRecognitionService::kSetSodaConfigPaths:
            return "Receive media::mojom::SpeechRecognitionService::SetSodaConfigPaths";
    }
  } else {
    switch (static_cast<messages::SpeechRecognitionService>(message.name())) {
      case messages::SpeechRecognitionService::kBindSpeechRecognitionContext:
            return "Receive reply media::mojom::SpeechRecognitionService::BindSpeechRecognitionContext";
      case messages::SpeechRecognitionService::kBindAudioSourceSpeechRecognitionContext:
            return "Receive reply media::mojom::SpeechRecognitionService::BindAudioSourceSpeechRecognitionContext";
      case messages::SpeechRecognitionService::kSetSodaPaths:
            return "Receive reply media::mojom::SpeechRecognitionService::SetSodaPaths";
      case messages::SpeechRecognitionService::kSetSodaParams:
            return "Receive reply media::mojom::SpeechRecognitionService::SetSodaParams";
      case messages::SpeechRecognitionService::kSetSodaConfigPaths:
            return "Receive reply media::mojom::SpeechRecognitionService::SetSodaConfigPaths";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SpeechRecognitionService::BindSpeechRecognitionContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab9827ba;  // IPCStableHash for media::mojom::SpeechRecognitionService::BindSpeechRecognitionContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionService::BindAudioSourceSpeechRecognitionContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd25efad4;  // IPCStableHash for media::mojom::SpeechRecognitionService::BindAudioSourceSpeechRecognitionContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionService::SetSodaPaths_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x77ada527;  // IPCStableHash for media::mojom::SpeechRecognitionService::SetSodaPaths
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionService::SetSodaParams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3bab91f;  // IPCStableHash for media::mojom::SpeechRecognitionService::SetSodaParams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SpeechRecognitionService::SetSodaConfigPaths_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1d56189;  // IPCStableHash for media::mojom::SpeechRecognitionService::SetSodaConfigPaths
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SpeechRecognitionServiceProxy::SpeechRecognitionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionServiceProxy::BindSpeechRecognitionContext(
    ::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionContext> in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionService::BindSpeechRecognitionContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionContext>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionService::kBindSpeechRecognitionContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionService_BindSpeechRecognitionContext_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionContextInterfaceBase>>(
    in_context,
    &params->context,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->context)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid context in SpeechRecognitionService.BindSpeechRecognitionContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("BindSpeechRecognitionContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionServiceProxy::BindAudioSourceSpeechRecognitionContext(
    ::mojo::PendingReceiver<AudioSourceSpeechRecognitionContext> in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionService::BindAudioSourceSpeechRecognitionContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::mojo::PendingReceiver<AudioSourceSpeechRecognitionContext>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionService::kBindAudioSourceSpeechRecognitionContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioSourceSpeechRecognitionContextInterfaceBase>>(
    in_context,
    &params->context,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->context)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid context in SpeechRecognitionService.BindAudioSourceSpeechRecognitionContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("BindAudioSourceSpeechRecognitionContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionServiceProxy::SetSodaPaths(
    const ::base::FilePath& in_binary_path, const ::blink::HashMap<::blink::String, ::base::FilePath>& in_config_paths, const ::blink::String& in_primary_language_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionService::SetSodaPaths", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("binary_path"), in_binary_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_paths"), in_config_paths,
                        "<value of type const ::blink::HashMap<::blink::String, ::base::FilePath>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("primary_language_name"), in_primary_language_name,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionService::kSetSodaPaths), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionService_SetSodaPaths_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->binary_path)::BaseType> binary_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_binary_path,
    binary_path_fragment);

  params->binary_path.Set(
      binary_path_fragment.is_null() ? nullptr : binary_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->binary_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null binary_path in SpeechRecognitionService.SetSodaPaths request");
  mojo::internal::MessageFragment<
      typename decltype(params->config_paths)::BaseType>
      config_paths_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& config_paths_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::FilePathDataView>>(
    in_config_paths,
    config_paths_fragment,
    &config_paths_validate_params);

  params->config_paths.Set(
      config_paths_fragment.is_null() ? nullptr : config_paths_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config_paths.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config_paths in SpeechRecognitionService.SetSodaPaths request");
  mojo::internal::MessageFragment<
      typename decltype(params->primary_language_name)::BaseType> primary_language_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_primary_language_name,
    primary_language_name_fragment);

  params->primary_language_name.Set(
      primary_language_name_fragment.is_null() ? nullptr : primary_language_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->primary_language_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null primary_language_name in SpeechRecognitionService.SetSodaPaths request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("SetSodaPaths");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionServiceProxy::SetSodaParams(
    bool in_mask_offensive_words) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionService::SetSodaParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mask_offensive_words"), in_mask_offensive_words,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionService::kSetSodaParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionService_SetSodaParams_Params_Data> params(
          message);
  params.Allocate();

  params->mask_offensive_words = in_mask_offensive_words;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("SetSodaParams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SpeechRecognitionServiceProxy::SetSodaConfigPaths(
    const ::blink::HashMap<::blink::String, ::base::FilePath>& in_config_paths) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::SpeechRecognitionService::SetSodaConfigPaths", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_paths"), in_config_paths,
                        "<value of type const ::blink::HashMap<::blink::String, ::base::FilePath>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SpeechRecognitionService::kSetSodaConfigPaths), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::SpeechRecognitionService_SetSodaConfigPaths_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config_paths)::BaseType>
      config_paths_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& config_paths_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::FilePathDataView>>(
    in_config_paths,
    config_paths_fragment,
    &config_paths_validate_params);

  params->config_paths.Set(
      config_paths_fragment.is_null() ? nullptr : config_paths_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config_paths.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config_paths in SpeechRecognitionService.SetSodaConfigPaths request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("SetSodaConfigPaths");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SpeechRecognitionServiceStubDispatch::Accept(
    SpeechRecognitionService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SpeechRecognitionService>(message->header()->name)) {
    case messages::SpeechRecognitionService::kBindSpeechRecognitionContext: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_BindSpeechRecognitionContext_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_BindSpeechRecognitionContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionService.0
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionContext> p_context{};
      SpeechRecognitionService_BindSpeechRecognitionContext_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_context =
            input_data_view.TakeContext<decltype(p_context)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSpeechRecognitionContext(        
        std::move(p_context));
      return true;
    }
    case messages::SpeechRecognitionService::kBindAudioSourceSpeechRecognitionContext: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionService.1
      bool success = true;
      ::mojo::PendingReceiver<AudioSourceSpeechRecognitionContext> p_context{};
      SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_context =
            input_data_view.TakeContext<decltype(p_context)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAudioSourceSpeechRecognitionContext(        
        std::move(p_context));
      return true;
    }
    case messages::SpeechRecognitionService::kSetSodaPaths: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_SetSodaPaths_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_SetSodaPaths_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionService.2
      bool success = true;
      ::base::FilePath p_binary_path{};
      ::blink::HashMap<::blink::String, ::base::FilePath> p_config_paths{};
      ::blink::String p_primary_language_name{};
      SpeechRecognitionService_SetSodaPaths_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBinaryPath(&p_binary_path))
        success = false;
      if (success && !input_data_view.ReadConfigPaths(&p_config_paths))
        success = false;
      if (success && !input_data_view.ReadPrimaryLanguageName(&p_primary_language_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSodaPaths(        
        std::move(p_binary_path), 
        std::move(p_config_paths), 
        std::move(p_primary_language_name));
      return true;
    }
    case messages::SpeechRecognitionService::kSetSodaParams: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_SetSodaParams_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_SetSodaParams_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionService.3
      bool success = true;
      bool p_mask_offensive_words{};
      SpeechRecognitionService_SetSodaParams_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_mask_offensive_words = input_data_view.mask_offensive_words();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSodaParams(        
        std::move(p_mask_offensive_words));
      return true;
    }
    case messages::SpeechRecognitionService::kSetSodaConfigPaths: {
      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_SetSodaConfigPaths_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_SetSodaConfigPaths_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SpeechRecognitionService.4
      bool success = true;
      ::blink::HashMap<::blink::String, ::base::FilePath> p_config_paths{};
      SpeechRecognitionService_SetSodaConfigPaths_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfigPaths(&p_config_paths))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSodaConfigPaths(        
        std::move(p_config_paths));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionServiceStubDispatch::AcceptWithResponder(
    SpeechRecognitionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SpeechRecognitionService>(message->header()->name)) {
    case messages::SpeechRecognitionService::kBindSpeechRecognitionContext: {
      break;
    }
    case messages::SpeechRecognitionService::kBindAudioSourceSpeechRecognitionContext: {
      break;
    }
    case messages::SpeechRecognitionService::kSetSodaPaths: {
      break;
    }
    case messages::SpeechRecognitionService::kSetSodaParams: {
      break;
    }
    case messages::SpeechRecognitionService::kSetSodaConfigPaths: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSpeechRecognitionServiceValidationInfo[] = {
    { &internal::SpeechRecognitionService_BindSpeechRecognitionContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionService_SetSodaPaths_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionService_SetSodaParams_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SpeechRecognitionService_SetSodaConfigPaths_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::SpeechRecognitionService::Name_,
    kSpeechRecognitionServiceValidationInfo);
}

// The declaration includes the definition on other builds.

AudioSourceFetcher::IPCStableHashFunction AudioSourceFetcher::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioSourceFetcher>(message.name())) {
    case messages::AudioSourceFetcher::kStart: {
      return &AudioSourceFetcher::Start_Sym::IPCStableHash;
    }
    case messages::AudioSourceFetcher::kStop: {
      return &AudioSourceFetcher::Stop_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioSourceFetcher::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioSourceFetcher>(message.name())) {
      case messages::AudioSourceFetcher::kStart:
            return "Receive media::mojom::AudioSourceFetcher::Start";
      case messages::AudioSourceFetcher::kStop:
            return "Receive media::mojom::AudioSourceFetcher::Stop";
    }
  } else {
    switch (static_cast<messages::AudioSourceFetcher>(message.name())) {
      case messages::AudioSourceFetcher::kStart:
            return "Receive reply media::mojom::AudioSourceFetcher::Start";
      case messages::AudioSourceFetcher::kStop:
            return "Receive reply media::mojom::AudioSourceFetcher::Stop";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioSourceFetcher::Start_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25e9815c;  // IPCStableHash for media::mojom::AudioSourceFetcher::Start
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioSourceFetcher::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x661a3dd2;  // IPCStableHash for media::mojom::AudioSourceFetcher::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioSourceFetcherProxy::AudioSourceFetcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioSourceFetcherProxy::Start(
    ::mojo::PendingRemote<::media::mojom::blink::AudioStreamFactory> in_factory, const ::blink::String& in_device_id, const ::media::AudioParameters& in_audio_parameters) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioSourceFetcher::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingRemote<::media::mojom::blink::AudioStreamFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_parameters"), in_audio_parameters,
                        "<value of type const ::media::AudioParameters&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioSourceFetcher::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioSourceFetcher_Start_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioStreamFactoryInterfaceBase>>(
    in_factory,
    &params->factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid factory in AudioSourceFetcher.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in AudioSourceFetcher.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->audio_parameters)::BaseType> audio_parameters_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
    in_audio_parameters,
    audio_parameters_fragment);

  params->audio_parameters.Set(
      audio_parameters_fragment.is_null() ? nullptr : audio_parameters_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->audio_parameters.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null audio_parameters in AudioSourceFetcher.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioSourceFetcher::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioSourceFetcherProxy::Stop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioSourceFetcher::Stop");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioSourceFetcher::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioSourceFetcher_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioSourceFetcher::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioSourceFetcherStubDispatch::Accept(
    AudioSourceFetcher* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioSourceFetcher>(message->header()->name)) {
    case messages::AudioSourceFetcher::kStart: {
      DCHECK(message->is_serialized());
      internal::AudioSourceFetcher_Start_Params_Data* params =
          reinterpret_cast<internal::AudioSourceFetcher_Start_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioSourceFetcher.0
      bool success = true;
      ::mojo::PendingRemote<::media::mojom::blink::AudioStreamFactory> p_factory{};
      ::blink::String p_device_id{};
      ::media::AudioParameters p_audio_parameters{};
      AudioSourceFetcher_Start_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadAudioParameters(&p_audio_parameters))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioSourceFetcher::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(        
        std::move(p_factory), 
        std::move(p_device_id), 
        std::move(p_audio_parameters));
      return true;
    }
    case messages::AudioSourceFetcher::kStop: {
      DCHECK(message->is_serialized());
      internal::AudioSourceFetcher_Stop_Params_Data* params =
          reinterpret_cast<internal::AudioSourceFetcher_Stop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioSourceFetcher.1
      bool success = true;
      AudioSourceFetcher_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioSourceFetcher::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(        );
      return true;
    }
  }
  return false;
}

// static
bool AudioSourceFetcherStubDispatch::AcceptWithResponder(
    AudioSourceFetcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioSourceFetcher>(message->header()->name)) {
    case messages::AudioSourceFetcher::kStart: {
      break;
    }
    case messages::AudioSourceFetcher::kStop: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioSourceFetcherValidationInfo[] = {
    { &internal::AudioSourceFetcher_Start_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioSourceFetcher_Stop_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioSourceFetcherRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::AudioSourceFetcher::Name_,
    kAudioSourceFetcherValidationInfo);
}



}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void AudioSourceSpeechRecognitionContextInterceptorForTesting::BindAudioSourceFetcher(::mojo::PendingReceiver<AudioSourceFetcher> fetcher_receiver, ::mojo::PendingRemote<::media::mojom::blink::SpeechRecognitionRecognizerClient> client, ::media::mojom::blink::SpeechRecognitionOptionsPtr options, BindAudioSourceFetcherCallback callback) {
  GetForwardingInterface()->BindAudioSourceFetcher(
    std::move(fetcher_receiver)
    , 
    std::move(client)
    , 
    std::move(options)
    , std::move(callback));
}
AudioSourceSpeechRecognitionContextAsyncWaiter::AudioSourceSpeechRecognitionContextAsyncWaiter(
    AudioSourceSpeechRecognitionContext* proxy) : proxy_(proxy) {}

AudioSourceSpeechRecognitionContextAsyncWaiter::~AudioSourceSpeechRecognitionContextAsyncWaiter() = default;


void AudioSourceSpeechRecognitionContextAsyncWaiter::BindAudioSourceFetcher(
    ::mojo::PendingReceiver<AudioSourceFetcher> fetcher_receiver, ::mojo::PendingRemote<::media::mojom::blink::SpeechRecognitionRecognizerClient> client, ::media::mojom::blink::SpeechRecognitionOptionsPtr options, bool* out_is_multichannel_supported) {
  base::RunLoop loop;
  proxy_->BindAudioSourceFetcher(
      std::move(fetcher_receiver),
      std::move(client),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_multichannel_supported
,
             bool is_multichannel_supported) {*out_is_multichannel_supported = std::move(is_multichannel_supported);
            loop->Quit();
          },
          &loop,
          out_is_multichannel_supported));
  loop.Run();
}

bool AudioSourceSpeechRecognitionContextAsyncWaiter::BindAudioSourceFetcher(
    ::mojo::PendingReceiver<AudioSourceFetcher> fetcher_receiver, ::mojo::PendingRemote<::media::mojom::blink::SpeechRecognitionRecognizerClient> client, ::media::mojom::blink::SpeechRecognitionOptionsPtr options) {
  bool async_wait_result;
  BindAudioSourceFetcher(std::move(fetcher_receiver),std::move(client),std::move(options),&async_wait_result);
  return async_wait_result;
}




void SpeechRecognitionServiceInterceptorForTesting::BindSpeechRecognitionContext(::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionContext> context) {
  GetForwardingInterface()->BindSpeechRecognitionContext(
    std::move(context)
    );
}
void SpeechRecognitionServiceInterceptorForTesting::BindAudioSourceSpeechRecognitionContext(::mojo::PendingReceiver<AudioSourceSpeechRecognitionContext> context) {
  GetForwardingInterface()->BindAudioSourceSpeechRecognitionContext(
    std::move(context)
    );
}
void SpeechRecognitionServiceInterceptorForTesting::SetSodaPaths(const ::base::FilePath& binary_path, const ::blink::HashMap<::blink::String, ::base::FilePath>& config_paths, const ::blink::String& primary_language_name) {
  GetForwardingInterface()->SetSodaPaths(
    std::move(binary_path)
    , 
    std::move(config_paths)
    , 
    std::move(primary_language_name)
    );
}
void SpeechRecognitionServiceInterceptorForTesting::SetSodaParams(bool mask_offensive_words) {
  GetForwardingInterface()->SetSodaParams(
    std::move(mask_offensive_words)
    );
}
void SpeechRecognitionServiceInterceptorForTesting::SetSodaConfigPaths(const ::blink::HashMap<::blink::String, ::base::FilePath>& config_paths) {
  GetForwardingInterface()->SetSodaConfigPaths(
    std::move(config_paths)
    );
}
SpeechRecognitionServiceAsyncWaiter::SpeechRecognitionServiceAsyncWaiter(
    SpeechRecognitionService* proxy) : proxy_(proxy) {}

SpeechRecognitionServiceAsyncWaiter::~SpeechRecognitionServiceAsyncWaiter() = default;





void AudioSourceFetcherInterceptorForTesting::Start(::mojo::PendingRemote<::media::mojom::blink::AudioStreamFactory> factory, const ::blink::String& device_id, const ::media::AudioParameters& audio_parameters) {
  GetForwardingInterface()->Start(
    std::move(factory)
    , 
    std::move(device_id)
    , 
    std::move(audio_parameters)
    );
}
void AudioSourceFetcherInterceptorForTesting::Stop() {
  GetForwardingInterface()->Stop();
}
AudioSourceFetcherAsyncWaiter::AudioSourceFetcherAsyncWaiter(
    AudioSourceFetcher* proxy) : proxy_(proxy) {}

AudioSourceFetcherAsyncWaiter::~AudioSourceFetcherAsyncWaiter() = default;







}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif