// media/mojo/mojom/speech_recognition_result.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognition_result.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"




#include "media/mojo/mojom/speech_recognition_result.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SpeechRecognitionHypothesisDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SpeechRecognitionHypothesisDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SpeechRecognitionHypothesis_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::utterance(input)) in_utterance = Traits::utterance(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->utterance)::BaseType> utterance_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_utterance,
      utterance_fragment);

    fragment->utterance.Set(
        utterance_fragment.is_null() ? nullptr : utterance_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->utterance.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null utterance in SpeechRecognitionHypothesis struct");

    fragment->confidence = Traits::confidence(input);
  }

  static bool Deserialize(::media::mojom::internal::SpeechRecognitionHypothesis_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SpeechRecognitionHypothesisDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::WebSpeechRecognitionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::WebSpeechRecognitionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::WebSpeechRecognitionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::hypotheses(input)) in_hypotheses = Traits::hypotheses(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hypotheses)::BaseType>
        hypotheses_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hypotheses_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SpeechRecognitionHypothesisDataView>>(
      in_hypotheses,
      hypotheses_fragment,
      &hypotheses_validate_params);

    fragment->hypotheses.Set(
        hypotheses_fragment.is_null() ? nullptr : hypotheses_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hypotheses.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hypotheses in WebSpeechRecognitionResult struct");

    fragment->is_provisional = Traits::is_provisional(input);
  }

  static bool Deserialize(::media::mojom::internal::WebSpeechRecognitionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::WebSpeechRecognitionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void SpeechRecognitionHypothesisDataView::GetUtteranceDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->utterance.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void WebSpeechRecognitionResultDataView::GetHypothesesDataView(
    mojo::ArrayDataView<SpeechRecognitionHypothesisDataView>* output) {
  auto pointer = data_->hypotheses.Get();
  *output = mojo::ArrayDataView<SpeechRecognitionHypothesisDataView>(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_SHARED_H_