// media/mojo/mojom/speech_recognition_error.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_ERROR_MOJOM_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_ERROR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognition_error.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_error.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_error.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_error_code.mojom-forward.h"
#include <string>
#include <vector>








namespace media::mojom {





class  SpeechRecognitionError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechRecognitionError, T>::value>;
  using DataView = SpeechRecognitionErrorDataView;
  using Data_ = internal::SpeechRecognitionError_Data;

  template <typename... Args>
  static SpeechRecognitionErrorPtr New(Args&&... args) {
    return SpeechRecognitionErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechRecognitionErrorPtr From(const U& u) {
    return mojo::TypeConverter<SpeechRecognitionErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechRecognitionError>::Convert(*this);
  }


  SpeechRecognitionError();

  SpeechRecognitionError(
      ::media::mojom::SpeechRecognitionErrorCode code,
      SpeechAudioErrorDetails details);


  ~SpeechRecognitionError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechRecognitionErrorPtr>
  SpeechRecognitionErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechRecognitionError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeechRecognitionError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeechRecognitionError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechRecognitionError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechRecognitionError_UnserializedMessageContext<
            UserType, SpeechRecognitionError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeechRecognitionError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeechRecognitionError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechRecognitionError_UnserializedMessageContext<
            UserType, SpeechRecognitionError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechRecognitionError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::mojom::SpeechRecognitionErrorCode code;
  
  SpeechAudioErrorDetails details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechRecognitionError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechRecognitionError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechRecognitionError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechRecognitionError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
SpeechRecognitionErrorPtr SpeechRecognitionError::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(details)
  );
}

template <typename T, SpeechRecognitionError::EnableIfSame<T>*>
bool SpeechRecognitionError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  return true;
}

template <typename T, SpeechRecognitionError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::SpeechRecognitionError::DataView,
                                         ::media::mojom::SpeechRecognitionErrorPtr> {
  static bool IsNull(const ::media::mojom::SpeechRecognitionErrorPtr& input) { return !input; }
  static void SetToNull(::media::mojom::SpeechRecognitionErrorPtr* output) { output->reset(); }

  static decltype(::media::mojom::SpeechRecognitionError::code) code(
      const ::media::mojom::SpeechRecognitionErrorPtr& input) {
    return input->code;
  }

  static decltype(::media::mojom::SpeechRecognitionError::details) details(
      const ::media::mojom::SpeechRecognitionErrorPtr& input) {
    return input->details;
  }

  static bool Read(::media::mojom::SpeechRecognitionError::DataView input, ::media::mojom::SpeechRecognitionErrorPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_ERROR_MOJOM_H_