// media/mojo/mojom/speech_recognition_audio_forwarder.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/speech_recognition_audio_forwarder.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var audio_data$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_data.mojom', 'audio_data.mojom.js');
  }



  function SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params.prototype.initDefaults_ = function() {
    this.buffer = null;
  };
  SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params.buffer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, audio_data$.AudioDataS16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStructPointer(audio_data$.AudioDataS16);
    return val;
  };

  SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(audio_data$.AudioDataS16, val.buffer);
  };
  var kSpeechRecognitionAudioForwarder_AddAudioFromRenderer_Name = 1;

  function SpeechRecognitionAudioForwarderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionAudioForwarder,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionAudioForwarderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionAudioForwarder, associatedInterfacePtrInfo);
  }

  SpeechRecognitionAudioForwarderAssociatedPtr.prototype =
      Object.create(SpeechRecognitionAudioForwarderPtr.prototype);
  SpeechRecognitionAudioForwarderAssociatedPtr.prototype.constructor =
      SpeechRecognitionAudioForwarderAssociatedPtr;

  function SpeechRecognitionAudioForwarderProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionAudioForwarderPtr.prototype.addAudioFromRenderer = function() {
    return SpeechRecognitionAudioForwarderProxy.prototype.addAudioFromRenderer
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionAudioForwarderProxy.prototype.addAudioFromRenderer = function(buffer) {
    var params_ = new SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params();
    params_.buffer = buffer;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionAudioForwarder_AddAudioFromRenderer_Name,
        codec.align(SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognitionAudioForwarderStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionAudioForwarderStub.prototype.addAudioFromRenderer = function(buffer) {
    return this.delegate_ && this.delegate_.addAudioFromRenderer && this.delegate_.addAudioFromRenderer(buffer);
  }

  SpeechRecognitionAudioForwarderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionAudioForwarder_AddAudioFromRenderer_Name:
      var params = reader.decodeStruct(SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params);
      this.addAudioFromRenderer(params.buffer);
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionAudioForwarderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechRecognitionAudioForwarderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionAudioForwarder_AddAudioFromRenderer_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionAudioForwarderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechRecognitionAudioForwarder = {
    name: 'media.mojom.SpeechRecognitionAudioForwarder',
    kVersion: 6,
    ptrClass: SpeechRecognitionAudioForwarderPtr,
    proxyClass: SpeechRecognitionAudioForwarderProxy,
    stubClass: SpeechRecognitionAudioForwarderStub,
    validateRequest: validateSpeechRecognitionAudioForwarderRequest,
    validateResponse: null,
  };
  SpeechRecognitionAudioForwarderStub.prototype.validator = validateSpeechRecognitionAudioForwarderRequest;
  SpeechRecognitionAudioForwarderProxy.prototype.validator = null;
  exports.SpeechRecognitionAudioForwarder = SpeechRecognitionAudioForwarder;
  exports.SpeechRecognitionAudioForwarderPtr = SpeechRecognitionAudioForwarderPtr;
  exports.SpeechRecognitionAudioForwarderAssociatedPtr = SpeechRecognitionAudioForwarderAssociatedPtr;
})();