// media/mojo/mojom/speech_recognition.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_TEST_UTILS_H_

#include "media/mojo/mojom/speech_recognition.mojom.h"


namespace media::mojom {


class  SpeechRecognitionContextInterceptorForTesting : public SpeechRecognitionContext {
  virtual SpeechRecognitionContext* GetForwardingInterface() = 0;
  void BindRecognizer(::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options, BindRecognizerCallback callback) override;
  void BindWebSpeechRecognizer(::mojo::PendingReceiver<::media::mojom::SpeechRecognitionSession> session_receiver, ::mojo::PendingRemote<::media::mojom::SpeechRecognitionSessionClient> session_client, ::mojo::PendingReceiver<::media::mojom::SpeechRecognitionAudioForwarder> audio_forwarder, int32_t channel_count, int32_t sample_rate, SpeechRecognitionOptionsPtr options, bool continuous) override;
};
class  SpeechRecognitionContextAsyncWaiter {
 public:
  explicit SpeechRecognitionContextAsyncWaiter(SpeechRecognitionContext* proxy);

  SpeechRecognitionContextAsyncWaiter(const SpeechRecognitionContextAsyncWaiter&) = delete;
  SpeechRecognitionContextAsyncWaiter& operator=(const SpeechRecognitionContextAsyncWaiter&) = delete;

  ~SpeechRecognitionContextAsyncWaiter();
  void BindRecognizer(
      ::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options, bool* out_is_multichannel_supported);
  bool BindRecognizer(::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, SpeechRecognitionOptionsPtr options);

 private:
  SpeechRecognitionContext* const proxy_;
};


class  SpeechRecognitionRecognizerInterceptorForTesting : public SpeechRecognitionRecognizer {
  virtual SpeechRecognitionRecognizer* GetForwardingInterface() = 0;
  void SendAudioToSpeechRecognitionService(::media::mojom::AudioDataS16Ptr buffer, std::optional<::base::TimeDelta> media_start_pts) override;
  void MarkDone() override;
  void OnLanguageChanged(const std::string& language) override;
  void OnMaskOffensiveWordsChanged(bool mask_offensive_words) override;
  void UpdateRecognitionContext(const ::media::SpeechRecognitionRecognitionContext& recognition_context) override;
};
class  SpeechRecognitionRecognizerAsyncWaiter {
 public:
  explicit SpeechRecognitionRecognizerAsyncWaiter(SpeechRecognitionRecognizer* proxy);

  SpeechRecognitionRecognizerAsyncWaiter(const SpeechRecognitionRecognizerAsyncWaiter&) = delete;
  SpeechRecognitionRecognizerAsyncWaiter& operator=(const SpeechRecognitionRecognizerAsyncWaiter&) = delete;

  ~SpeechRecognitionRecognizerAsyncWaiter();

 private:
  SpeechRecognitionRecognizer* const proxy_;
};


class  SpeechRecognitionRecognizerClientInterceptorForTesting : public SpeechRecognitionRecognizerClient {
  virtual SpeechRecognitionRecognizerClient* GetForwardingInterface() = 0;
  void OnSpeechRecognitionRecognitionEvent(const ::media::SpeechRecognitionResult& result, OnSpeechRecognitionRecognitionEventCallback callback) override;
  void OnSpeechRecognitionStopped() override;
  void OnSpeechRecognitionError() override;
  void OnLanguageIdentificationEvent(LanguageIdentificationEventPtr event) override;
};
class  SpeechRecognitionRecognizerClientAsyncWaiter {
 public:
  explicit SpeechRecognitionRecognizerClientAsyncWaiter(SpeechRecognitionRecognizerClient* proxy);

  SpeechRecognitionRecognizerClientAsyncWaiter(const SpeechRecognitionRecognizerClientAsyncWaiter&) = delete;
  SpeechRecognitionRecognizerClientAsyncWaiter& operator=(const SpeechRecognitionRecognizerClientAsyncWaiter&) = delete;

  ~SpeechRecognitionRecognizerClientAsyncWaiter();
  void OnSpeechRecognitionRecognitionEvent(
      const ::media::SpeechRecognitionResult& result, bool* out_continue_recognition);
  bool OnSpeechRecognitionRecognitionEvent(const ::media::SpeechRecognitionResult& result);

 private:
  SpeechRecognitionRecognizerClient* const proxy_;
};


class  SpeechRecognitionBrowserObserverInterceptorForTesting : public SpeechRecognitionBrowserObserver {
  virtual SpeechRecognitionBrowserObserver* GetForwardingInterface() = 0;
  void SpeechRecognitionAvailabilityChanged(bool is_speech_recognition_available) override;
  void SpeechRecognitionLanguageChanged(const std::string& language) override;
  void SpeechRecognitionMaskOffensiveWordsChanged(bool mask_offensive_words) override;
};
class  SpeechRecognitionBrowserObserverAsyncWaiter {
 public:
  explicit SpeechRecognitionBrowserObserverAsyncWaiter(SpeechRecognitionBrowserObserver* proxy);

  SpeechRecognitionBrowserObserverAsyncWaiter(const SpeechRecognitionBrowserObserverAsyncWaiter&) = delete;
  SpeechRecognitionBrowserObserverAsyncWaiter& operator=(const SpeechRecognitionBrowserObserverAsyncWaiter&) = delete;

  ~SpeechRecognitionBrowserObserverAsyncWaiter();

 private:
  SpeechRecognitionBrowserObserver* const proxy_;
};


class  SpeechRecognitionSurfaceInterceptorForTesting : public SpeechRecognitionSurface {
  virtual SpeechRecognitionSurface* GetForwardingInterface() = 0;
  void Activate() override;
  void GetBounds(GetBoundsCallback callback) override;
};
class  SpeechRecognitionSurfaceAsyncWaiter {
 public:
  explicit SpeechRecognitionSurfaceAsyncWaiter(SpeechRecognitionSurface* proxy);

  SpeechRecognitionSurfaceAsyncWaiter(const SpeechRecognitionSurfaceAsyncWaiter&) = delete;
  SpeechRecognitionSurfaceAsyncWaiter& operator=(const SpeechRecognitionSurfaceAsyncWaiter&) = delete;

  ~SpeechRecognitionSurfaceAsyncWaiter();
  void GetBounds(
      std::optional<::gfx::Rect>* out_bounds);
  std::optional<::gfx::Rect> GetBounds();

 private:
  SpeechRecognitionSurface* const proxy_;
};


class  SpeechRecognitionSurfaceClientInterceptorForTesting : public SpeechRecognitionSurfaceClient {
  virtual SpeechRecognitionSurfaceClient* GetForwardingInterface() = 0;
  void OnSessionEnded() override;
  void OnFullscreenToggled() override;
};
class  SpeechRecognitionSurfaceClientAsyncWaiter {
 public:
  explicit SpeechRecognitionSurfaceClientAsyncWaiter(SpeechRecognitionSurfaceClient* proxy);

  SpeechRecognitionSurfaceClientAsyncWaiter(const SpeechRecognitionSurfaceClientAsyncWaiter&) = delete;
  SpeechRecognitionSurfaceClientAsyncWaiter& operator=(const SpeechRecognitionSurfaceClientAsyncWaiter&) = delete;

  ~SpeechRecognitionSurfaceClientAsyncWaiter();

 private:
  SpeechRecognitionSurfaceClient* const proxy_;
};


class  SpeechRecognitionClientBrowserInterfaceInterceptorForTesting : public SpeechRecognitionClientBrowserInterface {
  virtual SpeechRecognitionClientBrowserInterface* GetForwardingInterface() = 0;
  void BindSpeechRecognitionBrowserObserver(::mojo::PendingRemote<SpeechRecognitionBrowserObserver> observer) override;
  void REMOVED_1() override;
};
class  SpeechRecognitionClientBrowserInterfaceAsyncWaiter {
 public:
  explicit SpeechRecognitionClientBrowserInterfaceAsyncWaiter(SpeechRecognitionClientBrowserInterface* proxy);

  SpeechRecognitionClientBrowserInterfaceAsyncWaiter(const SpeechRecognitionClientBrowserInterfaceAsyncWaiter&) = delete;
  SpeechRecognitionClientBrowserInterfaceAsyncWaiter& operator=(const SpeechRecognitionClientBrowserInterfaceAsyncWaiter&) = delete;

  ~SpeechRecognitionClientBrowserInterfaceAsyncWaiter();

 private:
  SpeechRecognitionClientBrowserInterface* const proxy_;
};




}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_MOJOM_TEST_UTILS_H_