// media/mojo/mojom/renderer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  DemuxerStreamRemote as media_mojom_DemuxerStreamRemote,
  DemuxerStreamPendingReceiver as media_mojom_DemuxerStreamPendingReceiver
} from './demuxer_stream.mojom.m.js';

import {
  BufferingState as media_mojom_BufferingState,
  BufferingStateSpec as media_mojom_BufferingStateSpec,
  BufferingStateChangeReason as media_mojom_BufferingStateChangeReason,
  BufferingStateChangeReasonSpec as media_mojom_BufferingStateChangeReasonSpec,
  WaitingReason as media_mojom_WaitingReason,
  WaitingReasonSpec as media_mojom_WaitingReasonSpec,
  AudioDecoderConfig as media_mojom_AudioDecoderConfig,
  AudioDecoderConfigSpec as media_mojom_AudioDecoderConfigSpec,
  PipelineStatistics as media_mojom_PipelineStatistics,
  PipelineStatisticsSpec as media_mojom_PipelineStatisticsSpec,
  PipelineStatus as media_mojom_PipelineStatus,
  PipelineStatusSpec as media_mojom_PipelineStatusSpec,
  VideoDecoderConfig as media_mojom_VideoDecoderConfig,
  VideoDecoderConfigSpec as media_mojom_VideoDecoderConfigSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RendererPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.Renderer', scope);
  }
}

/** @interface */
export class RendererInterface {
  
  /**
   * @param { !Object } client
   * @param { ?Array<!media_mojom_DemuxerStreamRemote> } streams
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initialize(client, streams) {}
  
  /**
   * @return {!Promise}
   */

  flush() {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } time
   */

  startPlayingFrom(time) {}
  
  /**
   * @param { !number } playbackRate
   */

  setPlaybackRate(playbackRate) {}
  
  /**
   * @param { !number } volume
   */

  setVolume(volume) {}
  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } cdmId
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setCdm(cdmId) {}
  
  /**
   * @param { ?mojoBase_mojom_TimeDelta } latencyHint
   */

  setLatencyHint(latencyHint) {}
}

/**
 * @implements { RendererInterface }
 */
export class RendererRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RendererPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RendererPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RendererPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @param { ?Array<!media_mojom_DemuxerStreamRemote> } streams
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initialize(
      client,
      streams) {
    return this.proxy.sendMessage(
        0,
        Renderer_Initialize_ParamsSpec.$,
        Renderer_Initialize_ResponseParamsSpec.$,
        [
          client,
          streams
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  flush() {
    return this.proxy.sendMessage(
        1,
        Renderer_Flush_ParamsSpec.$,
        Renderer_Flush_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } time
   */

  startPlayingFrom(
      time) {
    this.proxy.sendMessage(
        2,
        Renderer_StartPlayingFrom_ParamsSpec.$,
        null,
        [
          time
        ],
        false);
  }

  
  /**
   * @param { !number } playbackRate
   */

  setPlaybackRate(
      playbackRate) {
    this.proxy.sendMessage(
        3,
        Renderer_SetPlaybackRate_ParamsSpec.$,
        null,
        [
          playbackRate
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  setVolume(
      volume) {
    this.proxy.sendMessage(
        4,
        Renderer_SetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } cdmId
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setCdm(
      cdmId) {
    return this.proxy.sendMessage(
        5,
        Renderer_SetCdm_ParamsSpec.$,
        Renderer_SetCdm_ResponseParamsSpec.$,
        [
          cdmId
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase_mojom_TimeDelta } latencyHint
   */

  setLatencyHint(
      latencyHint) {
    this.proxy.sendMessage(
        6,
        Renderer_SetLatencyHint_ParamsSpec.$,
        null,
        [
          latencyHint
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Renderer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RendererReceiver {
  /**
   * @param {!RendererInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RendererRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RendererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Renderer_Initialize_ParamsSpec.$,
        Renderer_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Renderer_Flush_ParamsSpec.$,
        Renderer_Flush_ResponseParamsSpec.$,
        impl.flush.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Renderer_StartPlayingFrom_ParamsSpec.$,
        null,
        impl.startPlayingFrom.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Renderer_SetPlaybackRate_ParamsSpec.$,
        null,
        impl.setPlaybackRate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Renderer_SetVolume_ParamsSpec.$,
        null,
        impl.setVolume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Renderer_SetCdm_ParamsSpec.$,
        Renderer_SetCdm_ResponseParamsSpec.$,
        impl.setCdm.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Renderer_SetLatencyHint_ParamsSpec.$,
        null,
        impl.setLatencyHint.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Renderer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.Renderer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RendererRemote}
   */
  static getRemote() {
    let remote = new RendererRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Renderer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RendererCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RendererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Renderer_Initialize_ParamsSpec.$,
        Renderer_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Renderer_Flush_ParamsSpec.$,
        Renderer_Flush_ResponseParamsSpec.$,
        this.flush.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startPlayingFrom =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Renderer_StartPlayingFrom_ParamsSpec.$,
        null,
        this.startPlayingFrom.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPlaybackRate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Renderer_SetPlaybackRate_ParamsSpec.$,
        null,
        this.setPlaybackRate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Renderer_SetVolume_ParamsSpec.$,
        null,
        this.setVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCdm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Renderer_SetCdm_ParamsSpec.$,
        Renderer_SetCdm_ResponseParamsSpec.$,
        this.setCdm.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setLatencyHint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Renderer_SetLatencyHint_ParamsSpec.$,
        null,
        this.setLatencyHint.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RendererClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.RendererClient', scope);
  }
}

/** @interface */
export class RendererClientInterface {
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } time
   * @param { !mojoBase_mojom_TimeDelta } maxTime
   * @param { !mojoBase_mojom_TimeTicks } captureTime
   */

  onTimeUpdate(time, maxTime, captureTime) {}
  
  /**
   * @param { !media_mojom_BufferingState } state
   * @param { !media_mojom_BufferingStateChangeReason } reason
   */

  onBufferingStateChange(state, reason) {}
  
  /**
   */

  onEnded() {}
  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onError(status) {}
  
  /**
   * @param { !media_mojom_AudioDecoderConfig } config
   */

  onAudioConfigChange(config) {}
  
  /**
   * @param { !media_mojom_VideoDecoderConfig } config
   */

  onVideoConfigChange(config) {}
  
  /**
   * @param { !gfx_mojom_Size } size
   */

  onVideoNaturalSizeChange(size) {}
  
  /**
   * @param { !boolean } opaque
   */

  onVideoOpacityChange(opaque) {}
  
  /**
   * @param { !media_mojom_PipelineStatistics } stats
   */

  onStatisticsUpdate(stats) {}
  
  /**
   * @param { !media_mojom_WaitingReason } reason
   */

  onWaiting(reason) {}
}

/**
 * @implements { RendererClientInterface }
 */
export class RendererClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RendererClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RendererClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RendererClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } time
   * @param { !mojoBase_mojom_TimeDelta } maxTime
   * @param { !mojoBase_mojom_TimeTicks } captureTime
   */

  onTimeUpdate(
      time,
      maxTime,
      captureTime) {
    this.proxy.sendMessage(
        0,
        RendererClient_OnTimeUpdate_ParamsSpec.$,
        null,
        [
          time,
          maxTime,
          captureTime
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_BufferingState } state
   * @param { !media_mojom_BufferingStateChangeReason } reason
   */

  onBufferingStateChange(
      state,
      reason) {
    this.proxy.sendMessage(
        1,
        RendererClient_OnBufferingStateChange_ParamsSpec.$,
        null,
        [
          state,
          reason
        ],
        false);
  }

  
  /**
   */

  onEnded() {
    this.proxy.sendMessage(
        2,
        RendererClient_OnEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onError(
      status) {
    this.proxy.sendMessage(
        3,
        RendererClient_OnError_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_AudioDecoderConfig } config
   */

  onAudioConfigChange(
      config) {
    this.proxy.sendMessage(
        4,
        RendererClient_OnAudioConfigChange_ParamsSpec.$,
        null,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoDecoderConfig } config
   */

  onVideoConfigChange(
      config) {
    this.proxy.sendMessage(
        5,
        RendererClient_OnVideoConfigChange_ParamsSpec.$,
        null,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Size } size
   */

  onVideoNaturalSizeChange(
      size) {
    this.proxy.sendMessage(
        6,
        RendererClient_OnVideoNaturalSizeChange_ParamsSpec.$,
        null,
        [
          size
        ],
        false);
  }

  
  /**
   * @param { !boolean } opaque
   */

  onVideoOpacityChange(
      opaque) {
    this.proxy.sendMessage(
        7,
        RendererClient_OnVideoOpacityChange_ParamsSpec.$,
        null,
        [
          opaque
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_PipelineStatistics } stats
   */

  onStatisticsUpdate(
      stats) {
    this.proxy.sendMessage(
        8,
        RendererClient_OnStatisticsUpdate_ParamsSpec.$,
        null,
        [
          stats
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_WaitingReason } reason
   */

  onWaiting(
      reason) {
    this.proxy.sendMessage(
        9,
        RendererClient_OnWaiting_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RendererClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RendererClientReceiver {
  /**
   * @param {!RendererClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RendererClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RendererClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RendererClient_OnTimeUpdate_ParamsSpec.$,
        null,
        impl.onTimeUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        RendererClient_OnBufferingStateChange_ParamsSpec.$,
        null,
        impl.onBufferingStateChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        RendererClient_OnEnded_ParamsSpec.$,
        null,
        impl.onEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        RendererClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        RendererClient_OnAudioConfigChange_ParamsSpec.$,
        null,
        impl.onAudioConfigChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        RendererClient_OnVideoConfigChange_ParamsSpec.$,
        null,
        impl.onVideoConfigChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        RendererClient_OnVideoNaturalSizeChange_ParamsSpec.$,
        null,
        impl.onVideoNaturalSizeChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        RendererClient_OnVideoOpacityChange_ParamsSpec.$,
        null,
        impl.onVideoOpacityChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        RendererClient_OnStatisticsUpdate_ParamsSpec.$,
        null,
        impl.onStatisticsUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        RendererClient_OnWaiting_ParamsSpec.$,
        null,
        impl.onWaiting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RendererClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.RendererClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RendererClientRemote}
   */
  static getRemote() {
    let remote = new RendererClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RendererClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RendererClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RendererClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTimeUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RendererClient_OnTimeUpdate_ParamsSpec.$,
        null,
        this.onTimeUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBufferingStateChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        RendererClient_OnBufferingStateChange_ParamsSpec.$,
        null,
        this.onBufferingStateChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        RendererClient_OnEnded_ParamsSpec.$,
        null,
        this.onEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        RendererClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAudioConfigChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        RendererClient_OnAudioConfigChange_ParamsSpec.$,
        null,
        this.onAudioConfigChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoConfigChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        RendererClient_OnVideoConfigChange_ParamsSpec.$,
        null,
        this.onVideoConfigChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoNaturalSizeChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        RendererClient_OnVideoNaturalSizeChange_ParamsSpec.$,
        null,
        this.onVideoNaturalSizeChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoOpacityChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        RendererClient_OnVideoOpacityChange_ParamsSpec.$,
        null,
        this.onVideoOpacityChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStatisticsUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        RendererClient_OnStatisticsUpdate_ParamsSpec.$,
        null,
        this.onStatisticsUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWaiting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        RendererClient_OnWaiting_ParamsSpec.$,
        null,
        this.onWaiting.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_Flush_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_StartPlayingFrom_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetPlaybackRate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetCdm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetCdm_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetLatencyHint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererClient_OnTimeUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererClient_OnBufferingStateChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererClient_OnEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererClient_OnAudioConfigChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererClient_OnVideoConfigChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererClient_OnVideoNaturalSizeChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererClient_OnVideoOpacityChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererClient_OnStatisticsUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererClient_OnWaiting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    Renderer_Initialize_ParamsSpec.$,
    'Renderer_Initialize_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(RendererClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streams', 8,
        0,
        mojo.internal.Array(mojo.internal.InterfaceProxy(media_mojom_DemuxerStreamRemote), false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Renderer_Initialize_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
    /** @type { (Array<!media_mojom_DemuxerStreamRemote>|undefined) } */
    this.streams;
  }
}



mojo.internal.Struct(
    Renderer_Initialize_ResponseParamsSpec.$,
    'Renderer_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_Initialize_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    Renderer_Flush_ParamsSpec.$,
    'Renderer_Flush_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Renderer_Flush_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Renderer_Flush_ResponseParamsSpec.$,
    'Renderer_Flush_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Renderer_Flush_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    Renderer_StartPlayingFrom_ParamsSpec.$,
    'Renderer_StartPlayingFrom_Params',
    [
      mojo.internal.StructField(
        'time', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_StartPlayingFrom_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.time;
  }
}



mojo.internal.Struct(
    Renderer_SetPlaybackRate_ParamsSpec.$,
    'Renderer_SetPlaybackRate_Params',
    [
      mojo.internal.StructField(
        'playbackRate', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SetPlaybackRate_Params {
  constructor() {
    /** @type { !number } */
    this.playbackRate;
  }
}



mojo.internal.Struct(
    Renderer_SetVolume_ParamsSpec.$,
    'Renderer_SetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SetVolume_Params {
  constructor() {
    /** @type { !number } */
    this.volume;
  }
}



mojo.internal.Struct(
    Renderer_SetCdm_ParamsSpec.$,
    'Renderer_SetCdm_Params',
    [
      mojo.internal.StructField(
        'cdmId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SetCdm_Params {
  constructor() {
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.cdmId;
  }
}



mojo.internal.Struct(
    Renderer_SetCdm_ResponseParamsSpec.$,
    'Renderer_SetCdm_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SetCdm_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    Renderer_SetLatencyHint_ParamsSpec.$,
    'Renderer_SetLatencyHint_Params',
    [
      mojo.internal.StructField(
        'latencyHint', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SetLatencyHint_Params {
  constructor() {
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.latencyHint;
  }
}



mojo.internal.Struct(
    RendererClient_OnTimeUpdate_ParamsSpec.$,
    'RendererClient_OnTimeUpdate_Params',
    [
      mojo.internal.StructField(
        'time', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTime', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'captureTime', 16,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class RendererClient_OnTimeUpdate_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.time;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.maxTime;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.captureTime;
  }
}



mojo.internal.Struct(
    RendererClient_OnBufferingStateChange_ParamsSpec.$,
    'RendererClient_OnBufferingStateChange_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        media_mojom_BufferingStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 4,
        0,
        media_mojom_BufferingStateChangeReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererClient_OnBufferingStateChange_Params {
  constructor() {
    /** @type { !media_mojom_BufferingState } */
    this.state;
    /** @type { !media_mojom_BufferingStateChangeReason } */
    this.reason;
  }
}



mojo.internal.Struct(
    RendererClient_OnEnded_ParamsSpec.$,
    'RendererClient_OnEnded_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RendererClient_OnEnded_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RendererClient_OnError_ParamsSpec.$,
    'RendererClient_OnError_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_PipelineStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererClient_OnError_Params {
  constructor() {
    /** @type { !media_mojom_PipelineStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    RendererClient_OnAudioConfigChange_ParamsSpec.$,
    'RendererClient_OnAudioConfigChange_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media_mojom_AudioDecoderConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererClient_OnAudioConfigChange_Params {
  constructor() {
    /** @type { !media_mojom_AudioDecoderConfig } */
    this.config;
  }
}



mojo.internal.Struct(
    RendererClient_OnVideoConfigChange_ParamsSpec.$,
    'RendererClient_OnVideoConfigChange_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media_mojom_VideoDecoderConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererClient_OnVideoConfigChange_Params {
  constructor() {
    /** @type { !media_mojom_VideoDecoderConfig } */
    this.config;
  }
}



mojo.internal.Struct(
    RendererClient_OnVideoNaturalSizeChange_ParamsSpec.$,
    'RendererClient_OnVideoNaturalSizeChange_Params',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererClient_OnVideoNaturalSizeChange_Params {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.size;
  }
}



mojo.internal.Struct(
    RendererClient_OnVideoOpacityChange_ParamsSpec.$,
    'RendererClient_OnVideoOpacityChange_Params',
    [
      mojo.internal.StructField(
        'opaque', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererClient_OnVideoOpacityChange_Params {
  constructor() {
    /** @type { !boolean } */
    this.opaque;
  }
}



mojo.internal.Struct(
    RendererClient_OnStatisticsUpdate_ParamsSpec.$,
    'RendererClient_OnStatisticsUpdate_Params',
    [
      mojo.internal.StructField(
        'stats', 0,
        0,
        media_mojom_PipelineStatisticsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererClient_OnStatisticsUpdate_Params {
  constructor() {
    /** @type { !media_mojom_PipelineStatistics } */
    this.stats;
  }
}



mojo.internal.Struct(
    RendererClient_OnWaiting_ParamsSpec.$,
    'RendererClient_OnWaiting_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        media_mojom_WaitingReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererClient_OnWaiting_Params {
  constructor() {
    /** @type { !media_mojom_WaitingReason } */
    this.reason;
  }
}

