// media/mojo/mojom/remoting_common.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "media/mojo/mojom/remoting_common.mojom-shared-internal.h"


namespace media::mojom {
class RemotingSinkMetadataDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::RemotingSinkMetadataDataView> {
  using Data = ::media::mojom::internal::RemotingSinkMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class RemotingStopReason : int32_t {
  
  ROUTE_TERMINATED = 0,
  
  LOCAL_PLAYBACK = 1,
  
  SOURCE_GONE = 2,
  
  MESSAGE_SEND_FAILED = 3,
  
  DATA_SEND_FAILED = 4,
  
  UNEXPECTED_FAILURE = 5,
  
  SERVICE_GONE = 6,
  
  USER_DISABLED = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, RemotingStopReason value);
inline bool IsKnownEnumValue(RemotingStopReason value) {
  return internal::RemotingStopReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RemotingStartFailReason : int32_t {
  
  CANNOT_START_MULTIPLE = 0,
  
  ROUTE_TERMINATED = 1,
  
  INVALID_ANSWER_MESSAGE = 2,
  
  REMOTING_NOT_PERMITTED = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, RemotingStartFailReason value);
inline bool IsKnownEnumValue(RemotingStartFailReason value) {
  return internal::RemotingStartFailReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RemotingSinkFeature : int32_t {
  
  RENDERING = 0,
  
  CONTENT_DECRYPTION = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, RemotingSinkFeature value);
inline bool IsKnownEnumValue(RemotingSinkFeature value) {
  return internal::RemotingSinkFeature_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RemotingSinkAudioCapability : int32_t {
  
  CODEC_BASELINE_SET = 0,
  
  CODEC_AAC = 1,
  
  CODEC_OPUS = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RemotingSinkAudioCapability value);
inline bool IsKnownEnumValue(RemotingSinkAudioCapability value) {
  return internal::RemotingSinkAudioCapability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RemotingSinkVideoCapability : int32_t {
  
  SUPPORT_4K = 0,
  
  CODEC_BASELINE_SET = 1,
  
  CODEC_H264 = 2,
  
  CODEC_VP8 = 3,
  
  CODEC_VP9 = 4,
  
  CODEC_HEVC = 5,
  
  CODEC_AV1 = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, RemotingSinkVideoCapability value);
inline bool IsKnownEnumValue(RemotingSinkVideoCapability value) {
  return internal::RemotingSinkVideoCapability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class RemotingSinkMetadataDataView {
 public:
  RemotingSinkMetadataDataView() = default;

  RemotingSinkMetadataDataView(
      internal::RemotingSinkMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFeaturesDataView(
      mojo::ArrayDataView<RemotingSinkFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatures(UserType* output) {
    
    auto* pointer = data_->features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::RemotingSinkFeature>>(
        pointer, output, message_);
  }
  inline void GetAudioCapabilitiesDataView(
      mojo::ArrayDataView<RemotingSinkAudioCapability>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAudioCapabilities(UserType* output) {
    
    auto* pointer = data_->audio_capabilities.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::RemotingSinkAudioCapability>>(
        pointer, output, message_);
  }
  inline void GetVideoCapabilitiesDataView(
      mojo::ArrayDataView<RemotingSinkVideoCapability>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoCapabilities(UserType* output) {
    
    auto* pointer = data_->video_capabilities.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::RemotingSinkVideoCapability>>(
        pointer, output, message_);
  }
  inline void GetFriendlyNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFriendlyName(UserType* output) {
    
    auto* pointer = data_->friendly_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::RemotingSinkMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_REMOTING_COMMON_MOJOM_DATA_VIEW_H_