// media/mojo/mojom/remoting.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_REMOTING_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_REMOTING_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  RemoterFactory_Create_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data source;
  mojo::internal::Handle_Data remoter;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RemoterFactory_Create_Params_Data>;

  RemoterFactory_Create_Params_Data();
  ~RemoterFactory_Create_Params_Data() = delete;
};
static_assert(sizeof(RemoterFactory_Create_Params_Data) == 24,
              "Bad sizeof(RemoterFactory_Create_Params_Data)");
class  RemotingDataStreamSender_SendFrame_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::media::mojom::internal::DecoderBuffer_Data frame;

 private:
  friend class mojo::internal::MessageFragment<RemotingDataStreamSender_SendFrame_Params_Data>;

  RemotingDataStreamSender_SendFrame_Params_Data();
  ~RemotingDataStreamSender_SendFrame_Params_Data() = delete;
};
static_assert(sizeof(RemotingDataStreamSender_SendFrame_Params_Data) == 24,
              "Bad sizeof(RemotingDataStreamSender_SendFrame_Params_Data)");
class  RemotingDataStreamSender_SendFrame_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<RemotingDataStreamSender_SendFrame_ResponseParams_Data>;

  RemotingDataStreamSender_SendFrame_ResponseParams_Data();
  ~RemotingDataStreamSender_SendFrame_ResponseParams_Data() = delete;
};
static_assert(sizeof(RemotingDataStreamSender_SendFrame_ResponseParams_Data) == 8,
              "Bad sizeof(RemotingDataStreamSender_SendFrame_ResponseParams_Data)");
class  RemotingDataStreamSender_CancelInFlightData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<RemotingDataStreamSender_CancelInFlightData_Params_Data>;

  RemotingDataStreamSender_CancelInFlightData_Params_Data();
  ~RemotingDataStreamSender_CancelInFlightData_Params_Data() = delete;
};
static_assert(sizeof(RemotingDataStreamSender_CancelInFlightData_Params_Data) == 8,
              "Bad sizeof(RemotingDataStreamSender_CancelInFlightData_Params_Data)");
class  Remoter_Start_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Remoter_Start_Params_Data>;

  Remoter_Start_Params_Data();
  ~Remoter_Start_Params_Data() = delete;
};
static_assert(sizeof(Remoter_Start_Params_Data) == 8,
              "Bad sizeof(Remoter_Start_Params_Data)");
class  Remoter_StartWithPermissionAlreadyGranted_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Remoter_StartWithPermissionAlreadyGranted_Params_Data>;

  Remoter_StartWithPermissionAlreadyGranted_Params_Data();
  ~Remoter_StartWithPermissionAlreadyGranted_Params_Data() = delete;
};
static_assert(sizeof(Remoter_StartWithPermissionAlreadyGranted_Params_Data) == 8,
              "Bad sizeof(Remoter_StartWithPermissionAlreadyGranted_Params_Data)");
class  Remoter_StartDataStreams_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data audio_pipe;
  mojo::internal::Handle_Data video_pipe;
  mojo::internal::Handle_Data audio_sender;
  mojo::internal::Handle_Data video_sender;

 private:
  friend class mojo::internal::MessageFragment<Remoter_StartDataStreams_Params_Data>;

  Remoter_StartDataStreams_Params_Data();
  ~Remoter_StartDataStreams_Params_Data() = delete;
};
static_assert(sizeof(Remoter_StartDataStreams_Params_Data) == 24,
              "Bad sizeof(Remoter_StartDataStreams_Params_Data)");
class  Remoter_Stop_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reason;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Remoter_Stop_Params_Data>;

  Remoter_Stop_Params_Data();
  ~Remoter_Stop_Params_Data() = delete;
};
static_assert(sizeof(Remoter_Stop_Params_Data) == 16,
              "Bad sizeof(Remoter_Stop_Params_Data)");
class  Remoter_SendMessageToSink_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> message;

 private:
  friend class mojo::internal::MessageFragment<Remoter_SendMessageToSink_Params_Data>;

  Remoter_SendMessageToSink_Params_Data();
  ~Remoter_SendMessageToSink_Params_Data() = delete;
};
static_assert(sizeof(Remoter_SendMessageToSink_Params_Data) == 16,
              "Bad sizeof(Remoter_SendMessageToSink_Params_Data)");
class  Remoter_EstimateTransmissionCapacity_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Remoter_EstimateTransmissionCapacity_Params_Data>;

  Remoter_EstimateTransmissionCapacity_Params_Data();
  ~Remoter_EstimateTransmissionCapacity_Params_Data() = delete;
};
static_assert(sizeof(Remoter_EstimateTransmissionCapacity_Params_Data) == 8,
              "Bad sizeof(Remoter_EstimateTransmissionCapacity_Params_Data)");
class  Remoter_EstimateTransmissionCapacity_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double rate;

 private:
  friend class mojo::internal::MessageFragment<Remoter_EstimateTransmissionCapacity_ResponseParams_Data>;

  Remoter_EstimateTransmissionCapacity_ResponseParams_Data();
  ~Remoter_EstimateTransmissionCapacity_ResponseParams_Data() = delete;
};
static_assert(sizeof(Remoter_EstimateTransmissionCapacity_ResponseParams_Data) == 16,
              "Bad sizeof(Remoter_EstimateTransmissionCapacity_ResponseParams_Data)");
class  RemotingSource_OnSinkAvailable_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::RemotingSinkMetadata_Data> metadata;

 private:
  friend class mojo::internal::MessageFragment<RemotingSource_OnSinkAvailable_Params_Data>;

  RemotingSource_OnSinkAvailable_Params_Data();
  ~RemotingSource_OnSinkAvailable_Params_Data() = delete;
};
static_assert(sizeof(RemotingSource_OnSinkAvailable_Params_Data) == 16,
              "Bad sizeof(RemotingSource_OnSinkAvailable_Params_Data)");
class  RemotingSource_OnSinkGone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<RemotingSource_OnSinkGone_Params_Data>;

  RemotingSource_OnSinkGone_Params_Data();
  ~RemotingSource_OnSinkGone_Params_Data() = delete;
};
static_assert(sizeof(RemotingSource_OnSinkGone_Params_Data) == 8,
              "Bad sizeof(RemotingSource_OnSinkGone_Params_Data)");
class  RemotingSource_OnStarted_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<RemotingSource_OnStarted_Params_Data>;

  RemotingSource_OnStarted_Params_Data();
  ~RemotingSource_OnStarted_Params_Data() = delete;
};
static_assert(sizeof(RemotingSource_OnStarted_Params_Data) == 8,
              "Bad sizeof(RemotingSource_OnStarted_Params_Data)");
class  RemotingSource_OnStartFailed_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reason;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RemotingSource_OnStartFailed_Params_Data>;

  RemotingSource_OnStartFailed_Params_Data();
  ~RemotingSource_OnStartFailed_Params_Data() = delete;
};
static_assert(sizeof(RemotingSource_OnStartFailed_Params_Data) == 16,
              "Bad sizeof(RemotingSource_OnStartFailed_Params_Data)");
class  RemotingSource_OnMessageFromSink_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> message;

 private:
  friend class mojo::internal::MessageFragment<RemotingSource_OnMessageFromSink_Params_Data>;

  RemotingSource_OnMessageFromSink_Params_Data();
  ~RemotingSource_OnMessageFromSink_Params_Data() = delete;
};
static_assert(sizeof(RemotingSource_OnMessageFromSink_Params_Data) == 16,
              "Bad sizeof(RemotingSource_OnMessageFromSink_Params_Data)");
class  RemotingSource_OnStopped_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reason;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RemotingSource_OnStopped_Params_Data>;

  RemotingSource_OnStopped_Params_Data();
  ~RemotingSource_OnStopped_Params_Data() = delete;
};
static_assert(sizeof(RemotingSource_OnStopped_Params_Data) == 16,
              "Bad sizeof(RemotingSource_OnStopped_Params_Data)");
class  Remotee_OnRemotingSinkReady_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data sink;

 private:
  friend class mojo::internal::MessageFragment<Remotee_OnRemotingSinkReady_Params_Data>;

  Remotee_OnRemotingSinkReady_Params_Data();
  ~Remotee_OnRemotingSinkReady_Params_Data() = delete;
};
static_assert(sizeof(Remotee_OnRemotingSinkReady_Params_Data) == 16,
              "Bad sizeof(Remotee_OnRemotingSinkReady_Params_Data)");
class  Remotee_SendMessageToSource_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> message;

 private:
  friend class mojo::internal::MessageFragment<Remotee_SendMessageToSource_Params_Data>;

  Remotee_SendMessageToSource_Params_Data();
  ~Remotee_SendMessageToSource_Params_Data() = delete;
};
static_assert(sizeof(Remotee_SendMessageToSource_Params_Data) == 16,
              "Bad sizeof(Remotee_SendMessageToSource_Params_Data)");
class  Remotee_StartDataStreams_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data audio_stream;
  mojo::internal::Interface_Data video_stream;

 private:
  friend class mojo::internal::MessageFragment<Remotee_StartDataStreams_Params_Data>;

  Remotee_StartDataStreams_Params_Data();
  ~Remotee_StartDataStreams_Params_Data() = delete;
};
static_assert(sizeof(Remotee_StartDataStreams_Params_Data) == 24,
              "Bad sizeof(Remotee_StartDataStreams_Params_Data)");
class  Remotee_OnFlushUntil_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t audio_frame_count;
  uint32_t video_frame_count;

 private:
  friend class mojo::internal::MessageFragment<Remotee_OnFlushUntil_Params_Data>;

  Remotee_OnFlushUntil_Params_Data();
  ~Remotee_OnFlushUntil_Params_Data() = delete;
};
static_assert(sizeof(Remotee_OnFlushUntil_Params_Data) == 16,
              "Bad sizeof(Remotee_OnFlushUntil_Params_Data)");
class  Remotee_OnVideoNaturalSizeChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> size;

 private:
  friend class mojo::internal::MessageFragment<Remotee_OnVideoNaturalSizeChange_Params_Data>;

  Remotee_OnVideoNaturalSizeChange_Params_Data();
  ~Remotee_OnVideoNaturalSizeChange_Params_Data() = delete;
};
static_assert(sizeof(Remotee_OnVideoNaturalSizeChange_Params_Data) == 16,
              "Bad sizeof(Remotee_OnVideoNaturalSizeChange_Params_Data)");
class  RemotingSink_OnMessageFromSource_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> message;

 private:
  friend class mojo::internal::MessageFragment<RemotingSink_OnMessageFromSource_Params_Data>;

  RemotingSink_OnMessageFromSource_Params_Data();
  ~RemotingSink_OnMessageFromSource_Params_Data() = delete;
};
static_assert(sizeof(RemotingSink_OnMessageFromSource_Params_Data) == 16,
              "Bad sizeof(RemotingSink_OnMessageFromSource_Params_Data)");
class  RemotingDataStreamReceiver_InitializeDataPipe_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data data_pipe;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RemotingDataStreamReceiver_InitializeDataPipe_Params_Data>;

  RemotingDataStreamReceiver_InitializeDataPipe_Params_Data();
  ~RemotingDataStreamReceiver_InitializeDataPipe_Params_Data() = delete;
};
static_assert(sizeof(RemotingDataStreamReceiver_InitializeDataPipe_Params_Data) == 16,
              "Bad sizeof(RemotingDataStreamReceiver_InitializeDataPipe_Params_Data)");
class  RemotingDataStreamReceiver_ReceiveFrame_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t frame_count;
  uint8_t pad0_[4];
  ::media::mojom::internal::DecoderBuffer_Data buffer;

 private:
  friend class mojo::internal::MessageFragment<RemotingDataStreamReceiver_ReceiveFrame_Params_Data>;

  RemotingDataStreamReceiver_ReceiveFrame_Params_Data();
  ~RemotingDataStreamReceiver_ReceiveFrame_Params_Data() = delete;
};
static_assert(sizeof(RemotingDataStreamReceiver_ReceiveFrame_Params_Data) == 32,
              "Bad sizeof(RemotingDataStreamReceiver_ReceiveFrame_Params_Data)");
class  RemotingDataStreamReceiver_FlushUntil_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t frame_count;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RemotingDataStreamReceiver_FlushUntil_Params_Data>;

  RemotingDataStreamReceiver_FlushUntil_Params_Data();
  ~RemotingDataStreamReceiver_FlushUntil_Params_Data() = delete;
};
static_assert(sizeof(RemotingDataStreamReceiver_FlushUntil_Params_Data) == 16,
              "Bad sizeof(RemotingDataStreamReceiver_FlushUntil_Params_Data)");

}  // namespace internal


class RemoterFactory_Create_ParamsDataView {
 public:
  RemoterFactory_Create_ParamsDataView() = default;

  RemoterFactory_Create_ParamsDataView(
      internal::RemoterFactory_Create_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSource() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::RemotingSourceInterfaceBase>>(
            &data_->source, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeRemoter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::RemoterInterfaceBase>>(
            &data_->remoter, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RemoterFactory_Create_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemotingDataStreamSender_SendFrame_ParamsDataView {
 public:
  RemotingDataStreamSender_SendFrame_ParamsDataView() = default;

  RemotingDataStreamSender_SendFrame_ParamsDataView(
      internal::RemotingDataStreamSender_SendFrame_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameDataView(
      ::media::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrame(UserType* output) {
    
    auto* pointer = !data_->frame.is_null() ? &data_->frame : nullptr;
    return mojo::internal::Deserialize<::media::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::RemotingDataStreamSender_SendFrame_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemotingDataStreamSender_SendFrame_ResponseParamsDataView {
 public:
  RemotingDataStreamSender_SendFrame_ResponseParamsDataView() = default;

  RemotingDataStreamSender_SendFrame_ResponseParamsDataView(
      internal::RemotingDataStreamSender_SendFrame_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RemotingDataStreamSender_SendFrame_ResponseParams_Data* data_ = nullptr;
};


class RemotingDataStreamSender_CancelInFlightData_ParamsDataView {
 public:
  RemotingDataStreamSender_CancelInFlightData_ParamsDataView() = default;

  RemotingDataStreamSender_CancelInFlightData_ParamsDataView(
      internal::RemotingDataStreamSender_CancelInFlightData_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RemotingDataStreamSender_CancelInFlightData_Params_Data* data_ = nullptr;
};


class Remoter_Start_ParamsDataView {
 public:
  Remoter_Start_ParamsDataView() = default;

  Remoter_Start_ParamsDataView(
      internal::Remoter_Start_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Remoter_Start_Params_Data* data_ = nullptr;
};


class Remoter_StartWithPermissionAlreadyGranted_ParamsDataView {
 public:
  Remoter_StartWithPermissionAlreadyGranted_ParamsDataView() = default;

  Remoter_StartWithPermissionAlreadyGranted_ParamsDataView(
      internal::Remoter_StartWithPermissionAlreadyGranted_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Remoter_StartWithPermissionAlreadyGranted_Params_Data* data_ = nullptr;
};


class Remoter_StartDataStreams_ParamsDataView {
 public:
  Remoter_StartDataStreams_ParamsDataView() = default;

  Remoter_StartDataStreams_ParamsDataView(
      internal::Remoter_StartDataStreams_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedDataPipeConsumerHandle TakeAudioPipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->audio_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeConsumerHandle TakeVideoPipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->video_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAudioSender() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::RemotingDataStreamSenderInterfaceBase>>(
            &data_->audio_sender, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeVideoSender() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::RemotingDataStreamSenderInterfaceBase>>(
            &data_->video_sender, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Remoter_StartDataStreams_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Remoter_Stop_ParamsDataView {
 public:
  Remoter_Stop_ParamsDataView() = default;

  Remoter_Stop_ParamsDataView(
      internal::Remoter_Stop_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::media::mojom::RemotingStopReason>(
        data_value, output);
  }
  ::media::mojom::RemotingStopReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::RemotingStopReason>(data_->reason));
  }
 private:
  internal::Remoter_Stop_Params_Data* data_ = nullptr;
};


class Remoter_SendMessageToSink_ParamsDataView {
 public:
  Remoter_SendMessageToSink_ParamsDataView() = default;

  Remoter_SendMessageToSink_ParamsDataView(
      internal::Remoter_SendMessageToSink_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::Remoter_SendMessageToSink_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Remoter_EstimateTransmissionCapacity_ParamsDataView {
 public:
  Remoter_EstimateTransmissionCapacity_ParamsDataView() = default;

  Remoter_EstimateTransmissionCapacity_ParamsDataView(
      internal::Remoter_EstimateTransmissionCapacity_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Remoter_EstimateTransmissionCapacity_Params_Data* data_ = nullptr;
};


class Remoter_EstimateTransmissionCapacity_ResponseParamsDataView {
 public:
  Remoter_EstimateTransmissionCapacity_ResponseParamsDataView() = default;

  Remoter_EstimateTransmissionCapacity_ResponseParamsDataView(
      internal::Remoter_EstimateTransmissionCapacity_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double rate() const {
    return data_->rate;
  }
 private:
  internal::Remoter_EstimateTransmissionCapacity_ResponseParams_Data* data_ = nullptr;
};


class RemotingSource_OnSinkAvailable_ParamsDataView {
 public:
  RemotingSource_OnSinkAvailable_ParamsDataView() = default;

  RemotingSource_OnSinkAvailable_ParamsDataView(
      internal::RemotingSource_OnSinkAvailable_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMetadataDataView(
      ::media::mojom::RemotingSinkMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::media::mojom::RemotingSinkMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::RemotingSource_OnSinkAvailable_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemotingSource_OnSinkGone_ParamsDataView {
 public:
  RemotingSource_OnSinkGone_ParamsDataView() = default;

  RemotingSource_OnSinkGone_ParamsDataView(
      internal::RemotingSource_OnSinkGone_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RemotingSource_OnSinkGone_Params_Data* data_ = nullptr;
};


class RemotingSource_OnStarted_ParamsDataView {
 public:
  RemotingSource_OnStarted_ParamsDataView() = default;

  RemotingSource_OnStarted_ParamsDataView(
      internal::RemotingSource_OnStarted_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RemotingSource_OnStarted_Params_Data* data_ = nullptr;
};


class RemotingSource_OnStartFailed_ParamsDataView {
 public:
  RemotingSource_OnStartFailed_ParamsDataView() = default;

  RemotingSource_OnStartFailed_ParamsDataView(
      internal::RemotingSource_OnStartFailed_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::media::mojom::RemotingStartFailReason>(
        data_value, output);
  }
  ::media::mojom::RemotingStartFailReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::RemotingStartFailReason>(data_->reason));
  }
 private:
  internal::RemotingSource_OnStartFailed_Params_Data* data_ = nullptr;
};


class RemotingSource_OnMessageFromSink_ParamsDataView {
 public:
  RemotingSource_OnMessageFromSink_ParamsDataView() = default;

  RemotingSource_OnMessageFromSink_ParamsDataView(
      internal::RemotingSource_OnMessageFromSink_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::RemotingSource_OnMessageFromSink_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemotingSource_OnStopped_ParamsDataView {
 public:
  RemotingSource_OnStopped_ParamsDataView() = default;

  RemotingSource_OnStopped_ParamsDataView(
      internal::RemotingSource_OnStopped_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::media::mojom::RemotingStopReason>(
        data_value, output);
  }
  ::media::mojom::RemotingStopReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::RemotingStopReason>(data_->reason));
  }
 private:
  internal::RemotingSource_OnStopped_Params_Data* data_ = nullptr;
};


class Remotee_OnRemotingSinkReady_ParamsDataView {
 public:
  Remotee_OnRemotingSinkReady_ParamsDataView() = default;

  Remotee_OnRemotingSinkReady_ParamsDataView(
      internal::Remotee_OnRemotingSinkReady_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSink() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::RemotingSinkInterfaceBase>>(
            &data_->sink, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Remotee_OnRemotingSinkReady_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Remotee_SendMessageToSource_ParamsDataView {
 public:
  Remotee_SendMessageToSource_ParamsDataView() = default;

  Remotee_SendMessageToSource_ParamsDataView(
      internal::Remotee_SendMessageToSource_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::Remotee_SendMessageToSource_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Remotee_StartDataStreams_ParamsDataView {
 public:
  Remotee_StartDataStreams_ParamsDataView() = default;

  Remotee_StartDataStreams_ParamsDataView(
      internal::Remotee_StartDataStreams_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeAudioStream() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::RemotingDataStreamReceiverInterfaceBase>>(
            &data_->audio_stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeVideoStream() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::RemotingDataStreamReceiverInterfaceBase>>(
            &data_->video_stream, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Remotee_StartDataStreams_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Remotee_OnFlushUntil_ParamsDataView {
 public:
  Remotee_OnFlushUntil_ParamsDataView() = default;

  Remotee_OnFlushUntil_ParamsDataView(
      internal::Remotee_OnFlushUntil_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t audio_frame_count() const {
    return data_->audio_frame_count;
  }
  uint32_t video_frame_count() const {
    return data_->video_frame_count;
  }
 private:
  internal::Remotee_OnFlushUntil_Params_Data* data_ = nullptr;
};


class Remotee_OnVideoNaturalSizeChange_ParamsDataView {
 public:
  Remotee_OnVideoNaturalSizeChange_ParamsDataView() = default;

  Remotee_OnVideoNaturalSizeChange_ParamsDataView(
      internal::Remotee_OnVideoNaturalSizeChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::Remotee_OnVideoNaturalSizeChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemotingSink_OnMessageFromSource_ParamsDataView {
 public:
  RemotingSink_OnMessageFromSource_ParamsDataView() = default;

  RemotingSink_OnMessageFromSource_ParamsDataView(
      internal::RemotingSink_OnMessageFromSource_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::RemotingSink_OnMessageFromSource_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemotingDataStreamReceiver_InitializeDataPipe_ParamsDataView {
 public:
  RemotingDataStreamReceiver_InitializeDataPipe_ParamsDataView() = default;

  RemotingDataStreamReceiver_InitializeDataPipe_ParamsDataView(
      internal::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedDataPipeConsumerHandle TakeDataPipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->data_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RemotingDataStreamReceiver_InitializeDataPipe_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemotingDataStreamReceiver_ReceiveFrame_ParamsDataView {
 public:
  RemotingDataStreamReceiver_ReceiveFrame_ParamsDataView() = default;

  RemotingDataStreamReceiver_ReceiveFrame_ParamsDataView(
      internal::RemotingDataStreamReceiver_ReceiveFrame_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t frame_count() const {
    return data_->frame_count;
  }
  inline void GetBufferDataView(
      ::media::mojom::DecoderBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuffer(UserType* output) {
    
    auto* pointer = !data_->buffer.is_null() ? &data_->buffer : nullptr;
    return mojo::internal::Deserialize<::media::mojom::DecoderBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::RemotingDataStreamReceiver_ReceiveFrame_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemotingDataStreamReceiver_FlushUntil_ParamsDataView {
 public:
  RemotingDataStreamReceiver_FlushUntil_ParamsDataView() = default;

  RemotingDataStreamReceiver_FlushUntil_ParamsDataView(
      internal::RemotingDataStreamReceiver_FlushUntil_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t frame_count() const {
    return data_->frame_count;
  }
 private:
  internal::RemotingDataStreamReceiver_FlushUntil_Params_Data* data_ = nullptr;
};



inline void RemotingDataStreamSender_SendFrame_ParamsDataView::GetFrameDataView(
    ::media::mojom::DecoderBufferDataView* output) {
  auto pointer = &data_->frame;
  *output = ::media::mojom::DecoderBufferDataView(pointer, message_);
}














inline void Remoter_SendMessageToSink_ParamsDataView::GetMessageDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->message.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}






inline void RemotingSource_OnSinkAvailable_ParamsDataView::GetMetadataDataView(
    ::media::mojom::RemotingSinkMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = ::media::mojom::RemotingSinkMetadataDataView(pointer, message_);
}








inline void RemotingSource_OnMessageFromSink_ParamsDataView::GetMessageDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->message.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}






inline void Remotee_SendMessageToSource_ParamsDataView::GetMessageDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->message.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}






inline void Remotee_OnVideoNaturalSizeChange_ParamsDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void RemotingSink_OnMessageFromSource_ParamsDataView::GetMessageDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->message.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}




inline void RemotingDataStreamReceiver_ReceiveFrame_ParamsDataView::GetBufferDataView(
    ::media::mojom::DecoderBufferDataView* output) {
  auto pointer = &data_->buffer;
  *output = ::media::mojom::DecoderBufferDataView(pointer, message_);
}





}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_REMOTING_MOJOM_PARAMS_DATA_H_