// media/mojo/mojom/output_protection.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('media.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.OutputProtectionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.OutputProtection.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.OutputProtectionInterface }
 */
media.mojom.OutputProtectionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.OutputProtectionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.OutputProtectionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.OutputProtectionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
        linkMask: !number,
        protectionMask: !number,
   *  }>}
   */

  queryStatus() {
    return this.proxy.sendMessage(
        0,
        media.mojom.OutputProtection_QueryStatus_ParamsSpec.$,
        media.mojom.OutputProtection_QueryStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } desiredProtectionMask
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  enableProtection(
      desiredProtectionMask) {
    return this.proxy.sendMessage(
        1,
        media.mojom.OutputProtection_EnableProtection_ParamsSpec.$,
        media.mojom.OutputProtection_EnableProtection_ResponseParamsSpec.$,
        [
          desiredProtectionMask
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OutputProtection
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.OutputProtectionReceiver = class {
  /**
   * @param {!media.mojom.OutputProtectionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.OutputProtectionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.OutputProtectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.OutputProtectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.OutputProtection_QueryStatus_ParamsSpec.$,
        media.mojom.OutputProtection_QueryStatus_ResponseParamsSpec.$,
        impl.queryStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.OutputProtection_EnableProtection_ParamsSpec.$,
        media.mojom.OutputProtection_EnableProtection_ResponseParamsSpec.$,
        impl.enableProtection.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.OutputProtection = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.OutputProtection";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.OutputProtectionRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.OutputProtectionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.OutputProtection.ProtectionTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.OutputProtection_ProtectionType = {
  
  NONE: 0,
  HDCP: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.OutputProtection.LinkTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.OutputProtection_LinkType = {
  
  NONE: 0,
  UNKNOWN: 1,
  INTERNAL: 2,
  VGA: 4,
  HDMI: 8,
  DVI: 16,
  DISPLAYPORT: 32,
  NETWORK: 64,
  MIN_VALUE: 0,
  MAX_VALUE: 64,
};

/**
 * An object which receives request messages for the OutputProtection
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.OutputProtectionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.OutputProtectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.OutputProtectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queryStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.OutputProtection_QueryStatus_ParamsSpec.$,
        media.mojom.OutputProtection_QueryStatus_ResponseParamsSpec.$,
        this.queryStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableProtection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.OutputProtection_EnableProtection_ParamsSpec.$,
        media.mojom.OutputProtection_EnableProtection_ResponseParamsSpec.$,
        this.enableProtection.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.OutputProtection_QueryStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.OutputProtection_QueryStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.OutputProtection_EnableProtection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.OutputProtection_EnableProtection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.OutputProtection_QueryStatus_ParamsSpec.$,
    'OutputProtection_QueryStatus_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.OutputProtection_QueryStatus_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.OutputProtection_QueryStatus_ResponseParamsSpec.$,
    'OutputProtection_QueryStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'linkMask', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protectionMask', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
media.mojom.OutputProtection_QueryStatus_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !number } */
    this.linkMask;
    /** @export { !number } */
    this.protectionMask;
  }
};



mojo.internal.Struct(
    media.mojom.OutputProtection_EnableProtection_ParamsSpec.$,
    'OutputProtection_EnableProtection_Params',
    [
      mojo.internal.StructField(
        'desiredProtectionMask', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.OutputProtection_EnableProtection_Params = class {
  constructor() {
    /** @export { !number } */
    this.desiredProtectionMask;
  }
};



mojo.internal.Struct(
    media.mojom.OutputProtection_EnableProtection_ResponseParamsSpec.$,
    'OutputProtection_EnableProtection_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.OutputProtection_EnableProtection_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};

