// media/mojo/mojom/media_types.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  ExportedSharedImage as gpu_mojom_ExportedSharedImage,
  ExportedSharedImageSpec as gpu_mojom_ExportedSharedImageSpec
} from '../../../gpu/ipc/common/exported_shared_image.mojom.m.js';

import {
  SyncToken as gpu_mojom_SyncToken,
  SyncTokenSpec as gpu_mojom_SyncTokenSpec
} from '../../../gpu/ipc/common/sync_token.mojom.m.js';

import {
  ByteString as mojoBase_mojom_ByteString,
  ByteStringSpec as mojoBase_mojom_ByteStringSpec
} from '../../../mojo/public/mojom/base/byte_string.mojom.m.js';

import {
  ReadOnlySharedMemoryRegion as mojoBase_mojom_ReadOnlySharedMemoryRegion,
  ReadOnlySharedMemoryRegionSpec as mojoBase_mojom_ReadOnlySharedMemoryRegionSpec
} from '../../../mojo/public/mojom/base/shared_memory.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  ListValue as mojoBase_mojom_ListValue,
  ListValueSpec as mojoBase_mojom_ListValueSpec,
  Value as mojoBase_mojom_Value,
  ValueSpec as mojoBase_mojom_ValueSpec
} from '../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  GpuMemoryBufferHandle as gfx_mojom_GpuMemoryBufferHandle,
  GpuMemoryBufferHandleSpec as gfx_mojom_GpuMemoryBufferHandleSpec
} from '../../../ui/gfx/mojom/buffer_types.mojom.m.js';

import {
  ColorSpace as gfx_mojom_ColorSpace,
  ColorSpaceSpec as gfx_mojom_ColorSpaceSpec
} from '../../../ui/gfx/mojom/color_space.mojom.m.js';

import {
  HDRMetadata as gfx_mojom_HDRMetadata,
  HDRMetadataSpec as gfx_mojom_HDRMetadataSpec
} from '../../../ui/gfx/mojom/hdr_metadata.mojom.m.js';

import {
  EncryptionPattern as media_mojom_EncryptionPattern,
  EncryptionPatternSpec as media_mojom_EncryptionPatternSpec
} from './encryption_pattern.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AudioCodecSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AudioCodec = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AudioCodecProfileSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AudioCodecProfile = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BufferingStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BufferingState = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BufferingStateChangeReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BufferingStateChangeReason = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ChannelLayoutSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ChannelLayout = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaContentTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaContentType = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const OutputDeviceStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const OutputDeviceStatus = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SampleFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SampleFormat = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoCodecSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoCodec = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoCodecProfileSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoCodecProfile = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoPixelFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoPixelFormat = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoDecoderTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoDecoderType = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AudioDecoderTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AudioDecoderType = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoRotationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoRotation = {
  
  kVideoRotation0: 0,
  kVideoRotation90: 1,
  kVideoRotation180: 2,
  kVideoRotation270: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FullscreenVideoStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FullscreenVideoStatus = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WaitingReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WaitingReason = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WatchTimeKeySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WatchTimeKey = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaContainerNameSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaContainerName = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaStatusStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaStatusState = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EncryptionSchemeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EncryptionScheme = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EncryptionTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EncryptionType = {
  
  kNone: 0,
  kClear: 1,
  kEncrypted: 2,
  kEncryptedWithClearLead: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SVCScalabilityModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SVCScalabilityMode = {
  
  kL1T1: 0,
  kL1T2: 1,
  kL1T3: 2,
  kL2T1: 3,
  kL2T2: 4,
  kL2T3: 5,
  kL3T1: 6,
  kL3T2: 7,
  kL3T3: 8,
  kL2T1h: 9,
  kL2T2h: 10,
  kL2T3h: 11,
  kS2T1: 12,
  kS2T2: 13,
  kS2T3: 14,
  kS2T1h: 15,
  kS2T2h: 16,
  kS2T3h: 17,
  kS3T1: 18,
  kS3T2: 19,
  kS3T3: 20,
  kS3T1h: 21,
  kS3T2h: 22,
  kS3T3h: 23,
  kL2T1Key: 24,
  kL2T2Key: 25,
  kL2T2KeyShift: 26,
  kL2T3Key: 27,
  kL2T3KeyShift: 28,
  kL3T1Key: 29,
  kL3T2Key: 30,
  kL3T2KeyShift: 31,
  kL3T3Key: 32,
  kL3T3KeyShift: 33,
  kL3T1h: 34,
  kL3T2h: 35,
  kL3T3h: 36,
  MIN_VALUE: 0,
  MAX_VALUE: 36,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SVCInterLayerPredModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SVCInterLayerPredMode = {
  
  kOff: 0,
  kOn: 1,
  kOnKeyPic: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CdmSessionClosedReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CdmSessionClosedReason = {
  
  kInternalError: 0,
  kClose: 1,
  kReleaseAcknowledged: 2,
  kHardwareContextReset: 3,
  kResourceEvicted: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EffectStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EffectState = {
  
  kUnknown: 0,
  kDisabled: 1,
  kEnabled: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaStreamTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaStreamType = {
  
  kLocalElementCapture: 0,
  kLocalDeviceCapture: 1,
  kLocalTabCapture: 2,
  kLocalDesktopCapture: 3,
  kLocalDisplayCapture: 4,
  kRemote: 5,
  kNone: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const InputStreamErrorCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const InputStreamErrorCode = {
  
  kUnknown: 0,
  kSystemPermissions: 1,
  kDeviceInUse: 2,
  kSocketError: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RendererTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RendererType = {
  
  kRendererImpl: 0,
  kMojo: 1,
  kCourier: 3,
  kFlinging: 4,
  kCast: 5,
  kMediaFoundation: 6,
  kRemoting: 8,
  kCastStreaming: 9,
  kContentEmbedderDefined: 10,
  kTest: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DemuxerTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DemuxerType = {
  
  kUnknownDemuxer: 0,
  kMockDemuxer: 1,
  kFFmpegDemuxer: 2,
  kChunkDemuxer: 3,
  kFrameInjectingDemuxer: 5,
  kStreamProviderDemuxer: 6,
  kManifestDemuxer: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CreateCdmStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CreateCdmStatus = {
  
  kSuccess: 0,
  kUnknownError: 1,
  kCdmCreationAborted: 2,
  kCreateCdmFuncNotAvailable: 4,
  kCdmHelperCreationFailed: 5,
  kGetCdmPrefDataFailed: 6,
  kGetCdmOriginIdFailed: 7,
  kInitCdmFailed: 8,
  kCdmFactoryCreationFailed: 9,
  kCdmNotSupported: 10,
  kInvalidCdmConfig: 11,
  kUnsupportedKeySystem: 12,
  kDisconnectionError: 13,
  kNotAllowedOnUniqueOrigin: 14,
  kMediaCryptoNotAvailable: 16,
  kNoMoreInstances: 17,
  kInsufficientGpuResources: 18,
  kCrOsVerifiedAccessDisabled: 19,
  kCrOsRemoteFactoryCreationFailed: 20,
  kAndroidMediaDrmIllegalArgument: 21,
  kAndroidMediaDrmIllegalState: 22,
  kAndroidFailedL1SecurityLevel: 23,
  kAndroidFailedL3SecurityLevel: 24,
  kAndroidFailedSecurityOrigin: 25,
  kAndroidFailedMediaCryptoSession: 26,
  kAndroidFailedToStartProvisioning: 27,
  kAndroidFailedMediaCryptoCreate: 28,
  kAndroidUnsupportedMediaCryptoScheme: 29,
  MIN_VALUE: 0,
  MAX_VALUE: 29,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AutoPipReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AutoPipReason = {
  
  kUnknown: 0,
  kVideoConferencing: 1,
  kMediaPlayback: 2,
  kBrowserInitiated: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaLogRecordSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoTransformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoAspectRatioSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoColorSpaceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoDecoderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SubsampleEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DecryptConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DecoderBufferSideDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DataDecoderBufferSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EosDecoderBufferSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioBufferSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CaptureVersionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoFrameMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoFrameSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EosVideoFrameDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedMemoryVideoFrameDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GpuMemoryBufferSharedImageVideoFrameDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedImageVideoFrameDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OpaqueVideoFrameDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PipelineStatisticsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PredictionFeaturesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PredictionTargetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioPipelineInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoPipelineInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StatusDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EncoderStatusSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DecoderStatusSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PipelineStatusSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AutoPipInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const DecoderBufferSideDataNextConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const DecoderBufferSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const VideoFrameDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MediaLogRecordSpec.$,
    'MediaLogRecord',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaLogRecord {
  constructor() {
  }
}



mojo.internal.Struct(
    VideoTransformationSpec.$,
    'VideoTransformation',
    [
      mojo.internal.StructField(
        'rotation', 0,
        0,
        VideoRotationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mirrored', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoTransformation {
  constructor() {
    /** @type { !VideoRotation } */
    this.rotation;
    /** @type { !boolean } */
    this.mirrored;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoAspectRatio_TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoAspectRatio_Type = {
  
  kDisplay: 0,
  kPixel: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    VideoAspectRatioSpec.$,
    'VideoAspectRatio',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        VideoAspectRatio_TypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoAspectRatio {
  constructor() {
    /** @type { !VideoAspectRatio_Type } */
    this.type;
    /** @type { !number } */
    this.value;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoColorSpace_PrimaryIDSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoColorSpace_PrimaryID = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoColorSpace_TransferIDSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoColorSpace_TransferID = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoColorSpace_MatrixIDSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoColorSpace_MatrixID = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoColorSpace_RangeIDSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoColorSpace_RangeID = {
  
};


mojo.internal.Struct(
    VideoColorSpaceSpec.$,
    'VideoColorSpace',
    [
      mojo.internal.StructField(
        'primaries', 0,
        0,
        VideoColorSpace_PrimaryIDSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transfer', 4,
        0,
        VideoColorSpace_TransferIDSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matrix', 8,
        0,
        VideoColorSpace_MatrixIDSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'range', 12,
        0,
        VideoColorSpace_RangeIDSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoColorSpace {
  constructor() {
    /** @type { !VideoColorSpace_PrimaryID } */
    this.primaries;
    /** @type { !VideoColorSpace_TransferID } */
    this.transfer;
    /** @type { !VideoColorSpace_MatrixID } */
    this.matrix;
    /** @type { !VideoColorSpace_RangeID } */
    this.range;
  }
}



mojo.internal.Struct(
    AudioDecoderConfigSpec.$,
    'AudioDecoderConfig',
    [
      mojo.internal.StructField(
        'codec', 0,
        0,
        AudioCodecSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampleFormat', 4,
        0,
        SampleFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelLayout', 8,
        0,
        ChannelLayoutSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'samplesPerSecond', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extraData', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encryptionScheme', 24,
        0,
        EncryptionSchemeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'seekPreroll', 32,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codecDelay', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'profile', 40,
        0,
        AudioCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetOutputChannelLayout', 44,
        0,
        ChannelLayoutSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetOutputSampleFormat', 48,
        0,
        SampleFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldDiscardDecoderDelay', 52,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class AudioDecoderConfig {
  constructor() {
    /** @type { !AudioCodec } */
    this.codec;
    /** @type { !SampleFormat } */
    this.sampleFormat;
    /** @type { !ChannelLayout } */
    this.channelLayout;
    /** @type { !number } */
    this.samplesPerSecond;
    /** @type { !Array<!number> } */
    this.extraData;
    /** @type { !EncryptionScheme } */
    this.encryptionScheme;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekPreroll;
    /** @type { !number } */
    this.codecDelay;
    /** @type { !AudioCodecProfile } */
    this.profile;
    /** @type { !ChannelLayout } */
    this.targetOutputChannelLayout;
    /** @type { !SampleFormat } */
    this.targetOutputSampleFormat;
    /** @type { !boolean } */
    this.shouldDiscardDecoderDelay;
  }
}



mojo.internal.Struct(
    VideoDecoderConfigSpec.$,
    'VideoDecoderConfig',
    [
      mojo.internal.StructField(
        'codec', 0,
        0,
        VideoCodecSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'profile', 4,
        0,
        VideoCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'level', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasAlpha', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transformation', 16,
        0,
        VideoTransformationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codedSize', 24,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'visibleRect', 32,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'naturalSize', 40,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'aspectRatio', 48,
        0,
        VideoAspectRatioSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extraData', 56,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encryptionScheme', 64,
        0,
        EncryptionSchemeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'colorSpaceInfo', 72,
        0,
        VideoColorSpaceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hdrMetadata', 80,
        0,
        gfx_mojom_HDRMetadataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 96],]);



/**
 * @record
 */
export class VideoDecoderConfig {
  constructor() {
    /** @type { !VideoCodec } */
    this.codec;
    /** @type { !VideoCodecProfile } */
    this.profile;
    /** @type { !number } */
    this.level;
    /** @type { !boolean } */
    this.hasAlpha;
    /** @type { !VideoTransformation } */
    this.transformation;
    /** @type { !gfx_mojom_Size } */
    this.codedSize;
    /** @type { !gfx_mojom_Rect } */
    this.visibleRect;
    /** @type { !gfx_mojom_Size } */
    this.naturalSize;
    /** @type { !VideoAspectRatio } */
    this.aspectRatio;
    /** @type { !Array<!number> } */
    this.extraData;
    /** @type { !EncryptionScheme } */
    this.encryptionScheme;
    /** @type { !VideoColorSpace } */
    this.colorSpaceInfo;
    /** @type { (gfx_mojom_HDRMetadata|undefined) } */
    this.hdrMetadata;
  }
}



mojo.internal.Struct(
    SubsampleEntrySpec.$,
    'SubsampleEntry',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SubsampleEntry {
  constructor() {
  }
}



mojo.internal.Struct(
    DecryptConfigSpec.$,
    'DecryptConfig',
    [
      mojo.internal.StructField(
        'encryptionScheme', 0,
        0,
        EncryptionSchemeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyId', 8,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'iv', 16,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subsamples', 24,
        0,
        mojo.internal.Array(SubsampleEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encryptionPattern', 32,
        0,
        media_mojom_EncryptionPatternSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class DecryptConfig {
  constructor() {
    /** @type { !EncryptionScheme } */
    this.encryptionScheme;
    /** @type { !mojoBase_mojom_ByteString } */
    this.keyId;
    /** @type { !mojoBase_mojom_ByteString } */
    this.iv;
    /** @type { !Array<!SubsampleEntry> } */
    this.subsamples;
    /** @type { (media_mojom_EncryptionPattern|undefined) } */
    this.encryptionPattern;
  }
}



mojo.internal.Struct(
    DecoderBufferSideDataSpec.$,
    'DecoderBufferSideData',
    [
      mojo.internal.StructField(
        'spatialLayers', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alphaData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'secureHandle', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frontDiscard', 24,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'backDiscard', 32,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class DecoderBufferSideData {
  constructor() {
    /** @type { !Array<!number> } */
    this.spatialLayers;
    /** @type { !Array<!number> } */
    this.alphaData;
    /** @type { !bigint } */
    this.secureHandle;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.frontDiscard;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.backDiscard;
  }
}



mojo.internal.Struct(
    DataDecoderBufferSpec.$,
    'DataDecoderBuffer',
    [
      mojo.internal.StructField(
        'timestamp', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'duration', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataSize', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isKeyFrame', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decryptConfig', 24,
        0,
        DecryptConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sideData', 32,
        0,
        DecoderBufferSideDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class DataDecoderBuffer {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timestamp;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.duration;
    /** @type { !number } */
    this.dataSize;
    /** @type { !boolean } */
    this.isKeyFrame;
    /** @type { (DecryptConfig|undefined) } */
    this.decryptConfig;
    /** @type { (DecoderBufferSideData|undefined) } */
    this.sideData;
  }
}



mojo.internal.Struct(
    EosDecoderBufferSpec.$,
    'EosDecoderBuffer',
    [
      mojo.internal.StructField(
        'nextConfig', 0,
        0,
        DecoderBufferSideDataNextConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EosDecoderBuffer {
  constructor() {
    /** @type { (DecoderBufferSideDataNextConfig|undefined) } */
    this.nextConfig;
  }
}



mojo.internal.Struct(
    AudioBufferSpec.$,
    'AudioBuffer',
    [
      mojo.internal.StructField(
        'sampleFormat', 0,
        0,
        SampleFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelLayout', 4,
        0,
        ChannelLayoutSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelCount', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampleRate', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameCount', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endOfStream', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestamp', 24,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 32,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class AudioBuffer {
  constructor() {
    /** @type { !SampleFormat } */
    this.sampleFormat;
    /** @type { !ChannelLayout } */
    this.channelLayout;
    /** @type { !number } */
    this.channelCount;
    /** @type { !number } */
    this.sampleRate;
    /** @type { !number } */
    this.frameCount;
    /** @type { !boolean } */
    this.endOfStream;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timestamp;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    CaptureVersionSpec.$,
    'CaptureVersion',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subCapture', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CaptureVersion {
  constructor() {
    /** @type { !number } */
    this.source;
    /** @type { !number } */
    this.subCapture;
  }
}



mojo.internal.Struct(
    VideoFrameMetadataSpec.$,
    'VideoFrameMetadata',
    [
      mojo.internal.StructField(
        'allowOverlay', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'captureBeginTime', 8,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'captureEndTime', 16,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasCaptureCounter', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'captureCounter', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'captureUpdateRect', 24,
        0,
        gfx_mojom_RectSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceSize', 32,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'regionCaptureRect', 40,
        0,
        gfx_mojom_RectSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'captureVersion', 48,
        0,
        CaptureVersionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'copyRequired', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endOfStream', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameDuration', 56,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasFrameRate', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameRate', 64,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interactiveContent', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referenceTime', 72,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'readLockFencesEnabled', 0,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transformation', 80,
        0,
        VideoTransformationSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inSurfaceView', 0,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wantsPromotionHint', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protectedVideo', 1,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hwProtected', 1,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'needsDetiling', 1,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isWebgpuCompatible', 1,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trackingToken', 88,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'powerEfficient', 1,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasDeviceScaleFactor', 1,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceScaleFactor', 96,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasPageScaleFactor', 1,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pageScaleFactor', 104,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasRootScrollOffsetX', 2,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rootScrollOffsetX', 112,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasRootScrollOffsetY', 2,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rootScrollOffsetY', 120,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasTopControlsVisibleHeight', 2,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topControlsVisibleHeight', 128,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decodeBeginTime', 136,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decodeEndTime', 144,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'processingTime', 152,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasRtpTimestamp', 2,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rtpTimestamp', 160,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiveTime', 168,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wallclockFrameDuration', 176,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frame_sequence_$flag', 2,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "frame_sequence_$value",
          originalFieldName: "frameSequence",
        }
      ),
      mojo.internal.StructField(
        'frame_sequence_$value', 184,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "frameSequence",
        }
      ),
      mojo.internal.StructField(
        'source_id_$flag', 2,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "source_id_$value",
          originalFieldName: "sourceId",
        }
      ),
      mojo.internal.StructField(
        'source_id_$value', 192,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "sourceId",
        }
      ),
      mojo.internal.StructField(
        'backgroundBlur', 200,
        0,
        EffectStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 216],]);



/**
 * @record
 */
export class VideoFrameMetadata {
  constructor() {
    /** @type { !boolean } */
    this.allowOverlay;
    /** @type { (mojoBase_mojom_TimeTicks|undefined) } */
    this.captureBeginTime;
    /** @type { (mojoBase_mojom_TimeTicks|undefined) } */
    this.captureEndTime;
    /** @type { !boolean } */
    this.hasCaptureCounter;
    /** @type { !number } */
    this.captureCounter;
    /** @type { (gfx_mojom_Rect|undefined) } */
    this.captureUpdateRect;
    /** @type { (gfx_mojom_Size|undefined) } */
    this.sourceSize;
    /** @type { (gfx_mojom_Rect|undefined) } */
    this.regionCaptureRect;
    /** @type { !CaptureVersion } */
    this.captureVersion;
    /** @type { !boolean } */
    this.copyRequired;
    /** @type { !boolean } */
    this.endOfStream;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.frameDuration;
    /** @type { !boolean } */
    this.hasFrameRate;
    /** @type { !number } */
    this.frameRate;
    /** @type { !boolean } */
    this.interactiveContent;
    /** @type { (mojoBase_mojom_TimeTicks|undefined) } */
    this.referenceTime;
    /** @type { !boolean } */
    this.readLockFencesEnabled;
    /** @type { (VideoTransformation|undefined) } */
    this.transformation;
    /** @type { !boolean } */
    this.inSurfaceView;
    /** @type { !boolean } */
    this.wantsPromotionHint;
    /** @type { !boolean } */
    this.protectedVideo;
    /** @type { !boolean } */
    this.hwProtected;
    /** @type { !boolean } */
    this.needsDetiling;
    /** @type { !boolean } */
    this.isWebgpuCompatible;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.trackingToken;
    /** @type { !boolean } */
    this.powerEfficient;
    /** @type { !boolean } */
    this.hasDeviceScaleFactor;
    /** @type { !number } */
    this.deviceScaleFactor;
    /** @type { !boolean } */
    this.hasPageScaleFactor;
    /** @type { !number } */
    this.pageScaleFactor;
    /** @type { !boolean } */
    this.hasRootScrollOffsetX;
    /** @type { !number } */
    this.rootScrollOffsetX;
    /** @type { !boolean } */
    this.hasRootScrollOffsetY;
    /** @type { !number } */
    this.rootScrollOffsetY;
    /** @type { !boolean } */
    this.hasTopControlsVisibleHeight;
    /** @type { !number } */
    this.topControlsVisibleHeight;
    /** @type { (mojoBase_mojom_TimeTicks|undefined) } */
    this.decodeBeginTime;
    /** @type { (mojoBase_mojom_TimeTicks|undefined) } */
    this.decodeEndTime;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.processingTime;
    /** @type { !boolean } */
    this.hasRtpTimestamp;
    /** @type { !number } */
    this.rtpTimestamp;
    /** @type { (mojoBase_mojom_TimeTicks|undefined) } */
    this.receiveTime;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.wallclockFrameDuration;
    /** @type { (bigint|undefined) } */
    this.frameSequence;
    /** @type { (bigint|undefined) } */
    this.sourceId;
    /** @type { !EffectState } */
    this.backgroundBlur;
  }
}



mojo.internal.Struct(
    VideoFrameSpec.$,
    'VideoFrame',
    [
      mojo.internal.StructField(
        'format', 0,
        0,
        VideoPixelFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'codedSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'visibleRect', 16,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'naturalSize', 24,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestamp', 32,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 40,
        0,
        VideoFrameDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadata', 56,
        0,
        VideoFrameMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'colorSpace', 64,
        0,
        gfx_mojom_ColorSpaceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hdrMetadata', 72,
        0,
        gfx_mojom_HDRMetadataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 88],]);



/**
 * @record
 */
export class VideoFrame {
  constructor() {
    /** @type { !VideoPixelFormat } */
    this.format;
    /** @type { !gfx_mojom_Size } */
    this.codedSize;
    /** @type { !gfx_mojom_Rect } */
    this.visibleRect;
    /** @type { !gfx_mojom_Size } */
    this.naturalSize;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timestamp;
    /** @type { !VideoFrameData } */
    this.data;
    /** @type { !VideoFrameMetadata } */
    this.metadata;
    /** @type { !gfx_mojom_ColorSpace } */
    this.colorSpace;
    /** @type { (gfx_mojom_HDRMetadata|undefined) } */
    this.hdrMetadata;
  }
}



mojo.internal.Struct(
    EosVideoFrameDataSpec.$,
    'EosVideoFrameData',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EosVideoFrameData {
  constructor() {
  }
}



mojo.internal.Struct(
    SharedMemoryVideoFrameDataSpec.$,
    'SharedMemoryVideoFrameData',
    [
      mojo.internal.StructField(
        'frameData', 0,
        0,
        mojoBase_mojom_ReadOnlySharedMemoryRegionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'strides', 8,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'offsets', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SharedMemoryVideoFrameData {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlySharedMemoryRegion } */
    this.frameData;
    /** @type { !Array<!number> } */
    this.strides;
    /** @type { !Array<!number> } */
    this.offsets;
  }
}



mojo.internal.Struct(
    GpuMemoryBufferSharedImageVideoFrameDataSpec.$,
    'GpuMemoryBufferSharedImageVideoFrameData',
    [
      mojo.internal.StructField(
        'gpuMemoryBufferHandle', 0,
        0,
        gfx_mojom_GpuMemoryBufferHandleSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedImage', 8,
        0,
        gpu_mojom_ExportedSharedImageSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'syncToken', 16,
        0,
        gpu_mojom_SyncTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class GpuMemoryBufferSharedImageVideoFrameData {
  constructor() {
    /** @type { !gfx_mojom_GpuMemoryBufferHandle } */
    this.gpuMemoryBufferHandle;
    /** @type { (gpu_mojom_ExportedSharedImage|undefined) } */
    this.sharedImage;
    /** @type { !gpu_mojom_SyncToken } */
    this.syncToken;
  }
}



mojo.internal.Struct(
    SharedImageVideoFrameDataSpec.$,
    'SharedImageVideoFrameData',
    [
      mojo.internal.StructField(
        'sharedImage', 0,
        0,
        gpu_mojom_ExportedSharedImageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'syncToken', 8,
        0,
        gpu_mojom_SyncTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isMappableSiEnabled', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SharedImageVideoFrameData {
  constructor() {
    /** @type { !gpu_mojom_ExportedSharedImage } */
    this.sharedImage;
    /** @type { !gpu_mojom_SyncToken } */
    this.syncToken;
    /** @type { !boolean } */
    this.isMappableSiEnabled;
  }
}



mojo.internal.Struct(
    OpaqueVideoFrameDataSpec.$,
    'OpaqueVideoFrameData',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class OpaqueVideoFrameData {
  constructor() {
  }
}



mojo.internal.Struct(
    PipelineStatisticsSpec.$,
    'PipelineStatistics',
    [
      mojo.internal.StructField(
        'audioBytesDecoded', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoBytesDecoded', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoFramesDecoded', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoFramesDropped', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioMemoryUsage', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoMemoryUsage', 32,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class PipelineStatistics {
  constructor() {
    /** @type { !bigint } */
    this.audioBytesDecoded;
    /** @type { !bigint } */
    this.videoBytesDecoded;
    /** @type { !number } */
    this.videoFramesDecoded;
    /** @type { !number } */
    this.videoFramesDropped;
    /** @type { !bigint } */
    this.audioMemoryUsage;
    /** @type { !bigint } */
    this.videoMemoryUsage;
  }
}



mojo.internal.Struct(
    PredictionFeaturesSpec.$,
    'PredictionFeatures',
    [
      mojo.internal.StructField(
        'profile', 0,
        0,
        VideoCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framesPerSec', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keySystem', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'useHwSecureCodecs', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PredictionFeatures {
  constructor() {
    /** @type { !VideoCodecProfile } */
    this.profile;
    /** @type { !gfx_mojom_Size } */
    this.videoSize;
    /** @type { !number } */
    this.framesPerSec;
    /** @type { !string } */
    this.keySystem;
    /** @type { !boolean } */
    this.useHwSecureCodecs;
  }
}



mojo.internal.Struct(
    PredictionTargetsSpec.$,
    'PredictionTargets',
    [
      mojo.internal.StructField(
        'framesDecoded', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framesDropped', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framesPowerEfficient', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PredictionTargets {
  constructor() {
    /** @type { !number } */
    this.framesDecoded;
    /** @type { !number } */
    this.framesDropped;
    /** @type { !number } */
    this.framesPowerEfficient;
  }
}



mojo.internal.Struct(
    AudioPipelineInfoSpec.$,
    'AudioPipelineInfo',
    [
      mojo.internal.StructField(
        'decoderType', 0,
        0,
        AudioDecoderTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPlatformDecoder', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasDecryptingDemuxerStream', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encryptionType', 8,
        0,
        EncryptionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioPipelineInfo {
  constructor() {
    /** @type { !AudioDecoderType } */
    this.decoderType;
    /** @type { !boolean } */
    this.isPlatformDecoder;
    /** @type { !boolean } */
    this.hasDecryptingDemuxerStream;
    /** @type { !EncryptionType } */
    this.encryptionType;
  }
}



mojo.internal.Struct(
    VideoPipelineInfoSpec.$,
    'VideoPipelineInfo',
    [
      mojo.internal.StructField(
        'decoderType', 0,
        0,
        VideoDecoderTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPlatformDecoder', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasDecryptingDemuxerStream', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encryptionType', 8,
        0,
        EncryptionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoPipelineInfo {
  constructor() {
    /** @type { !VideoDecoderType } */
    this.decoderType;
    /** @type { !boolean } */
    this.isPlatformDecoder;
    /** @type { !boolean } */
    this.hasDecryptingDemuxerStream;
    /** @type { !EncryptionType } */
    this.encryptionType;
  }
}



mojo.internal.Struct(
    StatusDataSpec.$,
    'StatusData',
    [
      mojo.internal.StructField(
        'group', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'code', 8,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frames', 24,
        0,
        mojoBase_mojom_ListValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cause', 32,
        0,
        StatusDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 40,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class StatusData {
  constructor() {
    /** @type { !string } */
    this.group;
    /** @type { !number } */
    this.code;
    /** @type { !string } */
    this.message;
    /** @type { !mojoBase_mojom_ListValue } */
    this.frames;
    /** @type { (StatusData|undefined) } */
    this.cause;
    /** @type { !mojoBase_mojom_Value } */
    this.data;
  }
}



mojo.internal.Struct(
    EncoderStatusSpec.$,
    'EncoderStatus',
    [
      mojo.internal.StructField(
        'internal', 0,
        0,
        StatusDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EncoderStatus {
  constructor() {
    /** @type { (StatusData|undefined) } */
    this.internal;
  }
}



mojo.internal.Struct(
    DecoderStatusSpec.$,
    'DecoderStatus',
    [
      mojo.internal.StructField(
        'internal', 0,
        0,
        StatusDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DecoderStatus {
  constructor() {
    /** @type { (StatusData|undefined) } */
    this.internal;
  }
}



mojo.internal.Struct(
    PipelineStatusSpec.$,
    'PipelineStatus',
    [
      mojo.internal.StructField(
        'internal', 0,
        0,
        StatusDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PipelineStatus {
  constructor() {
    /** @type { (StatusData|undefined) } */
    this.internal;
  }
}



mojo.internal.Struct(
    AutoPipInfoSpec.$,
    'AutoPipInfo',
    [
      mojo.internal.StructField(
        'autoPipReason', 0,
        0,
        AutoPipReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasAudioFocus', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPlaying', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasRecentlyAudible', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasSafeUrl', 4,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'meetsMediaEngagementConditions', 4,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blockedDueToContentSetting', 4,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AutoPipInfo {
  constructor() {
    /** @type { !AutoPipReason } */
    this.autoPipReason;
    /** @type { !boolean } */
    this.hasAudioFocus;
    /** @type { !boolean } */
    this.isPlaying;
    /** @type { !boolean } */
    this.wasRecentlyAudible;
    /** @type { !boolean } */
    this.hasSafeUrl;
    /** @type { !boolean } */
    this.meetsMediaEngagementConditions;
    /** @type { !boolean } */
    this.blockedDueToContentSetting;
  }
}

mojo.internal.Union(
    DecoderBufferSideDataNextConfigSpec.$, 'DecoderBufferSideDataNextConfig',
    {
      'nextAudioConfig': {
        'ordinal': 0,
        'type': AudioDecoderConfigSpec.$,
      },
      'nextVideoConfig': {
        'ordinal': 1,
        'type': VideoDecoderConfigSpec.$,
      },
    });

/**
 * @typedef { {
 *   nextAudioConfig: (!AudioDecoderConfig|undefined),
 *   nextVideoConfig: (!VideoDecoderConfig|undefined),
 * } }
 */
export const DecoderBufferSideDataNextConfig = {};
mojo.internal.Union(
    DecoderBufferSpec.$, 'DecoderBuffer',
    {
      'eos': {
        'ordinal': 0,
        'type': EosDecoderBufferSpec.$,
      },
      'data': {
        'ordinal': 1,
        'type': DataDecoderBufferSpec.$,
      },
    });

/**
 * @typedef { {
 *   eos: (!EosDecoderBuffer|undefined),
 *   data: (!DataDecoderBuffer|undefined),
 * } }
 */
export const DecoderBuffer = {};
mojo.internal.Union(
    VideoFrameDataSpec.$, 'VideoFrameData',
    {
      'eosData': {
        'ordinal': 0,
        'type': EosVideoFrameDataSpec.$,
      },
      'sharedMemoryData': {
        'ordinal': 1,
        'type': SharedMemoryVideoFrameDataSpec.$,
      },
      'gpuMemoryBufferSharedImageData': {
        'ordinal': 2,
        'type': GpuMemoryBufferSharedImageVideoFrameDataSpec.$,
      },
      'sharedImageData': {
        'ordinal': 3,
        'type': SharedImageVideoFrameDataSpec.$,
      },
      'opaqueData': {
        'ordinal': 4,
        'type': OpaqueVideoFrameDataSpec.$,
      },
    });

/**
 * @typedef { {
 *   eosData: (!EosVideoFrameData|undefined),
 *   sharedMemoryData: (!SharedMemoryVideoFrameData|undefined),
 *   gpuMemoryBufferSharedImageData: (!GpuMemoryBufferSharedImageVideoFrameData|undefined),
 *   sharedImageData: (!SharedImageVideoFrameData|undefined),
 *   opaqueData: (!OpaqueVideoFrameData|undefined),
 * } }
 */
export const VideoFrameData = {};
