// media/mojo/mojom/media_player.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/media_player.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }
  var media_session$ =
      mojo.internal.exposeNamespace('mediaSession.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/media_session/public/mojom/media_session.mojom', '../../../services/media_session/public/mojom/media_session.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }



  function MediaPlayer_RequestPlay_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RequestPlay_Params.prototype.initDefaults_ = function() {
  };
  MediaPlayer_RequestPlay_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RequestPlay_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayer_RequestPlay_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaPlayer_RequestPlay_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RequestPlay_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaPlayer_RequestPlay_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RequestPlay_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaPlayer_RequestPause_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RequestPause_Params.prototype.initDefaults_ = function() {
    this.triggeredByUser = false;
  };
  MediaPlayer_RequestPause_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RequestPause_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayer_RequestPause_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_RequestPause_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RequestPause_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.triggeredByUser = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayer_RequestPause_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RequestPause_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.triggeredByUser & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayer_RequestSeekForward_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RequestSeekForward_Params.prototype.initDefaults_ = function() {
    this.seekTime = null;
  };
  MediaPlayer_RequestSeekForward_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RequestSeekForward_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayer_RequestSeekForward_Params.seekTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayer_RequestSeekForward_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_RequestSeekForward_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RequestSeekForward_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.seekTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  MediaPlayer_RequestSeekForward_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RequestSeekForward_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.seekTime);
  };
  function MediaPlayer_RequestSeekBackward_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RequestSeekBackward_Params.prototype.initDefaults_ = function() {
    this.seekTime = null;
  };
  MediaPlayer_RequestSeekBackward_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RequestSeekBackward_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayer_RequestSeekBackward_Params.seekTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayer_RequestSeekBackward_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_RequestSeekBackward_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RequestSeekBackward_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.seekTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  MediaPlayer_RequestSeekBackward_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RequestSeekBackward_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.seekTime);
  };
  function MediaPlayer_RequestSeekTo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RequestSeekTo_Params.prototype.initDefaults_ = function() {
    this.seekTime = null;
  };
  MediaPlayer_RequestSeekTo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RequestSeekTo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayer_RequestSeekTo_Params.seekTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayer_RequestSeekTo_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_RequestSeekTo_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RequestSeekTo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.seekTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  MediaPlayer_RequestSeekTo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RequestSeekTo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.seekTime);
  };
  function MediaPlayer_RequestEnterPictureInPicture_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RequestEnterPictureInPicture_Params.prototype.initDefaults_ = function() {
  };
  MediaPlayer_RequestEnterPictureInPicture_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RequestEnterPictureInPicture_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayer_RequestEnterPictureInPicture_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaPlayer_RequestEnterPictureInPicture_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RequestEnterPictureInPicture_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaPlayer_RequestEnterPictureInPicture_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RequestEnterPictureInPicture_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaPlayer_RequestMute_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RequestMute_Params.prototype.initDefaults_ = function() {
    this.mute = false;
  };
  MediaPlayer_RequestMute_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RequestMute_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayer_RequestMute_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_RequestMute_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RequestMute_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.mute = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayer_RequestMute_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RequestMute_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.mute & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayer_SetVolumeMultiplier_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_SetVolumeMultiplier_Params.prototype.initDefaults_ = function() {
    this.multiplier = 0;
  };
  MediaPlayer_SetVolumeMultiplier_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_SetVolumeMultiplier_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayer_SetVolumeMultiplier_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_SetVolumeMultiplier_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_SetVolumeMultiplier_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.multiplier =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  MediaPlayer_SetVolumeMultiplier_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_SetVolumeMultiplier_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.multiplier);
  };
  function MediaPlayer_SetPersistentState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_SetPersistentState_Params.prototype.initDefaults_ = function() {
    this.persistent = false;
  };
  MediaPlayer_SetPersistentState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_SetPersistentState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayer_SetPersistentState_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_SetPersistentState_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_SetPersistentState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.persistent = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayer_SetPersistentState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_SetPersistentState_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.persistent & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayer_SetPowerExperimentState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_SetPowerExperimentState_Params.prototype.initDefaults_ = function() {
    this.enabled = false;
  };
  MediaPlayer_SetPowerExperimentState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_SetPowerExperimentState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayer_SetPowerExperimentState_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_SetPowerExperimentState_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_SetPowerExperimentState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayer_SetPowerExperimentState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_SetPowerExperimentState_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayer_SetAudioSinkId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_SetAudioSinkId_Params.prototype.initDefaults_ = function() {
    this.sinkId = null;
  };
  MediaPlayer_SetAudioSinkId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_SetAudioSinkId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayer_SetAudioSinkId_Params.sinkId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayer_SetAudioSinkId_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_SetAudioSinkId_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_SetAudioSinkId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sinkId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaPlayer_SetAudioSinkId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_SetAudioSinkId_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.sinkId);
  };
  function MediaPlayer_SuspendForFrameClosed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_SuspendForFrameClosed_Params.prototype.initDefaults_ = function() {
  };
  MediaPlayer_SuspendForFrameClosed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_SuspendForFrameClosed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayer_SuspendForFrameClosed_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaPlayer_SuspendForFrameClosed_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_SuspendForFrameClosed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaPlayer_SuspendForFrameClosed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_SuspendForFrameClosed_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaPlayer_RequestMediaRemoting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RequestMediaRemoting_Params.prototype.initDefaults_ = function() {
  };
  MediaPlayer_RequestMediaRemoting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RequestMediaRemoting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayer_RequestMediaRemoting_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaPlayer_RequestMediaRemoting_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RequestMediaRemoting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaPlayer_RequestMediaRemoting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RequestMediaRemoting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaPlayer_RequestVisibility_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RequestVisibility_Params.prototype.initDefaults_ = function() {
  };
  MediaPlayer_RequestVisibility_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RequestVisibility_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayer_RequestVisibility_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaPlayer_RequestVisibility_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RequestVisibility_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaPlayer_RequestVisibility_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RequestVisibility_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaPlayer_RequestVisibility_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RequestVisibility_ResponseParams.prototype.initDefaults_ = function() {
    this.hasSufficientlyVisibleVideo = false;
  };
  MediaPlayer_RequestVisibility_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RequestVisibility_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayer_RequestVisibility_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_RequestVisibility_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RequestVisibility_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasSufficientlyVisibleVideo = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayer_RequestVisibility_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RequestVisibility_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasSufficientlyVisibleVideo & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayer_RecordAutoPictureInPictureInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayer_RecordAutoPictureInPictureInfo_Params.prototype.initDefaults_ = function() {
    this.autoPictureInPictureInfo = null;
  };
  MediaPlayer_RecordAutoPictureInPictureInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayer_RecordAutoPictureInPictureInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayer_RecordAutoPictureInPictureInfo_Params.autoPictureInPictureInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_types$.AutoPipInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayer_RecordAutoPictureInPictureInfo_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayer_RecordAutoPictureInPictureInfo_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayer_RecordAutoPictureInPictureInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.autoPictureInPictureInfo =
        decoder.decodeStructPointer(media_types$.AutoPipInfo);
    return val;
  };

  MediaPlayer_RecordAutoPictureInPictureInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayer_RecordAutoPictureInPictureInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_types$.AutoPipInfo, val.autoPictureInPictureInfo);
  };
  function MediaPlayerObserverClient_GetHasPlayedBefore_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserverClient_GetHasPlayedBefore_Params.prototype.initDefaults_ = function() {
  };
  MediaPlayerObserverClient_GetHasPlayedBefore_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserverClient_GetHasPlayedBefore_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayerObserverClient_GetHasPlayedBefore_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaPlayerObserverClient_GetHasPlayedBefore_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserverClient_GetHasPlayedBefore_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaPlayerObserverClient_GetHasPlayedBefore_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserverClient_GetHasPlayedBefore_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams.prototype.initDefaults_ = function() {
    this.hasPlayedBefore = false;
  };
  MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasPlayedBefore = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasPlayedBefore & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayerObserver_OnMediaPlaying_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnMediaPlaying_Params.prototype.initDefaults_ = function() {
  };
  MediaPlayerObserver_OnMediaPlaying_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnMediaPlaying_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnMediaPlaying_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaPlayerObserver_OnMediaPlaying_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnMediaPlaying_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaPlayerObserver_OnMediaPlaying_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnMediaPlaying_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaPlayerObserver_OnMediaPaused_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnMediaPaused_Params.prototype.initDefaults_ = function() {
    this.streamEnded = false;
  };
  MediaPlayerObserver_OnMediaPaused_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnMediaPaused_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnMediaPaused_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnMediaPaused_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnMediaPaused_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.streamEnded = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayerObserver_OnMediaPaused_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnMediaPaused_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.streamEnded & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayerObserver_OnMutedStatusChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnMutedStatusChanged_Params.prototype.initDefaults_ = function() {
    this.muted = false;
  };
  MediaPlayerObserver_OnMutedStatusChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnMutedStatusChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnMutedStatusChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnMutedStatusChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnMutedStatusChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.muted = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayerObserver_OnMutedStatusChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnMutedStatusChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.muted & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayerObserver_OnMediaMetadataChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnMediaMetadataChanged_Params.prototype.initDefaults_ = function() {
    this.hasAudio = false;
    this.hasVideo = false;
    this.contentType = 0;
  };
  MediaPlayerObserver_OnMediaMetadataChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnMediaMetadataChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate MediaPlayerObserver_OnMediaMetadataChanged_Params.contentType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, media_types$.MediaContentType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnMediaMetadataChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnMediaMetadataChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnMediaMetadataChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasAudio = (packed >> 0) & 1 ? true : false;
    val.hasVideo = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.contentType =
        decoder.decodeStruct(new codec.Enum(media_types$.MediaContentType));
    return val;
  };

  MediaPlayerObserver_OnMediaMetadataChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnMediaMetadataChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasAudio & 1) << 0
    packed |= (val.hasVideo & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.contentType);
  };
  function MediaPlayerObserver_OnMediaPositionStateChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnMediaPositionStateChanged_Params.prototype.initDefaults_ = function() {
    this.mediaPosition = null;
  };
  MediaPlayerObserver_OnMediaPositionStateChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnMediaPositionStateChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayerObserver_OnMediaPositionStateChanged_Params.mediaPosition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_session$.MediaPosition, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnMediaPositionStateChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnMediaPositionStateChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnMediaPositionStateChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mediaPosition =
        decoder.decodeStructPointer(media_session$.MediaPosition);
    return val;
  };

  MediaPlayerObserver_OnMediaPositionStateChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnMediaPositionStateChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_session$.MediaPosition, val.mediaPosition);
  };
  function MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.FullscreenVideoStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(media_types$.FullscreenVideoStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayerObserver_OnMediaSizeChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnMediaSizeChanged_Params.prototype.initDefaults_ = function() {
    this.size = null;
  };
  MediaPlayerObserver_OnMediaSizeChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnMediaSizeChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayerObserver_OnMediaSizeChanged_Params.size
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnMediaSizeChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnMediaSizeChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnMediaSizeChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.size =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  MediaPlayerObserver_OnMediaSizeChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnMediaSizeChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Size, val.size);
  };
  function MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params.prototype.initDefaults_ = function() {
    this.available = false;
  };
  MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.available = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.available & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayerObserver_OnAudioOutputSinkChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnAudioOutputSinkChanged_Params.prototype.initDefaults_ = function() {
    this.hashedDeviceId = null;
  };
  MediaPlayerObserver_OnAudioOutputSinkChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnAudioOutputSinkChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayerObserver_OnAudioOutputSinkChanged_Params.hashedDeviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnAudioOutputSinkChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnAudioOutputSinkChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnAudioOutputSinkChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.hashedDeviceId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaPlayerObserver_OnAudioOutputSinkChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnAudioOutputSinkChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.hashedDeviceId);
  };
  function MediaPlayerObserver_OnUseAudioServiceChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnUseAudioServiceChanged_Params.prototype.initDefaults_ = function() {
    this.usesAudioService = false;
  };
  MediaPlayerObserver_OnUseAudioServiceChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnUseAudioServiceChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnUseAudioServiceChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnUseAudioServiceChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnUseAudioServiceChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.usesAudioService = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayerObserver_OnUseAudioServiceChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnUseAudioServiceChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.usesAudioService & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params.prototype.initDefaults_ = function() {
  };
  MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params.prototype.initDefaults_ = function() {
    this.remotePlaybackMetadata = null;
  };
  MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params.remotePlaybackMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_session$.RemotePlaybackMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.remotePlaybackMetadata =
        decoder.decodeStructPointer(media_session$.RemotePlaybackMetadata);
    return val;
  };

  MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_session$.RemotePlaybackMetadata, val.remotePlaybackMetadata);
  };
  function MediaPlayerObserver_OnVideoVisibilityChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerObserver_OnVideoVisibilityChanged_Params.prototype.initDefaults_ = function() {
    this.meetsVisibilityThreshold = false;
  };
  MediaPlayerObserver_OnVideoVisibilityChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerObserver_OnVideoVisibilityChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayerObserver_OnVideoVisibilityChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaPlayerObserver_OnVideoVisibilityChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerObserver_OnVideoVisibilityChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.meetsVisibilityThreshold = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPlayerObserver_OnVideoVisibilityChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerObserver_OnVideoVisibilityChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.meetsVisibilityThreshold & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPlayerHost_OnMediaPlayerAdded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPlayerHost_OnMediaPlayerAdded_Params.prototype.initDefaults_ = function() {
    this.playerRemote = new associatedBindings.AssociatedInterfacePtrInfo();
    this.observer = new associatedBindings.AssociatedInterfaceRequest();
    this.playerId = 0;
  };
  MediaPlayerHost_OnMediaPlayerAdded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPlayerHost_OnMediaPlayerAdded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayerHost_OnMediaPlayerAdded_Params.playerRemote
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPlayerHost_OnMediaPlayerAdded_Params.observer
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPlayerHost_OnMediaPlayerAdded_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaPlayerHost_OnMediaPlayerAdded_Params.decode = function(decoder) {
    var packed;
    var val = new MediaPlayerHost_OnMediaPlayerAdded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.playerRemote =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.observer =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.playerId =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  MediaPlayerHost_OnMediaPlayerAdded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPlayerHost_OnMediaPlayerAdded_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.playerRemote);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.observer);
    encoder.encodeStruct(codec.Int32, val.playerId);
  };
  var kMediaPlayer_RequestPlay_Name = 0;
  var kMediaPlayer_RequestPause_Name = 1;
  var kMediaPlayer_RequestSeekForward_Name = 2;
  var kMediaPlayer_RequestSeekBackward_Name = 3;
  var kMediaPlayer_RequestSeekTo_Name = 4;
  var kMediaPlayer_RequestEnterPictureInPicture_Name = 5;
  var kMediaPlayer_RequestMute_Name = 6;
  var kMediaPlayer_SetVolumeMultiplier_Name = 7;
  var kMediaPlayer_SetPersistentState_Name = 8;
  var kMediaPlayer_SetPowerExperimentState_Name = 9;
  var kMediaPlayer_SetAudioSinkId_Name = 10;
  var kMediaPlayer_SuspendForFrameClosed_Name = 11;
  var kMediaPlayer_RequestMediaRemoting_Name = 12;
  var kMediaPlayer_RequestVisibility_Name = 13;
  var kMediaPlayer_RecordAutoPictureInPictureInfo_Name = 14;

  function MediaPlayerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaPlayer,
                                                   handleOrPtrInfo);
  }

  function MediaPlayerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaPlayer, associatedInterfacePtrInfo);
  }

  MediaPlayerAssociatedPtr.prototype =
      Object.create(MediaPlayerPtr.prototype);
  MediaPlayerAssociatedPtr.prototype.constructor =
      MediaPlayerAssociatedPtr;

  function MediaPlayerProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaPlayerPtr.prototype.requestPlay = function() {
    return MediaPlayerProxy.prototype.requestPlay
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.requestPlay = function() {
    var params_ = new MediaPlayer_RequestPlay_Params();
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_RequestPlay_Name,
        codec.align(MediaPlayer_RequestPlay_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_RequestPlay_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.requestPause = function() {
    return MediaPlayerProxy.prototype.requestPause
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.requestPause = function(triggeredByUser) {
    var params_ = new MediaPlayer_RequestPause_Params();
    params_.triggeredByUser = triggeredByUser;
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_RequestPause_Name,
        codec.align(MediaPlayer_RequestPause_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_RequestPause_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.requestSeekForward = function() {
    return MediaPlayerProxy.prototype.requestSeekForward
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.requestSeekForward = function(seekTime) {
    var params_ = new MediaPlayer_RequestSeekForward_Params();
    params_.seekTime = seekTime;
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_RequestSeekForward_Name,
        codec.align(MediaPlayer_RequestSeekForward_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_RequestSeekForward_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.requestSeekBackward = function() {
    return MediaPlayerProxy.prototype.requestSeekBackward
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.requestSeekBackward = function(seekTime) {
    var params_ = new MediaPlayer_RequestSeekBackward_Params();
    params_.seekTime = seekTime;
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_RequestSeekBackward_Name,
        codec.align(MediaPlayer_RequestSeekBackward_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_RequestSeekBackward_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.requestSeekTo = function() {
    return MediaPlayerProxy.prototype.requestSeekTo
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.requestSeekTo = function(seekTime) {
    var params_ = new MediaPlayer_RequestSeekTo_Params();
    params_.seekTime = seekTime;
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_RequestSeekTo_Name,
        codec.align(MediaPlayer_RequestSeekTo_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_RequestSeekTo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.requestEnterPictureInPicture = function() {
    return MediaPlayerProxy.prototype.requestEnterPictureInPicture
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.requestEnterPictureInPicture = function() {
    var params_ = new MediaPlayer_RequestEnterPictureInPicture_Params();
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_RequestEnterPictureInPicture_Name,
        codec.align(MediaPlayer_RequestEnterPictureInPicture_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_RequestEnterPictureInPicture_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.requestMute = function() {
    return MediaPlayerProxy.prototype.requestMute
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.requestMute = function(mute) {
    var params_ = new MediaPlayer_RequestMute_Params();
    params_.mute = mute;
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_RequestMute_Name,
        codec.align(MediaPlayer_RequestMute_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_RequestMute_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.setVolumeMultiplier = function() {
    return MediaPlayerProxy.prototype.setVolumeMultiplier
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.setVolumeMultiplier = function(multiplier) {
    var params_ = new MediaPlayer_SetVolumeMultiplier_Params();
    params_.multiplier = multiplier;
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_SetVolumeMultiplier_Name,
        codec.align(MediaPlayer_SetVolumeMultiplier_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_SetVolumeMultiplier_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.setPersistentState = function() {
    return MediaPlayerProxy.prototype.setPersistentState
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.setPersistentState = function(persistent) {
    var params_ = new MediaPlayer_SetPersistentState_Params();
    params_.persistent = persistent;
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_SetPersistentState_Name,
        codec.align(MediaPlayer_SetPersistentState_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_SetPersistentState_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.setPowerExperimentState = function() {
    return MediaPlayerProxy.prototype.setPowerExperimentState
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.setPowerExperimentState = function(enabled) {
    var params_ = new MediaPlayer_SetPowerExperimentState_Params();
    params_.enabled = enabled;
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_SetPowerExperimentState_Name,
        codec.align(MediaPlayer_SetPowerExperimentState_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_SetPowerExperimentState_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.setAudioSinkId = function() {
    return MediaPlayerProxy.prototype.setAudioSinkId
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.setAudioSinkId = function(sinkId) {
    var params_ = new MediaPlayer_SetAudioSinkId_Params();
    params_.sinkId = sinkId;
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_SetAudioSinkId_Name,
        codec.align(MediaPlayer_SetAudioSinkId_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_SetAudioSinkId_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.suspendForFrameClosed = function() {
    return MediaPlayerProxy.prototype.suspendForFrameClosed
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.suspendForFrameClosed = function() {
    var params_ = new MediaPlayer_SuspendForFrameClosed_Params();
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_SuspendForFrameClosed_Name,
        codec.align(MediaPlayer_SuspendForFrameClosed_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_SuspendForFrameClosed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.requestMediaRemoting = function() {
    return MediaPlayerProxy.prototype.requestMediaRemoting
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.requestMediaRemoting = function() {
    var params_ = new MediaPlayer_RequestMediaRemoting_Params();
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_RequestMediaRemoting_Name,
        codec.align(MediaPlayer_RequestMediaRemoting_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_RequestMediaRemoting_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerPtr.prototype.requestVisibility = function() {
    return MediaPlayerProxy.prototype.requestVisibility
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.requestVisibility = function() {
    var params_ = new MediaPlayer_RequestVisibility_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaPlayer_RequestVisibility_Name,
          codec.align(MediaPlayer_RequestVisibility_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaPlayer_RequestVisibility_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaPlayer_RequestVisibility_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaPlayerPtr.prototype.recordAutoPictureInPictureInfo = function() {
    return MediaPlayerProxy.prototype.recordAutoPictureInPictureInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerProxy.prototype.recordAutoPictureInPictureInfo = function(autoPictureInPictureInfo) {
    var params_ = new MediaPlayer_RecordAutoPictureInPictureInfo_Params();
    params_.autoPictureInPictureInfo = autoPictureInPictureInfo;
    var builder = new codec.MessageV0Builder(
        kMediaPlayer_RecordAutoPictureInPictureInfo_Name,
        codec.align(MediaPlayer_RecordAutoPictureInPictureInfo_Params.encodedSize));
    builder.encodeStruct(MediaPlayer_RecordAutoPictureInPictureInfo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MediaPlayerStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaPlayerStub.prototype.requestPlay = function() {
    return this.delegate_ && this.delegate_.requestPlay && this.delegate_.requestPlay();
  }
  MediaPlayerStub.prototype.requestPause = function(triggeredByUser) {
    return this.delegate_ && this.delegate_.requestPause && this.delegate_.requestPause(triggeredByUser);
  }
  MediaPlayerStub.prototype.requestSeekForward = function(seekTime) {
    return this.delegate_ && this.delegate_.requestSeekForward && this.delegate_.requestSeekForward(seekTime);
  }
  MediaPlayerStub.prototype.requestSeekBackward = function(seekTime) {
    return this.delegate_ && this.delegate_.requestSeekBackward && this.delegate_.requestSeekBackward(seekTime);
  }
  MediaPlayerStub.prototype.requestSeekTo = function(seekTime) {
    return this.delegate_ && this.delegate_.requestSeekTo && this.delegate_.requestSeekTo(seekTime);
  }
  MediaPlayerStub.prototype.requestEnterPictureInPicture = function() {
    return this.delegate_ && this.delegate_.requestEnterPictureInPicture && this.delegate_.requestEnterPictureInPicture();
  }
  MediaPlayerStub.prototype.requestMute = function(mute) {
    return this.delegate_ && this.delegate_.requestMute && this.delegate_.requestMute(mute);
  }
  MediaPlayerStub.prototype.setVolumeMultiplier = function(multiplier) {
    return this.delegate_ && this.delegate_.setVolumeMultiplier && this.delegate_.setVolumeMultiplier(multiplier);
  }
  MediaPlayerStub.prototype.setPersistentState = function(persistent) {
    return this.delegate_ && this.delegate_.setPersistentState && this.delegate_.setPersistentState(persistent);
  }
  MediaPlayerStub.prototype.setPowerExperimentState = function(enabled) {
    return this.delegate_ && this.delegate_.setPowerExperimentState && this.delegate_.setPowerExperimentState(enabled);
  }
  MediaPlayerStub.prototype.setAudioSinkId = function(sinkId) {
    return this.delegate_ && this.delegate_.setAudioSinkId && this.delegate_.setAudioSinkId(sinkId);
  }
  MediaPlayerStub.prototype.suspendForFrameClosed = function() {
    return this.delegate_ && this.delegate_.suspendForFrameClosed && this.delegate_.suspendForFrameClosed();
  }
  MediaPlayerStub.prototype.requestMediaRemoting = function() {
    return this.delegate_ && this.delegate_.requestMediaRemoting && this.delegate_.requestMediaRemoting();
  }
  MediaPlayerStub.prototype.requestVisibility = function() {
    return this.delegate_ && this.delegate_.requestVisibility && this.delegate_.requestVisibility();
  }
  MediaPlayerStub.prototype.recordAutoPictureInPictureInfo = function(autoPictureInPictureInfo) {
    return this.delegate_ && this.delegate_.recordAutoPictureInPictureInfo && this.delegate_.recordAutoPictureInPictureInfo(autoPictureInPictureInfo);
  }

  MediaPlayerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaPlayer_RequestPlay_Name:
      var params = reader.decodeStruct(MediaPlayer_RequestPlay_Params);
      this.requestPlay();
      return true;
    case kMediaPlayer_RequestPause_Name:
      var params = reader.decodeStruct(MediaPlayer_RequestPause_Params);
      this.requestPause(params.triggeredByUser);
      return true;
    case kMediaPlayer_RequestSeekForward_Name:
      var params = reader.decodeStruct(MediaPlayer_RequestSeekForward_Params);
      this.requestSeekForward(params.seekTime);
      return true;
    case kMediaPlayer_RequestSeekBackward_Name:
      var params = reader.decodeStruct(MediaPlayer_RequestSeekBackward_Params);
      this.requestSeekBackward(params.seekTime);
      return true;
    case kMediaPlayer_RequestSeekTo_Name:
      var params = reader.decodeStruct(MediaPlayer_RequestSeekTo_Params);
      this.requestSeekTo(params.seekTime);
      return true;
    case kMediaPlayer_RequestEnterPictureInPicture_Name:
      var params = reader.decodeStruct(MediaPlayer_RequestEnterPictureInPicture_Params);
      this.requestEnterPictureInPicture();
      return true;
    case kMediaPlayer_RequestMute_Name:
      var params = reader.decodeStruct(MediaPlayer_RequestMute_Params);
      this.requestMute(params.mute);
      return true;
    case kMediaPlayer_SetVolumeMultiplier_Name:
      var params = reader.decodeStruct(MediaPlayer_SetVolumeMultiplier_Params);
      this.setVolumeMultiplier(params.multiplier);
      return true;
    case kMediaPlayer_SetPersistentState_Name:
      var params = reader.decodeStruct(MediaPlayer_SetPersistentState_Params);
      this.setPersistentState(params.persistent);
      return true;
    case kMediaPlayer_SetPowerExperimentState_Name:
      var params = reader.decodeStruct(MediaPlayer_SetPowerExperimentState_Params);
      this.setPowerExperimentState(params.enabled);
      return true;
    case kMediaPlayer_SetAudioSinkId_Name:
      var params = reader.decodeStruct(MediaPlayer_SetAudioSinkId_Params);
      this.setAudioSinkId(params.sinkId);
      return true;
    case kMediaPlayer_SuspendForFrameClosed_Name:
      var params = reader.decodeStruct(MediaPlayer_SuspendForFrameClosed_Params);
      this.suspendForFrameClosed();
      return true;
    case kMediaPlayer_RequestMediaRemoting_Name:
      var params = reader.decodeStruct(MediaPlayer_RequestMediaRemoting_Params);
      this.requestMediaRemoting();
      return true;
    case kMediaPlayer_RecordAutoPictureInPictureInfo_Name:
      var params = reader.decodeStruct(MediaPlayer_RecordAutoPictureInPictureInfo_Params);
      this.recordAutoPictureInPictureInfo(params.autoPictureInPictureInfo);
      return true;
    default:
      return false;
    }
  };

  MediaPlayerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaPlayer_RequestVisibility_Name:
      var params = reader.decodeStruct(MediaPlayer_RequestVisibility_Params);
      this.requestVisibility().then(function(response) {
        var responseParams =
            new MediaPlayer_RequestVisibility_ResponseParams();
        responseParams.hasSufficientlyVisibleVideo = response.hasSufficientlyVisibleVideo;
        var builder = new codec.MessageV1Builder(
            kMediaPlayer_RequestVisibility_Name,
            codec.align(MediaPlayer_RequestVisibility_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaPlayer_RequestVisibility_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateMediaPlayerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaPlayer_RequestPlay_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_RequestPlay_Params;
      break;
      case kMediaPlayer_RequestPause_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_RequestPause_Params;
      break;
      case kMediaPlayer_RequestSeekForward_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_RequestSeekForward_Params;
      break;
      case kMediaPlayer_RequestSeekBackward_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_RequestSeekBackward_Params;
      break;
      case kMediaPlayer_RequestSeekTo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_RequestSeekTo_Params;
      break;
      case kMediaPlayer_RequestEnterPictureInPicture_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_RequestEnterPictureInPicture_Params;
      break;
      case kMediaPlayer_RequestMute_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_RequestMute_Params;
      break;
      case kMediaPlayer_SetVolumeMultiplier_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_SetVolumeMultiplier_Params;
      break;
      case kMediaPlayer_SetPersistentState_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_SetPersistentState_Params;
      break;
      case kMediaPlayer_SetPowerExperimentState_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_SetPowerExperimentState_Params;
      break;
      case kMediaPlayer_SetAudioSinkId_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_SetAudioSinkId_Params;
      break;
      case kMediaPlayer_SuspendForFrameClosed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_SuspendForFrameClosed_Params;
      break;
      case kMediaPlayer_RequestMediaRemoting_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_RequestMediaRemoting_Params;
      break;
      case kMediaPlayer_RequestVisibility_Name:
        if (message.expectsResponse())
          paramsClass = MediaPlayer_RequestVisibility_Params;
      break;
      case kMediaPlayer_RecordAutoPictureInPictureInfo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayer_RecordAutoPictureInPictureInfo_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaPlayerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kMediaPlayer_RequestVisibility_Name:
        if (message.isResponse())
          paramsClass = MediaPlayer_RequestVisibility_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var MediaPlayer = {
    name: 'media.mojom.MediaPlayer',
    kVersion: 0,
    ptrClass: MediaPlayerPtr,
    proxyClass: MediaPlayerProxy,
    stubClass: MediaPlayerStub,
    validateRequest: validateMediaPlayerRequest,
    validateResponse: validateMediaPlayerResponse,
  };
  MediaPlayerStub.prototype.validator = validateMediaPlayerRequest;
  MediaPlayerProxy.prototype.validator = validateMediaPlayerResponse;
  var kMediaPlayerObserverClient_GetHasPlayedBefore_Name = 0;

  function MediaPlayerObserverClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaPlayerObserverClient,
                                                   handleOrPtrInfo);
  }

  function MediaPlayerObserverClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaPlayerObserverClient, associatedInterfacePtrInfo);
  }

  MediaPlayerObserverClientAssociatedPtr.prototype =
      Object.create(MediaPlayerObserverClientPtr.prototype);
  MediaPlayerObserverClientAssociatedPtr.prototype.constructor =
      MediaPlayerObserverClientAssociatedPtr;

  function MediaPlayerObserverClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaPlayerObserverClientPtr.prototype.getHasPlayedBefore = function() {
    return MediaPlayerObserverClientProxy.prototype.getHasPlayedBefore
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverClientProxy.prototype.getHasPlayedBefore = function() {
    var params_ = new MediaPlayerObserverClient_GetHasPlayedBefore_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaPlayerObserverClient_GetHasPlayedBefore_Name,
          codec.align(MediaPlayerObserverClient_GetHasPlayedBefore_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaPlayerObserverClient_GetHasPlayedBefore_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function MediaPlayerObserverClientStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaPlayerObserverClientStub.prototype.getHasPlayedBefore = function() {
    return this.delegate_ && this.delegate_.getHasPlayedBefore && this.delegate_.getHasPlayedBefore();
  }

  MediaPlayerObserverClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  MediaPlayerObserverClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaPlayerObserverClient_GetHasPlayedBefore_Name:
      var params = reader.decodeStruct(MediaPlayerObserverClient_GetHasPlayedBefore_Params);
      this.getHasPlayedBefore().then(function(response) {
        var responseParams =
            new MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams();
        responseParams.hasPlayedBefore = response.hasPlayedBefore;
        var builder = new codec.MessageV1Builder(
            kMediaPlayerObserverClient_GetHasPlayedBefore_Name,
            codec.align(MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateMediaPlayerObserverClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaPlayerObserverClient_GetHasPlayedBefore_Name:
        if (message.expectsResponse())
          paramsClass = MediaPlayerObserverClient_GetHasPlayedBefore_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaPlayerObserverClientResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kMediaPlayerObserverClient_GetHasPlayedBefore_Name:
        if (message.isResponse())
          paramsClass = MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var MediaPlayerObserverClient = {
    name: 'media.mojom.MediaPlayerObserverClient',
    kVersion: 0,
    ptrClass: MediaPlayerObserverClientPtr,
    proxyClass: MediaPlayerObserverClientProxy,
    stubClass: MediaPlayerObserverClientStub,
    validateRequest: validateMediaPlayerObserverClientRequest,
    validateResponse: validateMediaPlayerObserverClientResponse,
  };
  MediaPlayerObserverClientStub.prototype.validator = validateMediaPlayerObserverClientRequest;
  MediaPlayerObserverClientProxy.prototype.validator = validateMediaPlayerObserverClientResponse;
  var kMediaPlayerObserver_OnMediaPlaying_Name = 0;
  var kMediaPlayerObserver_OnMediaPaused_Name = 1;
  var kMediaPlayerObserver_OnMutedStatusChanged_Name = 2;
  var kMediaPlayerObserver_OnMediaMetadataChanged_Name = 3;
  var kMediaPlayerObserver_OnMediaPositionStateChanged_Name = 4;
  var kMediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Name = 5;
  var kMediaPlayerObserver_OnMediaSizeChanged_Name = 6;
  var kMediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Name = 7;
  var kMediaPlayerObserver_OnAudioOutputSinkChanged_Name = 8;
  var kMediaPlayerObserver_OnUseAudioServiceChanged_Name = 9;
  var kMediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Name = 10;
  var kMediaPlayerObserver_OnRemotePlaybackMetadataChange_Name = 11;
  var kMediaPlayerObserver_OnVideoVisibilityChanged_Name = 12;

  function MediaPlayerObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaPlayerObserver,
                                                   handleOrPtrInfo);
  }

  function MediaPlayerObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaPlayerObserver, associatedInterfacePtrInfo);
  }

  MediaPlayerObserverAssociatedPtr.prototype =
      Object.create(MediaPlayerObserverPtr.prototype);
  MediaPlayerObserverAssociatedPtr.prototype.constructor =
      MediaPlayerObserverAssociatedPtr;

  function MediaPlayerObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaPlayerObserverPtr.prototype.onMediaPlaying = function() {
    return MediaPlayerObserverProxy.prototype.onMediaPlaying
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onMediaPlaying = function() {
    var params_ = new MediaPlayerObserver_OnMediaPlaying_Params();
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnMediaPlaying_Name,
        codec.align(MediaPlayerObserver_OnMediaPlaying_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnMediaPlaying_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onMediaPaused = function() {
    return MediaPlayerObserverProxy.prototype.onMediaPaused
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onMediaPaused = function(streamEnded) {
    var params_ = new MediaPlayerObserver_OnMediaPaused_Params();
    params_.streamEnded = streamEnded;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnMediaPaused_Name,
        codec.align(MediaPlayerObserver_OnMediaPaused_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnMediaPaused_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onMutedStatusChanged = function() {
    return MediaPlayerObserverProxy.prototype.onMutedStatusChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onMutedStatusChanged = function(muted) {
    var params_ = new MediaPlayerObserver_OnMutedStatusChanged_Params();
    params_.muted = muted;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnMutedStatusChanged_Name,
        codec.align(MediaPlayerObserver_OnMutedStatusChanged_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnMutedStatusChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onMediaMetadataChanged = function() {
    return MediaPlayerObserverProxy.prototype.onMediaMetadataChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onMediaMetadataChanged = function(hasAudio, hasVideo, contentType) {
    var params_ = new MediaPlayerObserver_OnMediaMetadataChanged_Params();
    params_.hasAudio = hasAudio;
    params_.hasVideo = hasVideo;
    params_.contentType = contentType;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnMediaMetadataChanged_Name,
        codec.align(MediaPlayerObserver_OnMediaMetadataChanged_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnMediaMetadataChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onMediaPositionStateChanged = function() {
    return MediaPlayerObserverProxy.prototype.onMediaPositionStateChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onMediaPositionStateChanged = function(mediaPosition) {
    var params_ = new MediaPlayerObserver_OnMediaPositionStateChanged_Params();
    params_.mediaPosition = mediaPosition;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnMediaPositionStateChanged_Name,
        codec.align(MediaPlayerObserver_OnMediaPositionStateChanged_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnMediaPositionStateChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onMediaEffectivelyFullscreenChanged = function() {
    return MediaPlayerObserverProxy.prototype.onMediaEffectivelyFullscreenChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onMediaEffectivelyFullscreenChanged = function(status) {
    var params_ = new MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params();
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Name,
        codec.align(MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onMediaSizeChanged = function() {
    return MediaPlayerObserverProxy.prototype.onMediaSizeChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onMediaSizeChanged = function(size) {
    var params_ = new MediaPlayerObserver_OnMediaSizeChanged_Params();
    params_.size = size;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnMediaSizeChanged_Name,
        codec.align(MediaPlayerObserver_OnMediaSizeChanged_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnMediaSizeChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onPictureInPictureAvailabilityChanged = function() {
    return MediaPlayerObserverProxy.prototype.onPictureInPictureAvailabilityChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onPictureInPictureAvailabilityChanged = function(available) {
    var params_ = new MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params();
    params_.available = available;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Name,
        codec.align(MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onAudioOutputSinkChanged = function() {
    return MediaPlayerObserverProxy.prototype.onAudioOutputSinkChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onAudioOutputSinkChanged = function(hashedDeviceId) {
    var params_ = new MediaPlayerObserver_OnAudioOutputSinkChanged_Params();
    params_.hashedDeviceId = hashedDeviceId;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnAudioOutputSinkChanged_Name,
        codec.align(MediaPlayerObserver_OnAudioOutputSinkChanged_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnAudioOutputSinkChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onUseAudioServiceChanged = function() {
    return MediaPlayerObserverProxy.prototype.onUseAudioServiceChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onUseAudioServiceChanged = function(usesAudioService) {
    var params_ = new MediaPlayerObserver_OnUseAudioServiceChanged_Params();
    params_.usesAudioService = usesAudioService;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnUseAudioServiceChanged_Name,
        codec.align(MediaPlayerObserver_OnUseAudioServiceChanged_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnUseAudioServiceChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onAudioOutputSinkChangingDisabled = function() {
    return MediaPlayerObserverProxy.prototype.onAudioOutputSinkChangingDisabled
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onAudioOutputSinkChangingDisabled = function() {
    var params_ = new MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params();
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Name,
        codec.align(MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onRemotePlaybackMetadataChange = function() {
    return MediaPlayerObserverProxy.prototype.onRemotePlaybackMetadataChange
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onRemotePlaybackMetadataChange = function(remotePlaybackMetadata) {
    var params_ = new MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params();
    params_.remotePlaybackMetadata = remotePlaybackMetadata;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnRemotePlaybackMetadataChange_Name,
        codec.align(MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaPlayerObserverPtr.prototype.onVideoVisibilityChanged = function() {
    return MediaPlayerObserverProxy.prototype.onVideoVisibilityChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerObserverProxy.prototype.onVideoVisibilityChanged = function(meetsVisibilityThreshold) {
    var params_ = new MediaPlayerObserver_OnVideoVisibilityChanged_Params();
    params_.meetsVisibilityThreshold = meetsVisibilityThreshold;
    var builder = new codec.MessageV0Builder(
        kMediaPlayerObserver_OnVideoVisibilityChanged_Name,
        codec.align(MediaPlayerObserver_OnVideoVisibilityChanged_Params.encodedSize));
    builder.encodeStruct(MediaPlayerObserver_OnVideoVisibilityChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MediaPlayerObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaPlayerObserverStub.prototype.onMediaPlaying = function() {
    return this.delegate_ && this.delegate_.onMediaPlaying && this.delegate_.onMediaPlaying();
  }
  MediaPlayerObserverStub.prototype.onMediaPaused = function(streamEnded) {
    return this.delegate_ && this.delegate_.onMediaPaused && this.delegate_.onMediaPaused(streamEnded);
  }
  MediaPlayerObserverStub.prototype.onMutedStatusChanged = function(muted) {
    return this.delegate_ && this.delegate_.onMutedStatusChanged && this.delegate_.onMutedStatusChanged(muted);
  }
  MediaPlayerObserverStub.prototype.onMediaMetadataChanged = function(hasAudio, hasVideo, contentType) {
    return this.delegate_ && this.delegate_.onMediaMetadataChanged && this.delegate_.onMediaMetadataChanged(hasAudio, hasVideo, contentType);
  }
  MediaPlayerObserverStub.prototype.onMediaPositionStateChanged = function(mediaPosition) {
    return this.delegate_ && this.delegate_.onMediaPositionStateChanged && this.delegate_.onMediaPositionStateChanged(mediaPosition);
  }
  MediaPlayerObserverStub.prototype.onMediaEffectivelyFullscreenChanged = function(status) {
    return this.delegate_ && this.delegate_.onMediaEffectivelyFullscreenChanged && this.delegate_.onMediaEffectivelyFullscreenChanged(status);
  }
  MediaPlayerObserverStub.prototype.onMediaSizeChanged = function(size) {
    return this.delegate_ && this.delegate_.onMediaSizeChanged && this.delegate_.onMediaSizeChanged(size);
  }
  MediaPlayerObserverStub.prototype.onPictureInPictureAvailabilityChanged = function(available) {
    return this.delegate_ && this.delegate_.onPictureInPictureAvailabilityChanged && this.delegate_.onPictureInPictureAvailabilityChanged(available);
  }
  MediaPlayerObserverStub.prototype.onAudioOutputSinkChanged = function(hashedDeviceId) {
    return this.delegate_ && this.delegate_.onAudioOutputSinkChanged && this.delegate_.onAudioOutputSinkChanged(hashedDeviceId);
  }
  MediaPlayerObserverStub.prototype.onUseAudioServiceChanged = function(usesAudioService) {
    return this.delegate_ && this.delegate_.onUseAudioServiceChanged && this.delegate_.onUseAudioServiceChanged(usesAudioService);
  }
  MediaPlayerObserverStub.prototype.onAudioOutputSinkChangingDisabled = function() {
    return this.delegate_ && this.delegate_.onAudioOutputSinkChangingDisabled && this.delegate_.onAudioOutputSinkChangingDisabled();
  }
  MediaPlayerObserverStub.prototype.onRemotePlaybackMetadataChange = function(remotePlaybackMetadata) {
    return this.delegate_ && this.delegate_.onRemotePlaybackMetadataChange && this.delegate_.onRemotePlaybackMetadataChange(remotePlaybackMetadata);
  }
  MediaPlayerObserverStub.prototype.onVideoVisibilityChanged = function(meetsVisibilityThreshold) {
    return this.delegate_ && this.delegate_.onVideoVisibilityChanged && this.delegate_.onVideoVisibilityChanged(meetsVisibilityThreshold);
  }

  MediaPlayerObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaPlayerObserver_OnMediaPlaying_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnMediaPlaying_Params);
      this.onMediaPlaying();
      return true;
    case kMediaPlayerObserver_OnMediaPaused_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnMediaPaused_Params);
      this.onMediaPaused(params.streamEnded);
      return true;
    case kMediaPlayerObserver_OnMutedStatusChanged_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnMutedStatusChanged_Params);
      this.onMutedStatusChanged(params.muted);
      return true;
    case kMediaPlayerObserver_OnMediaMetadataChanged_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnMediaMetadataChanged_Params);
      this.onMediaMetadataChanged(params.hasAudio, params.hasVideo, params.contentType);
      return true;
    case kMediaPlayerObserver_OnMediaPositionStateChanged_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnMediaPositionStateChanged_Params);
      this.onMediaPositionStateChanged(params.mediaPosition);
      return true;
    case kMediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params);
      this.onMediaEffectivelyFullscreenChanged(params.status);
      return true;
    case kMediaPlayerObserver_OnMediaSizeChanged_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnMediaSizeChanged_Params);
      this.onMediaSizeChanged(params.size);
      return true;
    case kMediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params);
      this.onPictureInPictureAvailabilityChanged(params.available);
      return true;
    case kMediaPlayerObserver_OnAudioOutputSinkChanged_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnAudioOutputSinkChanged_Params);
      this.onAudioOutputSinkChanged(params.hashedDeviceId);
      return true;
    case kMediaPlayerObserver_OnUseAudioServiceChanged_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnUseAudioServiceChanged_Params);
      this.onUseAudioServiceChanged(params.usesAudioService);
      return true;
    case kMediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params);
      this.onAudioOutputSinkChangingDisabled();
      return true;
    case kMediaPlayerObserver_OnRemotePlaybackMetadataChange_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params);
      this.onRemotePlaybackMetadataChange(params.remotePlaybackMetadata);
      return true;
    case kMediaPlayerObserver_OnVideoVisibilityChanged_Name:
      var params = reader.decodeStruct(MediaPlayerObserver_OnVideoVisibilityChanged_Params);
      this.onVideoVisibilityChanged(params.meetsVisibilityThreshold);
      return true;
    default:
      return false;
    }
  };

  MediaPlayerObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMediaPlayerObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaPlayerObserver_OnMediaPlaying_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnMediaPlaying_Params;
      break;
      case kMediaPlayerObserver_OnMediaPaused_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnMediaPaused_Params;
      break;
      case kMediaPlayerObserver_OnMutedStatusChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnMutedStatusChanged_Params;
      break;
      case kMediaPlayerObserver_OnMediaMetadataChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnMediaMetadataChanged_Params;
      break;
      case kMediaPlayerObserver_OnMediaPositionStateChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnMediaPositionStateChanged_Params;
      break;
      case kMediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params;
      break;
      case kMediaPlayerObserver_OnMediaSizeChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnMediaSizeChanged_Params;
      break;
      case kMediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params;
      break;
      case kMediaPlayerObserver_OnAudioOutputSinkChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnAudioOutputSinkChanged_Params;
      break;
      case kMediaPlayerObserver_OnUseAudioServiceChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnUseAudioServiceChanged_Params;
      break;
      case kMediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params;
      break;
      case kMediaPlayerObserver_OnRemotePlaybackMetadataChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params;
      break;
      case kMediaPlayerObserver_OnVideoVisibilityChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerObserver_OnVideoVisibilityChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaPlayerObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MediaPlayerObserver = {
    name: 'media.mojom.MediaPlayerObserver',
    kVersion: 0,
    ptrClass: MediaPlayerObserverPtr,
    proxyClass: MediaPlayerObserverProxy,
    stubClass: MediaPlayerObserverStub,
    validateRequest: validateMediaPlayerObserverRequest,
    validateResponse: null,
  };
  MediaPlayerObserverStub.prototype.validator = validateMediaPlayerObserverRequest;
  MediaPlayerObserverProxy.prototype.validator = null;
  var kMediaPlayerHost_OnMediaPlayerAdded_Name = 0;

  function MediaPlayerHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaPlayerHost,
                                                   handleOrPtrInfo);
  }

  function MediaPlayerHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaPlayerHost, associatedInterfacePtrInfo);
  }

  MediaPlayerHostAssociatedPtr.prototype =
      Object.create(MediaPlayerHostPtr.prototype);
  MediaPlayerHostAssociatedPtr.prototype.constructor =
      MediaPlayerHostAssociatedPtr;

  function MediaPlayerHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaPlayerHostPtr.prototype.onMediaPlayerAdded = function() {
    return MediaPlayerHostProxy.prototype.onMediaPlayerAdded
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaPlayerHostProxy.prototype.onMediaPlayerAdded = function(playerRemote, observer, playerId) {
    var params_ = new MediaPlayerHost_OnMediaPlayerAdded_Params();
    params_.playerRemote = playerRemote;
    params_.observer = observer;
    params_.playerId = playerId;
    var builder = new codec.MessageV2Builder(
        kMediaPlayerHost_OnMediaPlayerAdded_Name,
        codec.align(MediaPlayerHost_OnMediaPlayerAdded_Params.encodedSize));
    builder.setPayload(MediaPlayerHost_OnMediaPlayerAdded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MediaPlayerHostStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaPlayerHostStub.prototype.onMediaPlayerAdded = function(playerRemote, observer, playerId) {
    return this.delegate_ && this.delegate_.onMediaPlayerAdded && this.delegate_.onMediaPlayerAdded(playerRemote, observer, playerId);
  }

  MediaPlayerHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaPlayerHost_OnMediaPlayerAdded_Name:
      var params = reader.decodeStruct(MediaPlayerHost_OnMediaPlayerAdded_Params);
      this.onMediaPlayerAdded(params.playerRemote, params.observer, params.playerId);
      return true;
    default:
      return false;
    }
  };

  MediaPlayerHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMediaPlayerHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaPlayerHost_OnMediaPlayerAdded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaPlayerHost_OnMediaPlayerAdded_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaPlayerHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MediaPlayerHost = {
    name: 'media.mojom.MediaPlayerHost',
    kVersion: 0,
    ptrClass: MediaPlayerHostPtr,
    proxyClass: MediaPlayerHostProxy,
    stubClass: MediaPlayerHostStub,
    validateRequest: validateMediaPlayerHostRequest,
    validateResponse: null,
  };
  MediaPlayerHostStub.prototype.validator = validateMediaPlayerHostRequest;
  MediaPlayerHostProxy.prototype.validator = null;
  exports.MediaPlayer = MediaPlayer;
  exports.MediaPlayerPtr = MediaPlayerPtr;
  exports.MediaPlayerAssociatedPtr = MediaPlayerAssociatedPtr;
  exports.MediaPlayerObserverClient = MediaPlayerObserverClient;
  exports.MediaPlayerObserverClientPtr = MediaPlayerObserverClientPtr;
  exports.MediaPlayerObserverClientAssociatedPtr = MediaPlayerObserverClientAssociatedPtr;
  exports.MediaPlayerObserver = MediaPlayerObserver;
  exports.MediaPlayerObserverPtr = MediaPlayerObserverPtr;
  exports.MediaPlayerObserverAssociatedPtr = MediaPlayerObserverAssociatedPtr;
  exports.MediaPlayerHost = MediaPlayerHost;
  exports.MediaPlayerHostPtr = MediaPlayerHostPtr;
  exports.MediaPlayerHostAssociatedPtr = MediaPlayerHostAssociatedPtr;
})();