// media/mojo/mojom/media_player.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_PLAYER_MOJOM_H_
#define MEDIA_MOJO_MOJOM_MEDIA_PLAYER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/media_player.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_player.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_player.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/media_session/public/mojom/media_session.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class MediaPlayerProxy;

template <typename ImplRefTraits>
class MediaPlayerStub;

class MediaPlayerRequestValidator;
class MediaPlayerResponseValidator;


class MediaPlayer
    : public MediaPlayerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.MediaPlayer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaPlayerInterfaceBase;
  using Proxy_ = MediaPlayerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaPlayerStub<ImplRefTraits>;

  using RequestValidator_ = MediaPlayerRequestValidator;
  using ResponseValidator_ = MediaPlayerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestPlayMinVersion = 0,
    kRequestPauseMinVersion = 0,
    kRequestSeekForwardMinVersion = 0,
    kRequestSeekBackwardMinVersion = 0,
    kRequestSeekToMinVersion = 0,
    kRequestEnterPictureInPictureMinVersion = 0,
    kRequestMuteMinVersion = 0,
    kSetVolumeMultiplierMinVersion = 0,
    kSetPersistentStateMinVersion = 0,
    kSetPowerExperimentStateMinVersion = 0,
    kSetAudioSinkIdMinVersion = 0,
    kSuspendForFrameClosedMinVersion = 0,
    kRequestMediaRemotingMinVersion = 0,
    kRequestVisibilityMinVersion = 0,
    kRecordAutoPictureInPictureInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestPlay_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestPause_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestSeekForward_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestSeekBackward_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestSeekTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestEnterPictureInPicture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestMute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVolumeMultiplier_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPersistentState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPowerExperimentState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAudioSinkId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SuspendForFrameClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestMediaRemoting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordAutoPictureInPictureInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaPlayer() = default;

  virtual void RequestPlay() = 0;

  virtual void RequestPause(bool triggered_by_user) = 0;

  virtual void RequestSeekForward(::base::TimeDelta seek_time) = 0;

  virtual void RequestSeekBackward(::base::TimeDelta seek_time) = 0;

  virtual void RequestSeekTo(::base::TimeDelta seek_time) = 0;

  virtual void RequestEnterPictureInPicture() = 0;

  virtual void RequestMute(bool mute) = 0;

  virtual void SetVolumeMultiplier(double multiplier) = 0;

  virtual void SetPersistentState(bool persistent) = 0;

  virtual void SetPowerExperimentState(bool enabled) = 0;

  virtual void SetAudioSinkId(const std::string& sink_id) = 0;

  virtual void SuspendForFrameClosed() = 0;

  virtual void RequestMediaRemoting() = 0;

  using RequestVisibilityCallback = base::OnceCallback<void(bool)>;
  using RequestVisibilityMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RequestVisibility(RequestVisibilityCallback callback) = 0;

  virtual void RecordAutoPictureInPictureInfo(const ::media::PictureInPictureEventsInfo::AutoPipInfo& auto_picture_in_picture_info) = 0;
};

class MediaPlayerObserverClientProxy;

template <typename ImplRefTraits>
class MediaPlayerObserverClientStub;

class MediaPlayerObserverClientRequestValidator;
class MediaPlayerObserverClientResponseValidator;


class MediaPlayerObserverClient
    : public MediaPlayerObserverClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.MediaPlayerObserverClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaPlayerObserverClientInterfaceBase;
  using Proxy_ = MediaPlayerObserverClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaPlayerObserverClientStub<ImplRefTraits>;

  using RequestValidator_ = MediaPlayerObserverClientRequestValidator;
  using ResponseValidator_ = MediaPlayerObserverClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetHasPlayedBeforeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetHasPlayedBefore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaPlayerObserverClient() = default;

  using GetHasPlayedBeforeCallback = base::OnceCallback<void(bool)>;
  using GetHasPlayedBeforeMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetHasPlayedBefore(GetHasPlayedBeforeCallback callback) = 0;
};

class MediaPlayerObserverProxy;

template <typename ImplRefTraits>
class MediaPlayerObserverStub;

class MediaPlayerObserverRequestValidator;


class MediaPlayerObserver
    : public MediaPlayerObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.MediaPlayerObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaPlayerObserverInterfaceBase;
  using Proxy_ = MediaPlayerObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaPlayerObserverStub<ImplRefTraits>;

  using RequestValidator_ = MediaPlayerObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnMediaPlayingMinVersion = 0,
    kOnMediaPausedMinVersion = 0,
    kOnMutedStatusChangedMinVersion = 0,
    kOnMediaMetadataChangedMinVersion = 0,
    kOnMediaPositionStateChangedMinVersion = 0,
    kOnMediaEffectivelyFullscreenChangedMinVersion = 0,
    kOnMediaSizeChangedMinVersion = 0,
    kOnPictureInPictureAvailabilityChangedMinVersion = 0,
    kOnAudioOutputSinkChangedMinVersion = 0,
    kOnUseAudioServiceChangedMinVersion = 0,
    kOnAudioOutputSinkChangingDisabledMinVersion = 0,
    kOnRemotePlaybackMetadataChangeMinVersion = 0,
    kOnVideoVisibilityChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnMediaPlaying_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMediaPaused_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMutedStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMediaMetadataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMediaPositionStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMediaEffectivelyFullscreenChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMediaSizeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPictureInPictureAvailabilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAudioOutputSinkChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnUseAudioServiceChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAudioOutputSinkChangingDisabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRemotePlaybackMetadataChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVideoVisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaPlayerObserver() = default;

  virtual void OnMediaPlaying() = 0;

  virtual void OnMediaPaused(bool stream_ended) = 0;

  virtual void OnMutedStatusChanged(bool muted) = 0;

  virtual void OnMediaMetadataChanged(bool has_audio, bool has_video, ::media::MediaContentType content_type) = 0;

  virtual void OnMediaPositionStateChanged(const ::media_session::MediaPosition& media_position) = 0;

  virtual void OnMediaEffectivelyFullscreenChanged(::blink::WebFullscreenVideoStatus status) = 0;

  virtual void OnMediaSizeChanged(const ::gfx::Size& size) = 0;

  virtual void OnPictureInPictureAvailabilityChanged(bool available) = 0;

  virtual void OnAudioOutputSinkChanged(const std::string& hashed_device_id) = 0;

  virtual void OnUseAudioServiceChanged(bool uses_audio_service) = 0;

  virtual void OnAudioOutputSinkChangingDisabled() = 0;

  virtual void OnRemotePlaybackMetadataChange(::media_session::mojom::RemotePlaybackMetadataPtr remote_playback_metadata) = 0;

  virtual void OnVideoVisibilityChanged(bool meets_visibility_threshold) = 0;
};

class MediaPlayerHostProxy;

template <typename ImplRefTraits>
class MediaPlayerHostStub;

class MediaPlayerHostRequestValidator;


class MediaPlayerHost
    : public MediaPlayerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.MediaPlayerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaPlayerHostInterfaceBase;
  using Proxy_ = MediaPlayerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaPlayerHostStub<ImplRefTraits>;

  using RequestValidator_ = MediaPlayerHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnMediaPlayerAddedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnMediaPlayerAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaPlayerHost() = default;

  virtual void OnMediaPlayerAdded(::mojo::PendingAssociatedRemote<MediaPlayer> player_remote, ::mojo::PendingAssociatedReceiver<MediaPlayerObserver> observer, int32_t player_id) = 0;
};



class  MediaPlayerProxy
    : public MediaPlayer {
 public:
  using InterfaceType = MediaPlayer;

  explicit MediaPlayerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestPlay() final;
  
  void RequestPause(bool triggered_by_user) final;
  
  void RequestSeekForward(::base::TimeDelta seek_time) final;
  
  void RequestSeekBackward(::base::TimeDelta seek_time) final;
  
  void RequestSeekTo(::base::TimeDelta seek_time) final;
  
  void RequestEnterPictureInPicture() final;
  
  void RequestMute(bool mute) final;
  
  void SetVolumeMultiplier(double multiplier) final;
  
  void SetPersistentState(bool persistent) final;
  
  void SetPowerExperimentState(bool enabled) final;
  
  void SetAudioSinkId(const std::string& sink_id) final;
  
  void SuspendForFrameClosed() final;
  
  void RequestMediaRemoting() final;
  
  void RequestVisibility(RequestVisibilityCallback callback) final;
  
  void RecordAutoPictureInPictureInfo(const ::media::PictureInPictureEventsInfo::AutoPipInfo& auto_picture_in_picture_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaPlayerObserverClientProxy
    : public MediaPlayerObserverClient {
 public:
  using InterfaceType = MediaPlayerObserverClient;

  explicit MediaPlayerObserverClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetHasPlayedBefore(GetHasPlayedBeforeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaPlayerObserverProxy
    : public MediaPlayerObserver {
 public:
  using InterfaceType = MediaPlayerObserver;

  explicit MediaPlayerObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnMediaPlaying() final;
  
  void OnMediaPaused(bool stream_ended) final;
  
  void OnMutedStatusChanged(bool muted) final;
  
  void OnMediaMetadataChanged(bool has_audio, bool has_video, ::media::MediaContentType content_type) final;
  
  void OnMediaPositionStateChanged(const ::media_session::MediaPosition& media_position) final;
  
  void OnMediaEffectivelyFullscreenChanged(::blink::WebFullscreenVideoStatus status) final;
  
  void OnMediaSizeChanged(const ::gfx::Size& size) final;
  
  void OnPictureInPictureAvailabilityChanged(bool available) final;
  
  void OnAudioOutputSinkChanged(const std::string& hashed_device_id) final;
  
  void OnUseAudioServiceChanged(bool uses_audio_service) final;
  
  void OnAudioOutputSinkChangingDisabled() final;
  
  void OnRemotePlaybackMetadataChange(::media_session::mojom::RemotePlaybackMetadataPtr remote_playback_metadata) final;
  
  void OnVideoVisibilityChanged(bool meets_visibility_threshold) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaPlayerHostProxy
    : public MediaPlayerHost {
 public:
  using InterfaceType = MediaPlayerHost;

  explicit MediaPlayerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnMediaPlayerAdded(::mojo::PendingAssociatedRemote<MediaPlayer> player_remote, ::mojo::PendingAssociatedReceiver<MediaPlayerObserver> observer, int32_t player_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaPlayerStubDispatch {
 public:
  static bool Accept(MediaPlayer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaPlayer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaPlayer>>
class MediaPlayerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaPlayerStub() = default;
  ~MediaPlayerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaPlayerObserverClientStubDispatch {
 public:
  static bool Accept(MediaPlayerObserverClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaPlayerObserverClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaPlayerObserverClient>>
class MediaPlayerObserverClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaPlayerObserverClientStub() = default;
  ~MediaPlayerObserverClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerObserverClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerObserverClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaPlayerObserverStubDispatch {
 public:
  static bool Accept(MediaPlayerObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaPlayerObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaPlayerObserver>>
class MediaPlayerObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaPlayerObserverStub() = default;
  ~MediaPlayerObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaPlayerHostStubDispatch {
 public:
  static bool Accept(MediaPlayerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaPlayerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaPlayerHost>>
class MediaPlayerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaPlayerHostStub() = default;
  ~MediaPlayerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaPlayerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaPlayerObserverClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaPlayerObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaPlayerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaPlayerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaPlayerObserverClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_MEDIA_PLAYER_MOJOM_H_